/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.util.Assert;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferProps;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.ModelUtil;

public class ReconcileTreeNode
extends DefaultMutableTreeNode {
    private static Comparator s_changeNodeComparator = new ReconcileNodeComparator(null);
    protected boolean m_changed;
    protected boolean m_from;
    protected boolean m_fromA;
    protected boolean m_highLighted;
    protected boolean m_shuttled;
    private boolean m_justShuttled;
    private boolean m_childShuttled;
    private Set m_dependantChanges;
    private DBObject m_dbObject;
    private String m_tootipPrefix;
    private ReconcileTreeNode m_partner;
    protected Icon m_icon;
    protected Icon m_shuttledIcon;
    protected String m_text;
    protected String m_shuttledText;
    private Color m_background;
    private Color m_shuttledBackground;
    private Color m_highLightBackground;
    private static final Color BACKGROUND = Color.WHITE;
    private static HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
    private static Class ehl = null;
    protected static HashMap s_nameMap;
    private static String[] s_onDelete;
    private static HashMap s_intDecode;
    private static String[] s_order;

    private void $init$() {
        this.m_highLighted = false;
        this.m_shuttled = false;
        this.m_justShuttled = false;
        this.m_childShuttled = false;
        this.m_dependantChanges = new HashSet();
        this.m_tootipPrefix = "";
    }

    static {
        try {
            ehl = Class.forName("oracle.javatools.compare.view.wedge.EditorHighlighter");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Cant load EditorHighlighter");
        }
        s_nameMap = new HashMap();
        s_nameMap.put("indexes", TransferArb.getString(22));
        s_nameMap.put("constraints", TransferArb.getString(128));
        s_nameMap.put("TableType", TransferArb.getString(207));
        s_nameMap.put("PARTITIONED TABLE", TransferArb.getString(185));
        s_nameMap.put("columns", TransferArb.getString(139));
        s_nameMap.put("name", TransferArb.getString(99));
        s_nameMap.put("schema", TransferArb.getString(145));
        s_nameMap.put("defaultTablespace", TransferArb.getString(103));
        s_nameMap.put("temporaryTablespace", TransferArb.getString(40));
        s_nameMap.put("properties", TransferArb.getString(130));
        s_nameMap.put("columnIDs", TransferArb.getString(255));
        s_nameMap.put("LOBProperties", TransferArb.getString(5));
        s_nameMap.put("VAProperties", TransferArb.getString(5));
        s_nameMap.put("nestedTableProperties", TransferArb.getString(37));
        s_nameMap.put("OracleStorageProperties", TransferArb.getString(171));
        s_nameMap.put("bufferMode", TransferArb.getString(192));
        s_nameMap.put("freelists", TransferArb.getString(205));
        s_nameMap.put("freelistGroups", TransferArb.getString(84));
        s_nameMap.put("initialExtent", TransferArb.getString(241));
        s_nameMap.put("initrans", TransferArb.getString(136));
        s_nameMap.put("logging", TransferArb.getString(193));
        s_nameMap.put("maxExtent", TransferArb.getString(91));
        s_nameMap.put("maxtrans", TransferArb.getString(154));
        s_nameMap.put("minExtent", TransferArb.getString(240));
        s_nameMap.put("nextExtent", TransferArb.getString(66));
        s_nameMap.put("percentFree", TransferArb.getString(9));
        s_nameMap.put("percentIncrease", TransferArb.getString(260));
        s_nameMap.put("pctUsed", TransferArb.getString(211));
        s_nameMap.put("tablespace", TransferArb.getString(172));
        s_nameMap.put("OracleIndexOrganizedTableProperties", TransferArb.getString(210));
        s_nameMap.put("overflowProperties", TransferArb.getString(48));
        s_nameMap.put("overflowable", TransferArb.getString(115));
        s_nameMap.put("pctThreshold", TransferArb.getString(186));
        s_nameMap.put("keyCompression", TransferArb.getString(16));
        s_nameMap.put("mapped", TransferArb.getString(46));
        s_nameMap.put("includeColumn", TransferArb.getString(123));
        s_nameMap.put("OracleExternalTableProperties", TransferArb.getString(237));
        s_nameMap.put("accessDriverType", TransferArb.getString(81));
        s_nameMap.put("accessUsingClob", TransferArb.getString(144));
        s_nameMap.put("accessParameters", TransferArb.getString(222));
        s_nameMap.put("defaultDirectory", TransferArb.getString(133));
        s_nameMap.put("projectColumn", TransferArb.getString(229));
        s_nameMap.put("rejectLimit", TransferArb.getString(254));
        s_nameMap.put("locationSpecifiers", TransferArb.getString(44));
        s_nameMap.put("directory", TransferArb.getString(57));
        s_nameMap.put("specifier", TransferArb.getString(118));
        s_nameMap.put("OracleTablePartitions", TransferArb.getString(179));
        s_nameMap.put("partitionType", TransferArb.getString(122));
        s_nameMap.put("partitionColumns", TransferArb.getString(27));
        s_nameMap.put("partitions", TransferArb.getString(1));
        s_nameMap.put("subpartitions", TransferArb.getString(117));
        s_nameMap.put("segmentAttributes", TransferArb.getString(171));
        s_nameMap.put("values", TransferArb.getString(59));
        s_nameMap.put("compression", TransferArb.getString(247));
        s_nameMap.put(OracleTablePartitions.ObjectType.PARTITION.name(), TransferArb.getString(179));
        s_nameMap.put(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION.name(), TransferArb.getString(60));
        s_nameMap.put(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE.name(), TransferArb.getString(191));
        s_nameMap.put(OracleTablePartitions.ObjectType.SUBPARTITION.name(), TransferArb.getString(60));
        s_nameMap.put("subpartitionModel", TransferArb.getString(60));
        s_nameMap.put("LOBDescriptors", TransferArb.getString(5));
        s_nameMap.put("storage", TransferArb.getString(171));
        s_nameMap.put("cache", TransferArb.getString(201));
        s_nameMap.put("chunk", TransferArb.getString(164));
        s_nameMap.put("freepools", TransferArb.getString(169));
        s_nameMap.put("LOBSegName", TransferArb.getString(65));
        s_nameMap.put("pctVersion", TransferArb.getString(204));
        s_nameMap.put("retention", TransferArb.getString(213));
        s_nameMap.put("storageEnabledInRow", TransferArb.getString(24));
        s_nameMap.put("notNull", TransferArb.getString(151));
        s_nameMap.put("dataTypeUsage", TransferArb.getString(214));
        s_nameMap.put("scale", TransferArb.getString(107));
        s_nameMap.put("precision", TransferArb.getString(20));
        s_nameMap.put("dataTypeID", TransferArb.getString(150));
        s_nameMap.put("default", TransferArb.getString(112));
        s_nameMap.put("Comment", TransferArb.getString(153));
        s_nameMap.put("deleteMode", TransferArb.getString(120));
        s_nameMap.put("ReferencedSchema", TransferArb.getString(6));
        s_nameMap.put("enabled", TransferArb.getString(125));
        s_nameMap.put("ReferencedRelation", TransferArb.getString(257));
        s_nameMap.put("ReferencedColumn", TransferArb.getString(63));
        s_nameMap.put("ReferencedConstraintName", TransferArb.getString(50));
        s_nameMap.put("indexType", TransferArb.getString(173));
        s_nameMap.put("columnExpressions", TransferArb.getString(245));
        s_nameMap.put("parallelDegree", TransferArb.getString(10));
        s_nameMap.put("domainIndextype", TransferArb.getString(221));
        s_nameMap.put("domainIndextypeParameters", TransferArb.getString(111));
        s_nameMap.put("OracleIndexPartitions", TransferArb.getString(179));
        s_nameMap.put("valuesLessThan", TransferArb.getString(59));
        s_nameMap.put("domainParameters", TransferArb.getString(111));
        s_nameMap.put("globalPartitionColumns", TransferArb.getString(19));
        s_nameMap.put("subpartitioning", TransferArb.getString(60));
        s_nameMap.put("forceOnCreate", TransferArb.getString(114));
        s_nameMap.put("queryRestriction", TransferArb.getString(223));
        s_nameMap.put("SQLQuery", TransferArb.getString(195));
        s_nameMap.put("code", TransferArb.getString(105));
        s_nameMap.put("baseType", TransferArb.getString(217));
        s_nameMap.put("events", TransferArb.getString(56));
        s_nameMap.put("timing", TransferArb.getString(143));
        s_nameMap.put("whenClause", TransferArb.getString(41));
        s_nameMap.put("referenceNames", TransferArb.getString(224));
        s_nameMap.put("statementLevel", TransferArb.getString(132));
        s_onDelete = new String[]{TransferArb.getString(219), TransferArb.getString(54), TransferArb.getString(158)};
        s_intDecode = new HashMap();
        s_intDecode.put("deleteMode", s_onDelete);
        s_order = new String[]{"name", "TableType", "PARTITIONED TABLE", "schema", "columns", "constraints", "indexes", "dataTypeUsage", "default", "notNull", "Comment", "enabled", "deleteMode", "ReferencedSchema", "ReferencedRelation", "ReferencedConstraintName", "ReferencedColumn", "OracleIndexOrganizedTableProperties", "tablespace", "percentFree", "pctUsed", "initrans", "maxtrans", "initialExtent", "nextExtent", "minExtent", "maxExtent", "percentIncrease", "freelists", "freelistGroups", "bufferMode", "pctThreshold", "keyCompression", "mapped", "overflowable", "includeColumn", "overflowProperties", "defaultDirectory", "projectColumn", "rejectLimit", "accessDriverType", "accessUsingClob", "accessParameters", "locationSpecifiers", "directory", "specifier", "indexType", "columnExpressions", "partitionType", "partitionColumns", "globalPartitionColumns", "partitions", "cache", "chunk", "freepools", "LOBSegName", "pctVersion", "retention", "storage", "storageEnabledInRow", "timing", "events", "columnIDs", "baseType", "tableOwner", "tableID", "statementLevel", "referenceNames", "whenClause", "code"};
    }

    public ReconcileTreeNode(ResultSet rs) {
        super(rs);
        this.$init$();
    }

    public ReconcileTreeNode(boolean fromA, boolean from, ResultSet rs, boolean changed) {
        this(rs);
        this.m_changed = changed;
        this.m_fromA = fromA;
        this.m_from = from;
        this.m_shuttled = TransferProps.isShuttled(rs);
        Object o = rs.b();
        if (from && this.m_fromA) {
            o = rs.a();
        }
        if ("MAP".equals(rs.getType()) && o instanceof DBObject) {
            this.m_dbObject = (DBObject)o;
            DBObject parent = this.m_dbObject.getParent();
            String ps = "";
            if (parent != null) {
                ps = this.initCap(parent.getType()) + ":" + parent.getName() + " ";
            }
            this.m_tootipPrefix = ps + this.initCap(this.m_dbObject.getType()) + ":" + this.m_dbObject.getName() + "<br>";
        }
        this.setIcon();
        this.setText();
        this.setColor();
    }

    private String initCap(String in) {
        char[] ca = in.toLowerCase().toCharArray();
        ca[0] = Character.toUpperCase(ca[0]);
        return new String(ca);
    }

    public ReconcileTreeNode(boolean from, ResultSet rs, boolean changed) {
        this(false, from, rs, changed);
    }

    public void setFromA(boolean fromA) {
        this.m_fromA = fromA;
    }

    public boolean isFromA() {
        return this.m_fromA;
    }

    public static List orderChildren(ResultSet rs, List children) {
        ArrayList work = new ArrayList(children);
        ArrayList orderedKids = new ArrayList();
        Object dataTypeUsage = null;
        for (String thing : Arrays.asList(s_order)) {
            int index = work.indexOf(thing);
            while (index >= 0) {
                orderedKids.add(work.remove(index));
                index = work.indexOf(thing);
            }
        }
        orderedKids.addAll(work);
        return orderedKids;
    }

    private boolean isMap() {
        ResultSet rs = this.getResultSet();
        String type = rs.getType();
        return "MAP".equals(type) && rs.getAllObjectsMap().size() > 0;
    }

    public boolean isLeaf() {
        ResultSet rs = this.getResultSet();
        String type = rs.getType();
        if ("MAP".equals(type) && (rs.getAllObjectsMap().size() == 0 || "SQLQuery".equals(rs.getName()))) {
            return true;
        }
        return "LEAF".equals(type);
    }

    public boolean isAdd() {
        ResultSet rs = this.getResultSet();
        Object fromObj = this.m_fromA ? rs.a() : rs.b();
        Object toObj = !this.m_fromA ? rs.a() : rs.b();
        return rs != null && !rs.isSame() && toObj == null && fromObj != null;
    }

    public boolean isDrop() {
        ResultSet rs = this.getResultSet();
        Object fromObj = this.m_fromA ? rs.a() : rs.b();
        Object toObj = !this.m_fromA ? rs.a() : rs.b();
        return rs != null && !rs.isSame() && toObj != null && fromObj == null;
    }

    public boolean isChange() {
        ResultSet rs = this.getResultSet();
        Object fromObj = this.m_fromA ? rs.a() : rs.b();
        Object toObj = !this.m_fromA ? rs.a() : rs.b();
        return this.m_changed && toObj != null && fromObj != null;
    }

    public boolean isListReOrdered() {
        ResultSet rs = this.getResultSet();
        return "LIST".equals(rs.getType()) && rs.isChildListReorder();
    }

    private String decode(String name, String value) {
        int v;
        String[] decodeArray;
        String result = value;
        if (value != null && (decodeArray = (String[])s_intDecode.get(name)) != null && (v = Integer.parseInt(value)) < decodeArray.length) {
            result = decodeArray[v];
        }
        return result;
    }

    private String getAVal() {
        ResultSet rs = this.getResultSet();
        String result = this.getVal(DisplayProps.getAVal((ResultSet)rs), rs.a());
        return result;
    }

    private String getBVal() {
        ResultSet rs = this.getResultSet();
        String result = this.getVal(DisplayProps.getBVal((ResultSet)rs), rs.b());
        return result;
    }

    private String getVal(String val, Object o) {
        String result = val;
        if (val == null && this.isLeaf() && o != null) {
            if (o instanceof String || o instanceof Number || o instanceof Boolean) {
                result = o.toString();
            } else if (o instanceof DataTypeID) {
                result = ((DataTypeID)o).getTypeName();
            }
        }
        return result;
    }

    private String getValue(boolean fromA, String name, Object obj) {
        String value;
        String string = value = fromA ? this.getAVal() : this.getBVal();
        if (obj != null && value == null) {
            if ("schema".equals(name)) {
                value = ((Schema)obj).getName();
            } else if ("baseType".equals(name)) {
                value = ((Trigger.BaseType)obj).name();
            } else if ("timing".equals(name)) {
                value = ((Trigger.Timing)obj).name();
            } else if (obj instanceof ReferenceID) {
                value = ((ReferenceID)obj).getName();
            } else if (!"Comment".equals(name) && !"selectObjectID".equals(name)) {
                value = obj.toString();
            }
        }
        return value;
    }

    protected void setText() {
        boolean mappedName = false;
        boolean isDatatype = false;
        ResultSet rs = this.getResultSet();
        String name = rs.getName();
        Object rso = rs.getResultSetObject();
        Object fromObj = this.m_fromA ? rs.a() : rs.b();
        Object toObj = !this.m_fromA ? rs.a() : rs.b();
        String fromVal = this.getValue(this.m_fromA, name, fromObj);
        String toVal = this.getValue(this.m_fromA ^ true, name, toObj);
        if ("columnIDs".equals(name) || "tableID".equals(name)) {
            if (fromObj instanceof DBObjectID) {
                try {
                    DBObject dbo = ((DBObjectID)fromObj).resolveID();
                    fromVal = dbo == null ? "" : dbo.getName();
                    name = "";
                }
                catch (DBException dbe) {}
            } else if (fromObj instanceof Trigger) {
                name = "";
            }
            if (toObj instanceof DBObjectID) {
                try {
                    DBObject dbo = ((DBObjectID)toObj).resolveID();
                    toVal = dbo == null ? "" : dbo.getName();
                    name = "";
                }
                catch (DBException dbe) {}
            } else if (toObj instanceof Trigger) {
                name = "";
            }
        } else if ("tableOwner".equals(name)) {
            name = "";
            if (!ModelUtil.hasLength((String)fromVal)) {
                String string = fromVal = fromObj instanceof DBObject ? ((DBObject)fromObj).getName() : "";
            }
            if (!ModelUtil.hasLength((String)toVal)) {
                toVal = toObj instanceof DBObject ? ((DBObject)toObj).getName() : "";
            }
        } else if ("dataTypeUsage".equals(name)) {
            isDatatype = true;
            name = TransferArb.getString(150);
            try {
                DataTypeUsage dtu = this.getDataTypeUsage(toObj);
                if (dtu != null) {
                    DataType datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                    toVal = datatype.getDDL(dtu);
                }
                if ((dtu = this.getDataTypeUsage(fromObj)) != null) {
                    DataType datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                    fromVal = datatype.getDDL(dtu);
                }
            }
            catch (DBException dbe) {}
        } else if (this.isMap() && "locationSpecifiers".equals(name)) {
            Map dl = rs.getAllObjectsMap();
            ResultSet drs = (ResultSet)dl.get("directory");
            ResultSet lrs = (ResultSet)dl.get("specifier");
            Object odir = null;
            Object ospecifier = null;
            if (this.isFrom()) {
                Object object = drs != null ? (this.m_fromA ? drs.a() : drs.b()) : (odir = null);
                ospecifier = lrs != null ? (this.m_fromA ? lrs.a() : lrs.b()) : null;
            } else {
                Object object = drs != null ? (!this.m_fromA ? drs.a() : drs.b()) : (odir = null);
                ospecifier = lrs != null ? (!this.m_fromA ? lrs.a() : lrs.b()) : null;
            }
            String dir = odir instanceof ReferenceID ? ((ReferenceID)odir).getName() : "<empty>";
            String specifier = ospecifier != null ? ospecifier.toString() : "<empty>";
            name = dir + " : " + specifier;
        } else if (this.isMap() && "columnExpressions".equals(name)) {
            name = "";
            if (this.isFrom()) {
                if (fromObj instanceof IndexObject) {
                    name = ((IndexObject)fromObj).getSQLText();
                }
            } else if (toObj instanceof IndexObject) {
                name = ((IndexObject)toObj).getSQLText();
            }
        } else if (this.isLeaf() && "events".equals(name)) {
            name = "";
        } else if (s_nameMap.containsKey(name)) {
            name = (String)s_nameMap.get(name);
            mappedName = true;
        } else {
            name = PropertyDisplayRegistry.getDisplayName((String)name);
        }
        this.m_text = this.isLeaf() || isDatatype ? TransferArb.format(216, name, this.decode(rs.getName(), this.isFrom() ? fromVal : toVal)) : (!mappedName && this.m_dbObject instanceof FKConstraint && DBUtil.isDangling((DBObjectID)((FKConstraint)this.m_dbObject).getReferenceID()) ? TransferArb.format(85, name) : TransferArb.format(82, name));
        if (this.isFrom()) {
            if (this.isAdd()) {
                this.m_text = this.isLeaf() || isDatatype ? TransferArb.format(259, name, this.decode(rs.getName(), fromVal)) : TransferArb.format(258, name);
            } else if (this.isDrop()) {
                this.m_text = this.isLeaf() || isDatatype ? TransferArb.format(166, name) : TransferArb.format(87, name);
            } else if (this.isChange()) {
                this.m_text = this.isLeaf() || isDatatype ? TransferArb.format(71, name, this.decode(rs.getName(), fromVal)) : TransferArb.format(239, name);
            }
            this.m_shuttledText = this.m_text;
        } else if (this.isAdd()) {
            if (this.isLeaf() || isDatatype) {
                this.m_text = TransferArb.format(126, name);
                this.m_shuttledText = TransferArb.format(95, name, this.decode(rs.getName(), fromVal));
            } else {
                this.m_text = TransferArb.getString(121);
                this.m_shuttledText = TransferArb.format(212, name);
            }
        } else if (this.isDrop()) {
            if (this.isLeaf() || isDatatype) {
                this.m_text = TransferArb.format(18, name, this.decode(rs.getName(), toVal));
                this.m_shuttledText = TransferArb.format(74, name, this.decode(rs.getName(), toVal));
            } else {
                this.m_text = TransferArb.format(17, name);
                this.m_shuttledText = TransferArb.format(70, this.decode(rs.getName(), name));
            }
        } else if (this.isChange()) {
            if (this.isLeaf() || isDatatype) {
                this.m_text = TransferArb.format(182, name, toVal);
                this.m_shuttledText = TransferArb.format(218, name, this.decode(rs.getName(), toVal), this.decode(rs.getName(), fromVal));
            } else {
                this.m_text = TransferArb.format(110, name);
                this.m_shuttledText = TransferArb.format(100, name);
            }
        }
    }

    private DataTypeUsage getDataTypeUsage(Object obj) {
        DataTypeUsage dtu = null;
        if (obj instanceof DataTypeUsage) {
            dtu = (DataTypeUsage)obj;
        } else if (obj instanceof Column) {
            dtu = ((Column)obj).getDataTypeUsage();
        }
        return dtu;
    }

    protected void setColor() {
        block7: {
            block8: {
                block6: {
                    if (!this.isAdd()) break block6;
                    HighlightStyle additionStyle = highlightRegistry.lookupStyle("inline-compare-addition");
                    this.m_highLightBackground = additionStyle.getBackgroundColor().darker();
                    if (this.isFrom()) {
                        this.m_background = additionStyle.getBackgroundColor();
                        this.m_shuttledBackground = BACKGROUND;
                    } else {
                        this.m_background = BACKGROUND;
                        this.m_shuttledBackground = additionStyle.getBackgroundColor();
                    }
                    break block7;
                }
                if (!this.isDrop()) break block8;
                HighlightStyle deletionStyle = highlightRegistry.lookupStyle("inline-compare-deletion");
                this.m_highLightBackground = deletionStyle.getBackgroundColor().darker();
                if (this.isFrom()) {
                    this.m_background = deletionStyle.getBackgroundColor();
                    this.m_shuttledBackground = BACKGROUND;
                } else {
                    this.m_background = BACKGROUND;
                    this.m_shuttledBackground = deletionStyle.getBackgroundColor();
                }
                break block7;
            }
            if (!this.isChange()) break block7;
            HighlightStyle updateStyle = highlightRegistry.lookupStyle("inline-compare-update");
            this.m_highLightBackground = updateStyle.getBackgroundColor().darker();
            if (this.isFrom()) {
                this.m_background = updateStyle.getBackgroundColor();
                this.m_shuttledBackground = BACKGROUND;
            } else {
                this.m_background = BACKGROUND;
                this.m_shuttledBackground = updateStyle.getBackgroundColor();
            }
        }
    }

    private void setIcon() {
        ResultSet rs = this.getResultSet();
        this.m_icon = null;
        this.m_shuttledIcon = null;
        if ("MAP".equals(rs.getType())) {
            DBObject toObj;
            DBObject dba = null;
            if (rs.a() instanceof DBObject) {
                dba = (DBObject)rs.a();
            }
            DBObject dbb = null;
            if (rs.b() instanceof DBObject) {
                dbb = (DBObject)rs.b();
            }
            DBObject fromObj = this.m_fromA ? dba : dbb;
            DBObject dBObject = toObj = !this.m_fromA ? dba : dbb;
            if (this.isFrom() && fromObj != null) {
                this.m_shuttledIcon = this.m_icon = DBTypeDisplayRegistry.getNodeIcon((String)fromObj.getType());
            } else if (this.isTo()) {
                if (toObj != null) {
                    this.m_icon = DBTypeDisplayRegistry.getNodeIcon((String)toObj.getType());
                }
                if (fromObj != null) {
                    this.m_shuttledIcon = DBTypeDisplayRegistry.getNodeIcon((String)fromObj.getType());
                }
            }
        }
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public Icon getShuttledIcon() {
        return this.m_shuttledIcon;
    }

    public String getShuttledText() {
        return this.m_shuttledText;
    }

    public String getText() {
        return this.m_text;
    }

    public Color getHighLightBackground() {
        return this.m_highLightBackground;
    }

    public Color getShuttledBackground() {
        return this.m_shuttledBackground;
    }

    public Color getBackground() {
        return this.m_background;
    }

    public void setPartner(ReconcileTreeNode partner) {
        this.m_partner = partner;
    }

    public ReconcileTreeNode getPartner() {
        TreeNode parent = this.getParent();
        ReconcileTreeNode partner = this.m_partner;
        while (partner == null && parent != null) {
            if (parent instanceof ReconcileTreeNode) {
                partner = ((ReconcileTreeNode)parent).getPartner();
            }
            parent = parent.getParent();
        }
        return partner;
    }

    public DBObject getDBObject() {
        return this.m_dbObject;
    }

    public String getTooltipPrefix() {
        return this.m_tootipPrefix;
    }

    public boolean isFrom() {
        return this.m_from;
    }

    public boolean isTo() {
        return this.isFrom() ^ true;
    }

    public ResultSet getResultSet() {
        return (ResultSet)this.getUserObject();
    }

    private Set getAttributes() {
        TreeSet<ReconcileTreeNode> result = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> i = this.children();
        while (i.hasMoreElements()) {
            ReconcileTreeNode c = (ReconcileTreeNode)i.nextElement();
            ResultSet r = (ResultSet)c.getUserObject();
            if (!"LEAF".equals(r.getType())) continue;
            result.add(c);
        }
        return result;
    }

    public Collection getAllChildren() {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        Enumeration<TreeNode> i = this.children();
        while (i.hasMoreElements()) {
            children.add(i.nextElement());
        }
        return children;
    }

    private Set getChildLists() {
        TreeSet<ReconcileTreeNode> result = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> i = this.children();
        while (i.hasMoreElements()) {
            ReconcileTreeNode c = (ReconcileTreeNode)i.nextElement();
            ResultSet r = (ResultSet)c.getUserObject();
            if (!"LIST".equals(r.getType())) continue;
            result.add(c);
        }
        return result;
    }

    private Set getChildren() {
        TreeSet<ReconcileTreeNode> result = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> i = this.children();
        while (i.hasMoreElements()) {
            ReconcileTreeNode rtn = (ReconcileTreeNode)i.nextElement();
            ResultSet r = rtn.getResultSet();
            if (!"MAP".equals(r.getType())) continue;
            result.add(rtn);
        }
        return result;
    }

    public boolean isShuttled() {
        boolean result = false;
        if (this.m_from) {
            if (this.m_partner != null) {
                result = this.m_partner.isShuttled();
            }
        } else {
            result = this.m_shuttled;
        }
        return result;
    }

    public boolean isChildShuttled() {
        return this.m_childShuttled;
    }

    public ChildrenShuttled updateChildShuttled() {
        if (this.m_justShuttled) {
            this.m_justShuttled = false;
            return this.m_shuttled ? ChildrenShuttled.ALL : ChildrenShuttled.NONE;
        }
        boolean allChildrenShuttled = false;
        boolean someChildrenShuttled = false;
        boolean noChildrenShuttled = true;
        if (this.isLeaf()) {
            return this.m_shuttled ? ChildrenShuttled.ALL : ChildrenShuttled.NONE;
        }
        if (this.m_changed) {
            boolean first = true;
            Collection allChildren = this.getAllChildren();
            for (ReconcileTreeNode ccm : allChildren) {
                ResultSet rs = ccm.getResultSet();
                if (!ccm.m_changed) continue;
                ChildrenShuttled cs = ccm.updateChildShuttled();
                if (first) {
                    noChildrenShuttled = cs == ChildrenShuttled.NONE;
                    someChildrenShuttled = cs == ChildrenShuttled.SOME || cs == ChildrenShuttled.ALL;
                    allChildrenShuttled = cs == ChildrenShuttled.ALL;
                    first = false;
                    continue;
                }
                noChildrenShuttled &= cs == ChildrenShuttled.NONE;
                someChildrenShuttled |= cs == ChildrenShuttled.SOME || cs == ChildrenShuttled.ALL;
                allChildrenShuttled &= cs == ChildrenShuttled.ALL;
            }
            if (noChildrenShuttled && (someChildrenShuttled || allChildrenShuttled)) {
                TransferLog.getLogger().log(Level.SEVERE, "inconsistent shuttle flags");
            }
            this.m_childShuttled = someChildrenShuttled;
            if (allChildrenShuttled) {
                this.m_shuttled = true;
            } else if (noChildrenShuttled) {
                this.m_shuttled = false;
            }
        }
        return noChildrenShuttled ? ChildrenShuttled.NONE : (allChildrenShuttled ? ChildrenShuttled.ALL : ChildrenShuttled.SOME);
    }

    public void clearJustShuttled() {
        if (this.m_from) {
            this.m_partner.clearJustShuttled();
        } else {
            this.m_justShuttled = false;
            Collection allChildren = this.getAllChildren();
            for (ReconcileTreeNode child : allChildren) {
                child.clearJustShuttled();
            }
        }
    }

    public void setShuttled(DefaultTreeModel fromTreeModel, DefaultTreeModel toTreeModel, boolean shuttled) {
        if (this.m_from) {
            Assert.check((this.m_partner != null ? 1 : 0) != 0);
            Assert.check((boolean)this.m_partner.isTo());
            this.m_partner.setShuttled(fromTreeModel, toTreeModel, shuttled);
        } else if ((this.m_shuttled != shuttled || this.m_childShuttled != this.m_shuttled) && this.m_changed) {
            this.m_shuttled = shuttled;
            this.m_childShuttled = shuttled;
            this.m_justShuttled = true;
            for (ReconcileTreeNode ccm : this.getAllChildren()) {
                ResultSet rs = ccm.getResultSet();
                if (!ccm.m_changed) continue;
                ccm.setShuttled(fromTreeModel, toTreeModel, shuttled);
            }
            ReconcileTreeNode dcm = shuttled ? this.getPartner() : this;
            for (ReconcileTreeNode dependant : dcm.getDependantChanges()) {
                ResultSet rs = dependant.getResultSet();
                if (!dependant.m_changed || dependant.isShuttled() == shuttled) continue;
                dependant.setShuttled(fromTreeModel, toTreeModel, shuttled);
            }
        }
        this.nodeChanged(fromTreeModel, toTreeModel);
    }

    private void nodeChanged(DefaultTreeModel fromTreeModel, DefaultTreeModel toTreeModel) {
        if (this.m_from) {
            fromTreeModel.nodeChanged(this);
        } else {
            toTreeModel.nodeChanged(this);
        }
    }

    public boolean isHighLighted() {
        return this.m_highLighted;
    }

    private boolean isSuitableToHighLight() {
        boolean result = false;
        if (!this.getResultSet().isSame()) {
            result = this.isFrom() ? this.isShuttled() ^ true : this.isShuttled();
        }
        return result;
    }

    public void setHighLighted(DefaultTreeModel fromTreeModel, DefaultTreeModel toTreeModel, boolean highLighted) {
        if (this.m_highLighted != (highLighted &= this.isSuitableToHighLight())) {
            this.m_highLighted = highLighted;
            Enumeration<TreeNode> i = this.children();
            while (i.hasMoreElements()) {
                ReconcileTreeNode child = (ReconcileTreeNode)i.nextElement();
                child.setHighLighted(fromTreeModel, toTreeModel, highLighted);
            }
            this.nodeChanged(fromTreeModel, toTreeModel);
        }
    }

    public Set getDependantChanges() {
        return this.m_dependantChanges;
    }

    public void addDependantChange(ReconcileTreeNode node) {
        this.m_dependantChanges.add(node);
    }

    public void setDependantsHighLighted(DefaultTreeModel fromTreeModel, DefaultTreeModel toTreeModel, boolean highLighted) {
        if (this.m_highLighted != (highLighted &= this.isSuitableToHighLight())) {
            this.setHighLighted(fromTreeModel, toTreeModel, highLighted);
            for (ReconcileTreeNode dependant : this.getDependantChanges()) {
                dependant.setDependantsHighLighted(fromTreeModel, toTreeModel, highLighted);
            }
        }
    }

    public String toString() {
        String name = "";
        if (this.m_dbObject != null) {
            name = this.m_dbObject.getName();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChildrenShuttled
    extends Enum<ChildrenShuttled> {
        private static final /* synthetic */ ChildrenShuttled[] $v;
        public static final /* enum */ ChildrenShuttled NONE;
        public static final /* enum */ ChildrenShuttled SOME;
        public static final /* enum */ ChildrenShuttled ALL;

        public static ChildrenShuttled valueOf(String string) {
            return Enum.valueOf(ChildrenShuttled.class, string);
        }

        public static final ChildrenShuttled[] values() {
            return (ChildrenShuttled[])$v.clone();
        }

        static {
            ChildrenShuttled[] childrenShuttledArray = new ChildrenShuttled[3];
            childrenShuttledArray[2] = ALL = new ChildrenShuttled("ALL", 2);
            childrenShuttledArray[1] = SOME = new ChildrenShuttled("SOME", 1);
            childrenShuttledArray[0] = NONE = new ChildrenShuttled("NONE", 0);
            $v = childrenShuttledArray;
        }

        private ChildrenShuttled(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReconcileNodeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Assert.check((boolean)(o1 instanceof ReconcileTreeNode));
            Assert.check((boolean)(o2 instanceof ReconcileTreeNode));
            String n1 = ((ReconcileTreeNode)o1).getResultSet().getName();
            String n2 = ((ReconcileTreeNode)o2).getResultSet().getName();
            return n1.compareTo(n2);
        }

        private ReconcileNodeComparator() {
        }

        ReconcileNodeComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

