/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.reconcile.CheckConstraintDependancySeeker;
import oracle.ideimpl.db.transfer.reconcile.ColumnConstraitDependancySeeker;
import oracle.ideimpl.db.transfer.reconcile.DataTypeAttributeDependancySeeker;
import oracle.ideimpl.db.transfer.reconcile.DependancyManager;
import oracle.ideimpl.db.transfer.reconcile.FKConstraintDependancySeeker;
import oracle.ideimpl.db.transfer.reconcile.IndexDependancySeeker;
import oracle.ideimpl.db.transfer.reconcile.ReconcilePanel;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.DiffEngineCancelledException;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.dialogs.ExceptionDialog;

public class ReconcileUI
implements Runnable {
    public static final String RECONCILE_KEY = "RECONCILE_KEY";
    public static final String RECONCILE_DESC = "RECONCILE_DESC";
    private boolean m_diagnosticPrint;
    private List m_aList;
    private List m_bList;
    private DiffContext m_diffContext;
    private DependancyManager m_dependancyManager;
    private DiffEngine m_engine;
    private boolean m_fullDiffTreeRequired;
    private String m_title;
    private String m_progressText;
    protected ProgressBar m_progressBar;
    protected boolean m_myProgressBar;
    private boolean m_progressBarCompletedOK;
    private boolean m_busyBar;

    private void $init$() {
        this.m_diagnosticPrint = false;
        this.m_title = TransferArb.getString(215);
        this.m_progressText = TransferArb.getString(199);
        this.m_busyBar = true;
    }

    public ReconcileUI() {
        this.$init$();
    }

    public void initReconcile(SchemaObject[] dbm, SchemaObject[] dbu) {
        this.createDependencymanager(dbm, dbu);
        this.m_aList = Arrays.asList(dbm);
        this.m_bList = Arrays.asList(dbu);
        this.m_diffContext = this.m_dependancyManager.getDiffContext();
    }

    public DependancyManager getDependancyManager() {
        return this.m_dependancyManager;
    }

    private void createDependencymanager(SchemaObject[] dbm, SchemaObject[] dbu) {
        DiffEngine de = this.m_engine;
        if (de == null) {
            de = ReconcileHelper.getDiffEngine();
        }
        DiffContext dc = null;
        dc = new DiffContext();
        dc.setEngine(de);
        this.m_dependancyManager = new DependancyManager(dc);
        this.m_dependancyManager.registerDependancySeeker(ColumnConstraint.class, new ColumnConstraitDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(FKConstraint.class, new FKConstraintDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(CheckConstraint.class, new CheckConstraintDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(Index.class, new IndexDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(DataTypeUsage.class, new DataTypeAttributeDependancySeeker());
    }

    public ResultSet manualReconcile(SchemaObject[] dbm, SchemaObject[] dbu) {
        this.createDependencymanager(dbm, dbu);
        DiffContext dc = this.m_dependancyManager.getDiffContext();
        this.setFullDiffTreeRequired(true);
        this.runDiffReconcile(dbm, dbu, dc);
        return dc.getResult();
    }

    public boolean runProgressBar() {
        boolean result = true;
        this.m_progressBarCompletedOK = false;
        if (this.m_progressBar == null) {
            this.m_myProgressBar = true;
            this.m_progressBar = new ProgressBar((Component)Ide.getMainWindow(), this.getTitle(), (Runnable)this, this.m_busyBar);
            this.m_progressBar.start(this.getProgressText(), null);
        } else {
            this.m_myProgressBar = false;
            this.m_progressBar.updateProgress(this.getProgressText(), null);
            this.run();
        }
        if (this.m_progressBar.hasUserCancelled()) {
            result = false;
        } else {
            result = this.m_progressBarCompletedOK;
            if (this.m_myProgressBar) {
                this.m_progressBar = null;
            }
        }
        return result;
    }

    public void setFullDiffTreeRequired(boolean value) {
        this.m_fullDiffTreeRequired = value;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setEngine(DiffEngine diffEngine) {
        this.m_engine = diffEngine;
    }

    public void setProgressBar(ProgressBar pb) {
        this.m_progressBar = pb;
    }

    public void setProgressText(String progressText) {
        this.m_progressText = progressText;
    }

    public String getProgressText() {
        return this.m_progressText;
    }

    protected void setUseBusyBar(boolean useBusyBar) {
        this.m_busyBar = useBusyBar;
    }

    public void checkProgress() {
        if (this.m_progressBar != null && this.m_progressBar.hasUserCancelled()) {
            throw new DiffEngineCancelledException();
        }
    }

    public DiffContext runDiff(Object[] a, Object[] b) {
        return this.runDiff(a, b, true);
    }

    public DiffContext runDiffNoProgress(Object[] a, Object[] b) {
        return this.runDiff(a, b, false);
    }

    private DiffContext runDiff(Object[] a, Object[] b, boolean showProgress) {
        this.m_aList = Arrays.asList(a);
        this.m_bList = Arrays.asList(b);
        ResultSet rs = new ResultSet(null, (Object)a, (Object)b, null, "LIST");
        DiffEngine de = this.m_engine != null ? this.m_engine : ReconcileHelper.getDiffEngine();
        this.m_diffContext = new DiffContext(de, rs);
        boolean ok = true;
        if (showProgress) {
            ok = this.runProgressBar();
        } else {
            this.run();
        }
        if (!ok) {
            rs.setSame(true);
        }
        return this.m_diffContext;
    }

    public DiffContext runDiffReconcile(Object[] a, Object[] b, DiffContext dc) {
        this.m_aList = Arrays.asList(a);
        this.m_bList = Arrays.asList(b);
        this.m_diffContext = dc;
        boolean ok = this.runProgressBar();
        if (ok) {
            DBUIResourceHelper resHelper = new DBUIResourceHelper("ReconcileUI");
            Namespace ns = new Namespace();
            ns.put(RECONCILE_KEY, (Object)this.m_dependancyManager);
            ReconcilePanel panel = new ReconcilePanel();
            TDialogLauncher tdl = new TDialogLauncher((Component)Ide.getMainWindow(), TransferArb.getString(39), (Traversable)panel, ns);
            tdl.setInitialSize(700, 500);
            JEWTDialog dialog = tdl.initDialog();
            resHelper.setName((Component)dialog, "ReconcilePanel");
            dialog.setOKButtonEnabled(false);
            dialog.setCancelButtonText(TransferArb.getString(236));
            ok = tdl.showDialog();
        }
        ResultSet rs = dc.getResult();
        if (!ok) {
            rs.setSame(true);
        }
        if (this.m_diagnosticPrint) {
            rs.print();
        }
        return dc;
    }

    public final void run() {
        try {
            try {
                TransferLog.getLogger().log(TransferLog.getTraceLogLevel(), "Starting " + this.getTitle());
                if (this.m_diffContext.getResult() == null) {
                    this.m_diffContext.setResult(new ResultSet(null, (Object)this.m_aList, (Object)this.m_bList, null, "LIST"));
                }
                this.m_diffContext.setIsTreeRequired(this.m_fullDiffTreeRequired);
                ResultSet rs = this.m_diffContext.getResult();
                this.m_diffContext.getEngine().diff(this.m_aList, this.m_bList, rs, this.m_diffContext);
                if (this.m_diagnosticPrint) {
                    this.m_diffContext.getResult().print();
                }
                if (this.m_dependancyManager != null) {
                    this.m_dependancyManager.setResultSet(rs);
                    this.m_dependancyManager.analyseDependencies();
                    if (this.m_diagnosticPrint) {
                        this.m_dependancyManager.print();
                    }
                }
                this.m_progressBarCompletedOK = true;
            }
            catch (DiffEngineCancelledException e) {
                if (this.m_myProgressBar) {
                    this.m_progressBar = null;
                }
            }
            catch (Exception e) {
                if (this.m_progressBar != null && this.m_myProgressBar) {
                    this.m_progressBar.setDoneStatus();
                }
                TransferLog.getLogger().log(Level.SEVERE, e.getMessage(), e);
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
            }
        }
        finally {
            if (this.m_progressBar != null) {
                if (this.m_progressBar.hasUserCancelled()) {
                    this.m_diffContext.getEngine().cancelDiff();
                    if (this.m_myProgressBar) {
                        this.m_progressBar = null;
                    }
                } else if (this.m_myProgressBar) {
                    this.m_progressBar.setDoneStatus();
                }
            }
        }
    }
}

