/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.wizards;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.panels.ChooseOpFull;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelSource;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelTarget;
import oracle.ideimpl.db.transfer.panels.GeneratorSqlPanel;
import oracle.ideimpl.db.transfer.panels.GeneratorSummaryPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.icons.OracleIcons;

public class GenerateSQLWizard
extends Wizard {
    public static final String HELP_WELCOME = "f1_ondbgeneratesqlwizardwelcome_html";
    public static final String HELP_SOURCE = "f1_odbcopysource_html";
    public static final String HELP_TARGET = "f1_odbcopytarget_html";
    public static final String HELP_SELECT_OBJECTS = "f1_odbcopyobjpick_html";
    public static final String HELP_GENERATE_OPTIONS = "f1_odbcopyoperation_html";
    public static final String HELP_SQL_SCRIPT = "f1_odbcopysqloptions_html";
    public static final String HELP_CHOOSE = "f1_odbcopyoperation_html";
    public static final String HELP_RECONCILE = "f1_odbcopyreconcile_html";
    public static final String HELP_FINISH = "f1_odbcopyfinish_html";
    public static final String WELCOME_ID = "ONLINEDB_GENERATE_SQL_WELCOME";
    public static final String EDIT = "EDIT";
    private Context m_context;

    protected Context getContext() {
        if (this.m_context == null) {
            return Context.newIdeContext();
        }
        return this.m_context;
    }

    public boolean invokeGenerateWizard(DBObjectProvider pro, SchemaObject[] selectedObjs) {
        boolean retval = false;
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)pro);
        TransferDescriptor descriptor = new TransferDescriptor();
        descriptor.setSource(((Database)pro).getConnectionName());
        namespace.put("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY", (Object)descriptor);
        if (selectedObjs != null) {
            ArrayList<DBObjectID> ids = new ArrayList<DBObjectID>();
            int i = 0;
            while (i < selectedObjs.length) {
                if (selectedObjs[i] != null) {
                    ids.add(selectedObjs[i].getID());
                }
                ++i;
            }
            if (ids.size() > 0) {
                descriptor.setObjectIDs(ids.toArray(new DBObjectID[ids.size()]));
            }
        }
        Step welcome = WelcomePanel.newStep((String)this.getShortLabel(), (String)TransferArb.getString(225), (String)TransferArb.getString(235), (String)WELCOME_ID, (String)HELP_WELCOME);
        welcome.setPageTitle(TransferArb.getString(129));
        Step s1 = new Step(TransferArb.getString(38), GeneratorConnectionPanelSource.class, HELP_SOURCE);
        Step s2 = new Step(TransferArb.getString(28), GeneratorConnectionPanelTarget.class, HELP_TARGET);
        Step s3 = new Step(TransferArb.getString(141), SelectDBObjectsPanel.class, HELP_SELECT_OBJECTS);
        Step s4 = new Step(TransferArb.getString(4), ChooseOpFull.class, "f1_odbcopyoperation_html");
        Step s6 = new Step(TransferArb.getString(168), GeneratorSqlPanel.class, HELP_SQL_SCRIPT);
        Step finish = new Step(TransferArb.getString(76), GeneratorSummaryPanel.class, HELP_FINISH);
        Step[] steps = new Step[]{welcome, s1, s2, s3, s4, finish};
        FSMWizard wiz = new FSMWizard(steps, namespace);
        wiz.setShowStepNumber(true);
        wiz.setWelcomePageAdded(true);
        wiz.setFinishPageAdded(true);
        wiz.setWizardTitle(TransferArb.getString(227));
        TransferUtil.setWizardLogo((BaseWizard)wiz, TransferArb.getImage(102));
        WizardDialog dialog = wiz.getDialog((Frame)Ide.getMainWindow());
        boolean done = dialog.runDialog();
        dialog.dispose();
        if (done) {
            // empty if block
        }
        return retval;
    }

    private void checkIDsProvider(TransferDescriptor descriptor, DBObjectProvider pro) {
    }

    private void generate(TransferDescriptor descriptor, DBObjectProvider pro) {
    }

    public String getShortLabel() {
        return TransferArb.getString(189);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        this.m_context = context;
        Project proj = context.getProject();
        DBObjectProvider pro = null;
        Element[] selection = context.getSelection();
        Element elem = context.getElement();
        if (elem instanceof DatabaseNode) {
            try {
                pro = DBObjectProviderFactory.findOrCreateProvider((Object)((DatabaseNode)elem).getConnectionName());
            }
            catch (DBException dbe) {
                TransferLog.getLogger().log(Level.WARNING, "failed to get Database for node", dbe);
            }
        }
        HashSet selectedObjs = new HashSet();
        SchemaObject[] selected = selectedObjs.toArray(new SchemaObject[selectedObjs.size()]);
        return this.invokeGenerateWizard(pro, selected);
    }

    public String getLongLabel() {
        return TransferArb.getString(200);
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"sqlfile.png");
    }

    public static final boolean canGenerate(Project p) {
        return true;
    }
}

