/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.wizards;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferHelper;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.db.transfer.OnToOnPolicy;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferRunnable;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.panels.ChooseOpFull;
import oracle.ideimpl.db.transfer.panels.DBtoDBReconcilePanel;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelSource;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelTarget;
import oracle.ideimpl.db.transfer.panels.GeneratorSqlPanel;
import oracle.ideimpl.db.transfer.panels.GeneratorSummaryPanel;
import oracle.ideimpl.db.transfer.panels.TransferProgressBar;
import oracle.ideimpl.db.transfer.panels.TransferSelectionPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class TransferDBtoDBWizard
extends Wizard {
    public static final String HELP_WELCOME = "f1_tdbtodbwizardwelcome_html";
    public static final String HELP_SOURCE = "f1_tdbtodbwizardsource_html";
    public static final String HELP_TARGET = "f1_tdbtodbwizardtarget_html";
    public static final String HELP_SELECT_OBJECTS = "f1_tdbtodbwizardselectobj_html";
    public static final String HELP_GENERATE_OPTIONS = "f1_tdbtodbwizardgenerateopt_html";
    public static final String HELP_SQL_SCRIPT = "f1_tdbtodbwizardsqlscriptopt_html";
    public static final String HELP_CHOOSE = "f1_tdbtodbwizardchoose_html";
    public static final String HELP_RECONCILE = "f1_tdbtodbwizardreconcile_html";
    public static final String HELP_FINISH = "f1_tdbtodbwizardfinish_html";
    public static final String WELCOME_ID = "DB_TO_DB_WELCOME";
    public static final String EDIT = "EDIT";
    private Context m_context;

    protected Context getContext() {
        if (this.m_context == null) {
            return Context.newIdeContext();
        }
        return this.m_context;
    }

    public TransferDescriptor createTransferDescriptor(Context context, DBObjectProvider pro, SchemaObject[] selectedObjs) {
        TransferDescriptor td = new TransferDescriptor();
        td.setPolicy(OnToOnPolicy.class);
        if (pro != null && pro instanceof Database) {
            td.setSource(((Database)pro).getConnectionName());
        }
        if (selectedObjs != null) {
            ArrayList<DBObjectID> ids = new ArrayList<DBObjectID>();
            int i = 0;
            while (i < selectedObjs.length) {
                if (selectedObjs[i] != null) {
                    ids.add(selectedObjs[i].getID());
                }
                ++i;
            }
            if (ids.size() > 0) {
                td.setObjectIDs(ids.toArray(new DBObjectID[ids.size()]));
                td.setSchemaObjectDescriptors(SchemaObjectDescriptor.createDescriptors((DBObjectID[])td.getObjectIDs()));
            }
        }
        return td;
    }

    public boolean invokeDBtoDBWizard(Context context, TransferDescriptor td, DBObjectProvider pro, boolean isQuick) {
        boolean retval = false;
        FSMBuilder fsmBuilder = new FSMBuilder();
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)pro);
        namespace.put(Context.class.getName(), (Object)context);
        namespace.put("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY", (Object)td);
        Step source = new Step(TransferArb.getString(113), GeneratorConnectionPanelSource.class, HELP_SOURCE);
        Step target = new Step(TransferArb.getString(104), GeneratorConnectionPanelTarget.class, HELP_TARGET);
        Step picker = new Step(TransferArb.getString(209), TransferSelectionPanel.class, HELP_SELECT_OBJECTS);
        Step chooseOp = new Step(TransferArb.getString(131), ChooseOpFull.class, HELP_CHOOSE);
        Step manualR = new Step(TransferArb.getString(202), DBtoDBReconcilePanel.class, "f1_odbcopyreconcile_html");
        Step sqlScript = new Step(TransferArb.getString(97), GeneratorSqlPanel.class, HELP_SQL_SCRIPT);
        Step finish = new Step(TransferArb.getString(152), GeneratorSummaryPanel.class, HELP_FINISH);
        String TARGET_STATE = TransferUtil.createStateName(target);
        String OBJECT_PICKER_STATE = TransferUtil.createStateName(picker);
        String CHOOSE_OP_STATE = TransferUtil.createStateName(chooseOp);
        String MANUAL_RECONCILE_STATE = TransferUtil.createStateName(manualR);
        String SQL_SCRIPT_STATE = TransferUtil.createStateName(sqlScript);
        String FINISH_STATE = TransferUtil.createStateName(finish);
        fsmBuilder.newStartState(source, (Object)TARGET_STATE);
        fsmBuilder.newState((Object)TARGET_STATE, target, (Object)OBJECT_PICKER_STATE);
        fsmBuilder.newState((Object)OBJECT_PICKER_STATE, picker, (Object)CHOOSE_OP_STATE);
        fsmBuilder.newState((Object)CHOOSE_OP_STATE, chooseOp, (Object)FINISH_STATE);
        fsmBuilder.addStateTrans((Object)false, (Object)SQL_SCRIPT_STATE);
        fsmBuilder.addStateTrans((Object)true, (Object)MANUAL_RECONCILE_STATE);
        fsmBuilder.newState((Object)MANUAL_RECONCILE_STATE, manualR, (Object)SQL_SCRIPT_STATE);
        fsmBuilder.newState((Object)SQL_SCRIPT_STATE, sqlScript, (Object)FINISH_STATE);
        fsmBuilder.newFinalState((Object)FINISH_STATE, finish);
        FSM fsm = null;
        try {
            fsm = fsmBuilder.getFSM();
        }
        catch (FSMInvalidException fie) {
            TransferLog.getLogger().log(Level.SEVERE, "Failed to create Wizard", fie);
        }
        if (fsm != null) {
            FSMWizard wiz = new FSMWizard(fsm, namespace);
            wiz.setShowStepNumber(true);
            wiz.setWelcomePageAdded(false);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(TransferArb.getString(80));
            TransferUtil.setWizardLogo((BaseWizard)wiz, TransferArb.getImage(233));
            wiz.setRoadmapVisible(true);
            WizardDialog dialog = wiz.getDialog((Frame)Ide.getMainWindow());
            boolean done = dialog.runDialog();
            dialog.dispose();
            if (done) {
                boolean debugTransferHelper = false;
                if (debugTransferHelper) {
                    try {
                        Object sa = td.getSource();
                        Object ta = td.getTarget();
                        DBObjectProvider s = td.getSourceProvider();
                        DBObjectProvider t = td.getTargetProvider();
                        SchemaObject[] sos = td.getSchemaObjects();
                        String targetSchemaName = td.getTargetSchemaName();
                        if (targetSchemaName == null) {
                            targetSchemaName = sos[0].getSchema().getName();
                        }
                        Schema targetSchema = t.getSchema(targetSchemaName);
                        String ddl = TransferHelper.getUpdateDDL(s, sos, t, targetSchema);
                        System.out.printf(ddl, new Object[0]);
                        boolean bl = retval;
                        return bl;
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                TransferRunnable runner = td.isReconcile() && td.isManualReconcile() ? TransferRunnable.createTransferRunnable(td) : TransferRunnable.createPrepareAndTransferRunnable(td);
                try {
                    TransferProgressBar bar = new TransferProgressBar(this.getShortLabel(), runner);
                    bar.start(null, null);
                    if (!bar.hasUserCancelled()) {
                        runner.getTransferResult();
                    }
                }
                catch (TransferFailedException tfe) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)tfe);
                }
            }
        }
        return retval;
    }

    public String getShortLabel() {
        return TransferArb.getString(142);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        this.m_context = context;
        Database sourcedb = null;
        DBObjectProvider pro = null;
        Element[] selection = context.getSelection();
        Element elem = context.getElement();
        Object ident = null;
        if (elem instanceof DBObjectTypeNode) {
            ident = ((DBObjectNode)elem).getProviderIdentifier();
        }
        if (ident instanceof String) {
            try {
                sourcedb = (Database)DBObjectProviderFactory.findOrCreateProvider((Object)ident);
            }
            catch (DBException dbe) {
                DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)this.getShortLabel(), (DBException)dbe);
            }
        }
        HashSet<SchemaObject> selectedObjs = new HashSet<SchemaObject>();
        if (sourcedb != null) {
            int i = 0;
            while (i < selection.length) {
                DBObject dbo;
                if (selection[i] instanceof DBObjectNode && (dbo = ((DBObjectNode)selection[i]).getDBObject()) instanceof SchemaObject) {
                    selectedObjs.add((SchemaObject)dbo);
                }
                ++i;
            }
        }
        SchemaObject[] selected = selectedObjs.toArray(new SchemaObject[selectedObjs.size()]);
        TransferDescriptor td = this.createTransferDescriptor(context, (DBObjectProvider)sourcedb, selected);
        return this.invokeDBtoDBWizard(context, td, pro, false);
    }

    public String getLongLabel() {
        return TransferArb.getString(148);
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"sqlfile.png");
    }

    public static final boolean canGenerate(Project p) {
        return true;
    }
}

