/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.ref;

import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.ref.NonAttrNodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RegularNodeRef
extends NonAttrNodeRef {
    private final int[] _parentNodePath;
    private final int _indexInParent;

    RegularNodeRef(Node node) {
        this(DomUtils.getPathToNode(node.getParentNode()), DomUtils.getChildIndex(node));
    }

    RegularNodeRef(NodeRef parentRef, int indexInParent) {
        this(((NonAttrNodeRef)parentRef).getNodePath(), indexInParent);
    }

    private RegularNodeRef(int[] parentPath, int indexInParent) {
        this._parentNodePath = parentPath;
        this._indexInParent = indexInParent;
    }

    public void putCorrespondingNode(Document doc, Node newNode) {
        Node parent = this._getParentNode(doc);
        Node nextSibling = DomUtils.getChildAtIndex(parent, this._indexInParent);
        try {
            parent.insertBefore(newNode, nextSibling);
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }

    public Node getCorrespondingNode(Document doc) {
        return DomUtils.getChildAtIndex(this._getParentNode(doc), this._indexInParent);
    }

    public NodeRef getChildNodeRef(Node node) {
        return NodeRefFactory.getNodeRef(this, node);
    }

    public int[] getNodePath() {
        int[] path = new int[this._parentNodePath.length + 1];
        System.arraycopy(this._parentNodePath, 0, path, 0, this._parentNodePath.length);
        path[path.length - 1] = this._indexInParent;
        return path;
    }

    public String getJavaExpression(String docExpr) {
        StringBuffer buf = new StringBuffer("DomUtils.getNodeFromPath(");
        buf.append(docExpr);
        buf.append(", new int[] { ");
        this._appendPathAsString(buf);
        buf.append(" })");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        this._appendPathAsString(buf);
        buf.append("]");
        return buf.toString();
    }

    private void _appendPathAsString(StringBuffer buf) {
        int i = 0;
        while (i < this._parentNodePath.length) {
            buf.append(this._parentNodePath[i]);
            buf.append(", ");
            ++i;
        }
        buf.append(this._indexInParent);
    }

    private Node _getParentNode(Document doc) {
        return DomUtils.getNodeFromPath(doc, this._parentNodePath);
    }
}

