/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DummyNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class TreeTraversalNodeIterator
implements NodeIterator {
    private Node _anchorNode;
    private boolean _isBefore;
    private boolean _detached;
    private final TreeTraversal _traversal;
    private final Node _root;

    public TreeTraversalNodeIterator(TreeTraversal traversal, Node root) {
        this.$init$();
        this._traversal = traversal;
        this._root = root;
    }

    protected TreeTraversal getTreeTraversal() {
        return this._traversal;
    }

    public Node getRoot() {
        return this._root;
    }

    public int getWhatToShow() {
        return -1;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node nextNode() throws DOMException {
        return this._pickNode(true);
    }

    public Node previousNode() throws DOMException {
        return this._pickNode(false);
    }

    public void detach() {
        this._anchorNode = null;
        this._detached = true;
    }

    private Node _pickNode(boolean pickNext) throws DOMException {
        if (this._detached) {
            throw new DOMException(11, "Node already detached");
        }
        Node anchorNode = this._getAnchorNode();
        if (anchorNode == null) {
            return null;
        }
        Node returnNode = anchorNode;
        TreeTraversal traversal = this.getTreeTraversal();
        boolean anchorNodeNotOK = pickNext ^ this._isBefore;
        if (anchorNodeNotOK) {
            returnNode = traversal.getNode(returnNode, pickNext ^ true);
        }
        NodeFilter filter = this.getFilter();
        int whatToShow = this.getWhatToShow();
        while (returnNode != null && ((whatToShow & 1 << returnNode.getNodeType() - 1) == 0 || filter != null && filter.acceptNode(returnNode) != 1)) {
            returnNode = traversal.getNode(returnNode, pickNext ^ true);
        }
        Node boundaryNode = pickNext ? this._nextSiblingMovingUp(this._root) : this._traversal.getPreviousNode(this._root);
        if (returnNode == boundaryNode) {
            returnNode = null;
        }
        if (returnNode != null) {
            this._anchorNode = returnNode;
        }
        this._isBefore = pickNext ^ true;
        return returnNode;
    }

    private Node _nextSiblingMovingUp(Node node) {
        Node next = this._traversal.getNextSibling(node);
        if (next != null) {
            return next;
        }
        Node parent = this._traversal.getParentNode(node);
        if (parent != null) {
            return this._nextSiblingMovingUp(parent);
        }
        return null;
    }

    private Node _getAnchorNode() {
        if (this._anchorNode == DummyNode.INSTANCE && !this._detached) {
            this._anchorNode = this.getRoot();
        }
        return this._anchorNode;
    }

    private void $init$() {
        this._anchorNode = DummyNode.INSTANCE;
        this._isBefore = true;
    }
}

