/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.ArrayList;
import java.util.HashMap;

public final class GrammarIdentifier {
    private static final int _INITIAL_RESULT = 17;
    private static final int _RESULT_MULTIPLIER = 37;
    private static final HashMap _sInstanceMap = new HashMap(37);
    private final String _targetNamespace;
    private final String _publicId;
    private final String _location;
    private int _cachedHash;

    public static GrammarIdentifier getGrammarIdentifier(String targetNamespace, String location) {
        return GrammarIdentifier.getGrammarIdentifier(targetNamespace, null, location);
    }

    public static GrammarIdentifier getGrammarIdentifier(String targetNamespace, String publicId, String location) {
        int hash = GrammarIdentifier._computeHashCode(targetNamespace, publicId, location);
        Integer hashInteger = new Integer(hash);
        GrammarIdentifier identifier = null;
        ArrayList<GrammarIdentifier> possibleMatches = (ArrayList<GrammarIdentifier>)_sInstanceMap.get(hashInteger);
        if (possibleMatches != null) {
            for (GrammarIdentifier current : possibleMatches) {
                if (!current.namespaceMatches(targetNamespace) || !current.publicIdMatches(publicId) || !current.locationMatches(location)) continue;
                identifier = current;
                break;
            }
        } else {
            possibleMatches = new ArrayList<GrammarIdentifier>(3);
            _sInstanceMap.put(hashInteger, possibleMatches);
        }
        if (identifier == null) {
            identifier = new GrammarIdentifier(targetNamespace, publicId, location, hash);
            possibleMatches.add(identifier);
        }
        return identifier;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public boolean namespaceMatches(String namespace) {
        if (namespace == null) {
            return this._targetNamespace == null;
        }
        return namespace.equals(this._targetNamespace);
    }

    public String getPublicId() {
        return this._publicId;
    }

    public boolean publicIdMatches(String publicId) {
        if (publicId == null) {
            return this._publicId == null;
        }
        return publicId.equals(this._publicId);
    }

    public String getLocation() {
        return this._location;
    }

    public boolean locationMatches(String location) {
        if (location == null) {
            return this._location == null;
        }
        return location.equals(this._location);
    }

    public boolean hasTargetNamespace() {
        return this.getTargetNamespace() != null;
    }

    public boolean hasPublicId() {
        return this.getPublicId() != null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this._cachedHash;
    }

    private static int _computeHashCode(String targetNamespace, String publicId, String location) {
        int result = 17;
        result *= 37;
        if (targetNamespace != null) {
            result += targetNamespace.hashCode();
        }
        result *= 37;
        if (publicId != null) {
            result += publicId.hashCode();
        }
        result *= 37;
        if (location != null) {
            result += location.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Grammar Identifier:");
        buffer.append("\n*  Namespace: ");
        buffer.append(this._targetNamespace);
        if (this._publicId != null) {
            buffer.append("\n*  Public Id: ");
            buffer.append(this._publicId);
        }
        buffer.append("\n*  Location: ");
        buffer.append(this._location);
        buffer.append("\n");
        return buffer.toString();
    }

    private GrammarIdentifier(String targetNamespace, String publicId, String location, int hashCode) {
        this.$init$();
        this._targetNamespace = targetNamespace;
        this._publicId = publicId;
        this._location = location;
        this._cachedHash = hashCode;
    }

    private void $init$() {
        this._cachedHash = -1;
    }
}

