/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroupEvent;
import oracle.bali.xml.grammar.SubstitutionGroupListener;

public class SubstitutionGroup {
    private Map _elementDefMap;
    private ListenerManager _listeners;

    public SubstitutionGroup() {
        this.$init$();
    }

    public Collection getElementDefs() {
        return this._elementDefMap.values();
    }

    public ElementDef getElementDefByName(QualifiedName qName) {
        return (ElementDef)this._elementDefMap.get(qName);
    }

    public void addElementDef(ElementDef elementDef) {
        ElementDef oldDef;
        if (this._elementDefMap == Collections.EMPTY_MAP) {
            this._elementDefMap = new LinkedHashMap(17);
        }
        if ((oldDef = this._elementDefMap.put(elementDef.getQualifiedName(), elementDef)) != null) {
            this._fireEvent(oldDef, 2);
        }
        this._fireEvent(elementDef, 1);
    }

    public void addElementDefs(Collection elementDefs) {
        for (Object o : elementDefs) {
            if (!(o instanceof ElementDef)) continue;
            this.addElementDef((ElementDef)o);
        }
    }

    public void removeElementDef(ElementDef elementDef) {
        QualifiedName key = elementDef.getQualifiedName();
        ElementDef prevDef = (ElementDef)this._elementDefMap.get(key);
        if (prevDef == elementDef) {
            this._elementDefMap.remove(key);
            this._fireEvent(elementDef, 2);
        }
    }

    public boolean containsElementDef(ElementDef elementDef) {
        QualifiedName key = elementDef.getQualifiedName();
        ElementDef mapDef = (ElementDef)this._elementDefMap.get(key);
        return mapDef == elementDef;
    }

    public boolean isEmpty() {
        return this._elementDefMap.isEmpty();
    }

    public void addSubstitutionGroupListener(SubstitutionGroupListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeSubstitutionGroupListener(SubstitutionGroupListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    private void _fireEvent(ElementDef elementDef, int type) {
        Enumeration enu;
        if (this._listeners != null && (enu = this._listeners.getListeners()) != null) {
            SubstitutionGroupEvent e = new SubstitutionGroupEvent(this, elementDef, type);
            while (enu.hasMoreElements()) {
                SubstitutionGroupListener l = (SubstitutionGroupListener)enu.nextElement();
                switch (type) {
                    case 1: {
                        l.elementAdded(e);
                        break;
                    }
                    case 2: {
                        l.elementRemoved(e);
                        break;
                    }
                }
            }
        }
    }

    private void $init$() {
        this._elementDefMap = Collections.EMPTY_MAP;
    }
}

