/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.SubstitutionGroupEvent;
import oracle.bali.xml.grammar.SubstitutionGroupListener;
import oracle.bali.xml.grammar.Type;

public abstract class AbstractElementDef
implements ElementDef,
SubstitutionGroupListener {
    private Map _attributeMap;
    private Map _elementMap;
    private ArrayList _substGroups;

    public Collection getAttributeDefs() {
        return this._getAttributeMap().values();
    }

    public final AttributeDef getAttributeDefByName(String attributeName) {
        return this.getAttributeDefByName(null, attributeName);
    }

    public final AttributeDef getAttributeDefByName(String namespace, String attributeName) {
        return this.getAttributeDefByName(QualifiedName.getQualifiedName(namespace, attributeName));
    }

    public AttributeDef getAttributeDefByName(QualifiedName qName) {
        return (AttributeDef)this._getAttributeMap().get(qName);
    }

    public Collection getElementDefs() {
        return this._getElementMap().values();
    }

    public final ElementDef getElementDefByName(String elementName) {
        return this.getElementDefByName(this.getTargetNamespace(), elementName);
    }

    public final ElementDef getElementDefByName(String namespace, String elementName) {
        return this.getElementDefByName(QualifiedName.getQualifiedName(namespace, elementName));
    }

    public ElementDef getElementDefByName(QualifiedName qName) {
        return (ElementDef)this._getElementMap().get(qName);
    }

    public Collection getParentElementDefs() {
        return null;
    }

    public boolean isReference() {
        return false;
    }

    public ElementDef getReferencedElementDef() {
        return null;
    }

    public void addToSubstitutionGroup(ElementDef elementDef) {
        this.getSubstitutionGroup().addElementDef(elementDef);
    }

    public void removeFromSubstitutionGroup(ElementDef elementDef) {
        this.getSubstitutionGroup().removeElementDef(elementDef);
    }

    public QualifiedName getQualifiedName() {
        return QualifiedName.getQualifiedName(this.getTargetNamespace(), this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public void elementAdded(SubstitutionGroupEvent e) {
        ElementDef elementDef = e.getElementDef();
        this._elementMap.put(elementDef.getQualifiedName(), elementDef);
    }

    public void elementRemoved(SubstitutionGroupEvent e) {
        ElementDef elementDef = e.getElementDef();
        if (!this._containedInSubstGroups(elementDef)) {
            this._elementMap.remove(elementDef.getQualifiedName());
        }
    }

    private synchronized Map _getElementMap() {
        if (this._elementMap == null) {
            ComplexType complexType;
            ContentGroup group;
            this._elementMap = new LinkedHashMap();
            Type elementType = this.getType();
            if (elementType != null && elementType instanceof ComplexType && (group = (complexType = (ComplexType)elementType).getContentGroup()) != null) {
                this._addContentGroup(group);
            }
        }
        return this._elementMap;
    }

    private synchronized Map _getAttributeMap() {
        if (this._attributeMap == null) {
            ComplexType complexType;
            Collection attributeDefs;
            this._attributeMap = new LinkedHashMap();
            Type elementType = this.getType();
            if (elementType != null && elementType instanceof ComplexType && (attributeDefs = (complexType = (ComplexType)elementType).getAttributeDefs()) != null) {
                for (AttributeDef attributeDef : attributeDefs) {
                    if (attributeDef.getName() == null) continue;
                    this._attributeMap.put(attributeDef.getQualifiedName(), attributeDef);
                }
            }
        }
        return this._attributeMap;
    }

    private void _addContentGroup(ContentGroup group) {
        Collection groupComponents;
        if (group != null && (groupComponents = group.getComponents()) != null) {
            for (GrammarComponent component : groupComponents) {
                if (component instanceof ContentGroup) {
                    ContentGroup subGroup = (ContentGroup)component;
                    this._addContentGroup(subGroup);
                    continue;
                }
                if (!(component instanceof ElementDef)) continue;
                ElementDef childElement = (ElementDef)component;
                if (!childElement.isAbstract() && childElement.getName() != null) {
                    this._elementMap.put(childElement.getQualifiedName(), childElement);
                }
                SubstitutionGroup substGroup = childElement.getSubstitutionGroup();
                if (this._substGroups == null) {
                    this._substGroups = new ArrayList();
                }
                this._substGroups.add(substGroup);
                substGroup.addSubstitutionGroupListener(this);
                Collection substGroupCollection = substGroup.getElementDefs();
                if (substGroupCollection == null) continue;
                for (ElementDef aSubst : substGroupCollection) {
                    this._elementMap.put(aSubst.getQualifiedName(), aSubst);
                }
            }
        }
    }

    private boolean _containedInSubstGroups(ElementDef elementDef) {
        for (SubstitutionGroup substGroup : this._substGroups) {
            if (!substGroup.containsElementDef(elementDef)) continue;
            return true;
        }
        return false;
    }
}

