/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;

public class GrammarProviderProxy
extends GrammarProvider {
    private GrammarProvider _proxiedGrammarProvider;
    private GrammarProviderListener _eventPercolator;

    public GrammarProviderProxy(GrammarProvider proxiedGrammarProvider) {
        this.$init$();
        if (proxiedGrammarProvider == null) {
            throw new IllegalArgumentException("GrammarProviderProxy:: null argument passed to constructor");
        }
        this._proxiedGrammarProvider = proxiedGrammarProvider;
    }

    public synchronized void changeUnderlyingGrammarProvider(GrammarProvider newGrammarProvider) {
        if (newGrammarProvider == null) {
            throw new IllegalArgumentException("GrammarProviderProxy:: null argument passed to changeUnderlyingGrammarProvider");
        }
        if (this._proxiedGrammarProvider != newGrammarProvider) {
            HashSet oldGrammars = new HashSet(this._proxiedGrammarProvider.getGrammars());
            HashSet newGrammars = new HashSet(newGrammarProvider.getGrammars());
            if (this._eventPercolator != null) {
                this._proxiedGrammarProvider.removeGrammarProviderListener(this._eventPercolator);
            }
            this._proxiedGrammarProvider = newGrammarProvider;
            if (this._eventPercolator != null) {
                this._proxiedGrammarProvider.addGrammarProviderListener(this._eventPercolator);
            }
            this.fireEvent(newGrammars, oldGrammars, Collections.EMPTY_SET);
        }
    }

    public Map getGrammarMap() {
        return this._proxiedGrammarProvider.getGrammarMap();
    }

    public Grammar getGrammarForNamespace(String targetNamespace) {
        return this._proxiedGrammarProvider.getGrammarForNamespace(targetNamespace);
    }

    public Collection getGrammars() {
        return this._proxiedGrammarProvider.getGrammars();
    }

    protected synchronized void firstListenerAttached() {
        if (this._proxiedGrammarProvider != null) {
            this._eventPercolator = new GrammarEventPercolator(null);
            this._proxiedGrammarProvider.addGrammarProviderListener(this._eventPercolator);
        }
    }

    protected synchronized void lastListenerDetached() {
        if (this._proxiedGrammarProvider != null) {
            this._proxiedGrammarProvider.removeGrammarProviderListener(this._eventPercolator);
            this._eventPercolator = null;
        }
    }

    private void $init$() {
        this._proxiedGrammarProvider = null;
        this._eventPercolator = null;
    }

    static void mav$fireEvent(GrammarProviderProxy grammarProviderProxy, Set set, Set set2, Set set3) {
        grammarProviderProxy.fireEvent(set, set2, set3);
    }

    private class GrammarEventPercolator
    implements GrammarProviderListener {
        public void grammarProviderChanged(GrammarProviderEvent e) {
            Set grammarsAdded = e.getGrammarsAdded();
            Set grammarsRemoved = e.getGrammarsRemoved();
            Set grammarsChanged = e.getGrammarsChanged();
            GrammarProviderProxy.mav$fireEvent(GrammarProviderProxy.this, grammarsAdded, grammarsRemoved, grammarsChanged);
        }

        private GrammarEventPercolator() {
        }

        GrammarEventPercolator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

