/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

public class OracleComplexType
implements ComplexType {
    private OracleSchemaFactory _factory;
    private XSDComplexType _xsdComplexType;
    private Type _baseType;
    private ArrayList _attributes;
    private ContentGroup _contentGroup;
    private Annotation _annotation;
    private Wildcard _attributeWildcard;

    public String getName() {
        return this._xsdComplexType.getName();
    }

    public String getTargetNamespace() {
        return this._xsdComplexType.getTargetNS();
    }

    public ContentGroup getContentGroup() {
        return this._getContentGroup();
    }

    public boolean isAbstract() {
        return this._xsdComplexType.isAbstract();
    }

    public Collection getAttributeDefs() {
        return this._getAttributeDefs();
    }

    public Wildcard getAttributeWildcard() {
        return this._getAttributeWildcard();
    }

    public Type getBaseType() {
        return this._getBaseType();
    }

    public int getDerivationMethod() {
        String xsdMethod = this._xsdComplexType.getDerivedMethod();
        if ("extension".equals(xsdMethod)) {
            return 0;
        }
        if ("restriction".equals(xsdMethod)) {
            return 1;
        }
        return 2;
    }

    public int getVariety() {
        int complexVariety = this._xsdComplexType.getContent();
        if (12 == complexVariety) {
            return 3;
        }
        if (13 == complexVariety) {
            return 4;
        }
        if (11 == complexVariety) {
            return 5;
        }
        if (10 == complexVariety) {
            return 6;
        }
        return 10;
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            this._annotation = new OracleAnnotation((XSDNode)this._xsdComplexType);
        }
        return this._annotation;
    }

    OracleComplexType(OracleSchemaFactory factory, XSDComplexType xsdComplexType) {
        this.$init$();
        this._factory = factory;
        this._xsdComplexType = xsdComplexType;
    }

    private synchronized ContentGroup _getContentGroup() {
        XSDGroup xsdGroup;
        if (this._contentGroup == null && (xsdGroup = this._xsdComplexType.getGroup()) != null) {
            this._contentGroup = this._factory.getContentGroupWrapper(xsdGroup);
        }
        return this._contentGroup;
    }

    private synchronized Type _getBaseType() {
        XSDNode xsdType;
        if (this._baseType == null && (xsdType = this._xsdComplexType.getBaseType()) != null) {
            if (xsdType instanceof XSDSimpleType) {
                XSDSimpleType simpleType = (XSDSimpleType)xsdType;
                this._baseType = this._factory.getSimpleTypeWrapper(simpleType);
            } else if (xsdType instanceof XSDComplexType) {
                XSDComplexType complexType = (XSDComplexType)xsdType;
                this._baseType = this._factory.getComplexTypeWrapper(complexType);
            }
        }
        return this._baseType;
    }

    private synchronized ArrayList _getAttributeDefs() {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
            XSDAttribute[] attrs = this._xsdComplexType.getAttributeDeclarations();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.length) {
                    XSDAttribute anAttribute = attrs[i];
                    if (anAttribute != null) {
                        OracleAttributeDef attributeWrapper = this._factory.getAttributeWrapper(anAttribute);
                        this._attributes.add(attributeWrapper);
                    }
                    ++i;
                }
            }
        }
        return this._attributes;
    }

    private synchronized Wildcard _getAttributeWildcard() {
        XSDAny xsdAny;
        if (this._attributeWildcard == null && (xsdAny = this._xsdComplexType.getAttributeWildcard()) != null) {
            this._attributeWildcard = this._factory.getWildcardWrapper(xsdAny);
        }
        return this._attributeWildcard;
    }

    private void $init$() {
        this._factory = null;
        this._xsdComplexType = null;
        this._baseType = null;
        this._attributes = null;
        this._contentGroup = null;
        this._annotation = null;
        this._attributeWildcard = null;
    }
}

