/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema.error;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorLog
extends XMLError
implements ErrorHandler {
    private static final String _KEY_ERROR = "ERROR_LOG";
    private static final String _KEY_ERROR_ERROR = "ERROR_LOG_ERROR";
    private static final String _KEY_ERROR_WARNING = "ERROR_LOG_WARNING";
    private static final String _KEY_ERROR_FATAL = "ERROR_LOG_FATAL_ERROR";
    private ArrayList _errors = new ArrayList();
    private ArrayList _fatalErrors = new ArrayList();
    private ArrayList _warnings = new ArrayList();

    public XmlErrorLog() {
        this.showWarnings(true);
    }

    public void flushErrors() {
        this._errors.clear();
        this._fatalErrors.clear();
        this._warnings.clear();
    }

    public boolean hasFatalErrors() {
        return this._fatalErrors.size() > 0;
    }

    public boolean hasErrors() {
        return this._errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this._warnings.size() > 0;
    }

    public boolean hasAnyErrors() {
        return this.hasWarnings() || this.hasErrors() || this.hasFatalErrors();
    }

    public void error(int param1, int param2, String param3) {
        try {
            int line = -1;
            int col = -1;
            String pubID = "";
            String sysID = "";
            Locator locator = this.getLocator();
            if (locator != null) {
                line = locator.getLineNumber();
                col = locator.getColumnNumber();
                pubID = locator.getPublicId();
                sysID = locator.getSystemId();
            }
            this.error(line, col, pubID, sysID, param3, param1, param2, false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void error(int line, int col, String pubId, String sysId, String mesg, int id, int type, boolean stop) throws XMLParseException {
        Error e = new Error(line, col, pubId, sysId, mesg, id, type, stop);
        switch (type) {
            case 0: {
                this._fatalErrors.add(e);
                break;
            }
            case 1: {
                this._errors.add(e);
                break;
            }
            case 2: {
                this._warnings.add(e);
                break;
            }
            default: {
                super.error(line, col, pubId, sysId, mesg, id, type, stop);
                break;
            }
        }
    }

    public String toString() {
        Error e;
        StringBuffer buffer = new StringBuffer();
        String unformatedText = XmlErrorLog._getTranslatedString(_KEY_ERROR);
        MessageFormat format = new MessageFormat(unformatedText);
        Object[] args = new Object[4];
        args[0] = XmlErrorLog._getTranslatedString(_KEY_ERROR_FATAL);
        Error[] fatalErrors = this.getFatalErrors();
        int i = 0;
        while (i < fatalErrors.length) {
            e = fatalErrors[i];
            args[1] = new Integer(e.getLine());
            args[2] = new Integer(e.getColumn());
            args[3] = e.getMessage();
            buffer.append(format.format(args));
            buffer.append("\n");
            ++i;
        }
        args[0] = XmlErrorLog._getTranslatedString(_KEY_ERROR_ERROR);
        Error[] errors = this.getErrors();
        int i2 = 0;
        while (i2 < errors.length) {
            e = errors[i2];
            args[1] = new Integer(e.getLine());
            args[2] = new Integer(e.getColumn());
            args[3] = e.getMessage();
            buffer.append(format.format(args));
            buffer.append("\n");
            ++i2;
        }
        args[0] = XmlErrorLog._getTranslatedString(_KEY_ERROR_WARNING);
        Error[] warnings = this.getWarnings();
        int i3 = 0;
        while (i3 < warnings.length) {
            e = warnings[i3];
            args[1] = new Integer(e.getLine());
            args[2] = new Integer(e.getColumn());
            args[3] = e.getMessage();
            buffer.append(format.format(args));
            buffer.append("\n");
            ++i3;
        }
        return buffer.toString();
    }

    public Error[] getErrors() {
        return this._errors.toArray(new Error[0]);
    }

    public Error[] getFatalErrors() {
        return this._fatalErrors.toArray(new Error[0]);
    }

    public Error[] getWarnings() {
        return this._warnings.toArray(new Error[0]);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.error(e.getLineNumber(), e.getColumnNumber(), e.getPublicId(), e.getSystemId(), e.getMessage(), -1, 2, false);
    }

    public void error(SAXParseException e) throws SAXException {
        this.error(e.getLineNumber(), e.getColumnNumber(), e.getPublicId(), e.getSystemId(), e.getMessage(), -1, 1, false);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.error(e.getLineNumber(), e.getColumnNumber(), e.getPublicId(), e.getSystemId(), e.getMessage(), -1, 0, false);
    }

    private static String _getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.xml.grammar.schema.error.resource.ErrorBundle", Locale.getDefault());
            String string = b.getString(key);
            return string;
        }
        catch (Exception e) {
            String string = "Key not found";
            return string;
        }
    }

    static String maS$_getTranslatedString(String string) {
        return XmlErrorLog._getTranslatedString(string);
    }

    public class Error {
        private int _line;
        private int _col;
        private String _pubID;
        private String _sysID;
        private String _message;
        private int _id;
        private int _type;
        private boolean _stop;

        public int getLine() {
            return this._line;
        }

        public String getPubID() {
            return this._pubID;
        }

        public String getSysID() {
            return this._sysID;
        }

        public String getMessage() {
            return this._message;
        }

        public int getColumn() {
            return this._col;
        }

        public int getID() {
            return this._id;
        }

        public int getType() {
            return this._type;
        }

        public boolean getStop() {
            return this._stop;
        }

        Error(int line, int col, String pubId, String sysId, String mesg, int id, int type, boolean stop) {
            this._line = line;
            this._col = col;
            this._pubID = pubId;
            this._sysID = sysId;
            this._message = mesg;
            this._id = id;
            this._type = type;
            this._stop = stop;
        }

        public String toString() {
            int index;
            String unformatedText = XmlErrorLog.maS$_getTranslatedString(XmlErrorLog._KEY_ERROR);
            MessageFormat format = new MessageFormat(unformatedText);
            Object[] args = new Object[4];
            String key = null;
            switch (this.getType()) {
                case 0: {
                    key = XmlErrorLog._KEY_ERROR_FATAL;
                    break;
                }
                case 1: {
                    key = XmlErrorLog._KEY_ERROR_ERROR;
                    break;
                }
                case 2: {
                    key = XmlErrorLog._KEY_ERROR_WARNING;
                    break;
                }
            }
            args[0] = XmlErrorLog.maS$_getTranslatedString(key);
            args[1] = new Integer(this.getLine());
            args[2] = new Integer(this.getColumn());
            String message = this.getMessage();
            String id = this.getSysID();
            int n = index = id == null ? -1 : message.indexOf(id);
            if (index != -1) {
                message = message.substring(index + id.length());
            }
            args[3] = message;
            return format.format(args);
        }
    }
}

