/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;
import oracle.bali.xml.grammar.util.GrammarFilter;

public class FilteredGrammarProvider
extends GrammarProvider
implements GrammarProviderListener {
    private LinkedHashMap _filteredGrammarMap;
    private GrammarProvider _base;
    private GrammarFilter _filter;

    public FilteredGrammarProvider(GrammarProvider base, GrammarFilter filter) {
        this.$init$();
        this._base = base;
        this._filter = filter;
        this._base.addGrammarProviderListener(this);
        this._processNewGrammars(this._base.getGrammars(), null);
    }

    public final Map getGrammarMap() {
        return this._filteredGrammarMap;
    }

    public final void grammarProviderChanged(GrammarProviderEvent e) {
        GrammarProviderEvent propEvent = this.createEvent();
        Set grammarsAdded = e.getGrammarsAdded();
        Set grammarsRemoved = e.getGrammarsRemoved();
        Set grammarsChanged = e.getGrammarsChanged();
        for (Grammar removed : grammarsRemoved) {
            String ns = removed.getTargetNamespace();
            Grammar removedProxy = (Grammar)this._filteredGrammarMap.remove(ns);
            if (removedProxy == null) continue;
            propEvent.notifyGrammarRemoved(removedProxy);
        }
        this._processNewGrammars(grammarsAdded, propEvent);
        for (Grammar changed : grammarsChanged) {
            String ns = changed.getTargetNamespace();
            Grammar changedProxy = (Grammar)this._filteredGrammarMap.get(ns);
            if (changedProxy == null) continue;
            propEvent.notifyGrammarChanged(changedProxy);
        }
        this.fireEvent(propEvent);
    }

    private void _processNewGrammars(Collection grammars, GrammarProviderEvent event) {
        for (Grammar g : grammars) {
            if (!this._filter.accept(g)) continue;
            this._filteredGrammarMap.put(g.getTargetNamespace(), g);
            if (event == null) continue;
            event.notifyGrammarAdded(g);
        }
    }

    private void $init$() {
        this._filteredGrammarMap = new LinkedHashMap();
        this._base = null;
        this._filter = null;
    }
}

