/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;

public class GrammarSetEvent
extends EventObject {
    private Set _grammarsAdded;
    private Set _grammarsRemoved;
    private Set _grammarsChanged;

    public GrammarSetEvent(Object source) {
        this(source, null, null, null);
    }

    public GrammarSetEvent(Object source, Set grammarsAdded, Set grammarsRemoved, Set grammarsChanged) {
        super(source);
        this.$init$();
        if (grammarsAdded != null) {
            this._grammarsAdded.addAll(grammarsAdded);
        }
        if (grammarsRemoved != null) {
            this._grammarsRemoved.addAll(grammarsRemoved);
        }
        if (grammarsChanged != null) {
            this._grammarsChanged.addAll(grammarsChanged);
        }
    }

    public Set getGrammarsAdded() {
        return this._grammarsAdded;
    }

    public Set getGrammarsRemoved() {
        return this._grammarsRemoved;
    }

    public Set getGrammarsChanged() {
        return this._grammarsChanged;
    }

    public boolean hasGrammarsAdded() {
        return this._grammarsAdded.isEmpty() ^ true;
    }

    public boolean hasGrammarsRemoved() {
        return this._grammarsRemoved.isEmpty() ^ true;
    }

    public boolean hasGrammarsChanged() {
        return this._grammarsChanged.isEmpty() ^ true;
    }

    public void notifyGrammarAdded(Grammar grammar) {
        this._grammarsAdded.add(grammar);
    }

    public void notifyGrammarRemoved(Grammar grammar) {
        this._grammarsRemoved.add(grammar);
    }

    public void notifyGrammarChanged(Grammar grammar) {
        this._grammarsChanged.add(grammar);
    }

    public void prepareForDelivery() {
        this._grammarsAdded = Collections.unmodifiableSet(this._grammarsAdded);
        this._grammarsRemoved = Collections.unmodifiableSet(this._grammarsRemoved);
        this._grammarsChanged = Collections.unmodifiableSet(this._grammarsChanged);
    }

    public boolean isEmpty() {
        return this._grammarsAdded.isEmpty() && this._grammarsRemoved.isEmpty() && this._grammarsChanged.isEmpty();
    }

    private void $init$() {
        this._grammarsAdded = new HashSet();
        this._grammarsRemoved = new HashSet();
        this._grammarsChanged = new HashSet();
    }
}

