/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.PrefixName;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.grammar.util.SimpleTypePropertyEditorProvider;
import oracle.bali.xml.grammar.util.SimpleTypeValueProvider;
import oracle.bali.xml.util.XmlNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeManager {
    private static JavaTypeManager _typeManager = null;
    private final HashMap<QualifiedName, SimpleTypeConverter> _typeConverterMap = new HashMap();
    private final HashMap<QualifiedName, Class> _propertyEditorClasses = new HashMap();
    private final HashMap<QualifiedName, SimpleTypeValueProvider> _simpleTypeValueProvider = new HashMap();
    private final ArrayList<SimpleTypePropertyEditorProvider> _propertyEditorProviders = new ArrayList();

    public static JavaTypeManager getInstance() {
        if (_typeManager == null) {
            _typeManager = new JavaTypeManager();
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "string", new StringSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "string", new StringValueProvider(null));
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanValueProvider(null));
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "float", new FloatSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "float", new FloatValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "double", new DoubleSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "double", new DoubleValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "integer", new IntegerSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "integer", new IntegerValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "long", new LongSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "long", new LongValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedInt", new IntSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedInt", new IntValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "int", new IntSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "int", new IntValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "short", new ShortSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "short", new ShortValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "byte", new ByteSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "byte", new ByteValueProvider());
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "anyURI", new AnyUriSimpleTypeConverter(null));
            _typeManager.registerSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "QName", new QNameSimpleTypeConverter(null));
        }
        return _typeManager;
    }

    public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
        Object javaObject = value;
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() simpleType parameter cannot be null");
        }
        if (value == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() value parameter cannot be null");
        }
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this._findBestMatch(simpleType, this._typeConverterMap);
            if (converter != null) {
                javaObject = converter.convertToJavaType(value, simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            javaObject = this._handleListVariety(value, simpleType);
        } else if (simpleType.getVariety() == 2) {
            javaObject = value;
        } else {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support union variety simpleTypes");
        }
        return javaObject;
    }

    public Class getJavaClass(SimpleType simpleType) throws GrammarException {
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:getJavaClass() type parameter cannot be null");
        }
        Class javaClass = String.class;
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this._findBestMatch(simpleType, this._typeConverterMap);
            if (converter != null) {
                javaClass = converter.getJavaClass(simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            javaClass = List.class;
        } else if (simpleType.getVariety() == 2) {
            javaClass = String.class;
        } else {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support union variety simpleTypes");
        }
        return javaClass;
    }

    public String convertToString(Object javaType, SimpleType simpleType) throws GrammarException {
        if (javaType == null) {
            throw new IllegalArgumentException("JavaTypeManager.covnertToString(): javaType parameter cannot be null");
        }
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager.covnertToString(): simpleType parameter cannot be null");
        }
        String s = javaType.toString();
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this._findBestMatch(simpleType, this._typeConverterMap);
            if (converter != null) {
                s = converter.convertToString(javaType, simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            s = this._handleListVarietyStringRepresentation(javaType, simpleType);
        } else if (simpleType.getVariety() != 2) {
            throw new GrammarException("JavaTypeManager.covnertToString(): unsupported SimpleType encountered.");
        }
        return s;
    }

    public PropertyEditor getPropertyEditor(SimpleType type) throws GrammarException {
        Class c;
        if (type == null) {
            throw new GrammarException("JavaTypeManager:getPropertyEditor() type parameter cannot be null");
        }
        PropertyEditor pe = null;
        for (SimpleTypePropertyEditorProvider provider : this._propertyEditorProviders) {
            pe = provider.getPropertyEditor(type);
            if (pe != null) break;
        }
        if (pe == null && (c = this._findBestMatch(type, this._propertyEditorClasses)) != null) {
            try {
                pe = (PropertyEditor)c.newInstance();
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException iae) {
                // empty catch block
            }
        }
        return pe;
    }

    public String getSimpleTypeValue(SimpleType type) {
        if (type == null) {
            throw new IllegalArgumentException("JavaTypeManager:getSimpleTypeValue() type parameter cannot be null");
        }
        SimpleTypeValueProvider provider = this._findBestMatch(type, this._simpleTypeValueProvider);
        if (provider != null) {
            return provider.createNewValue(type);
        }
        return null;
    }

    public void registerSimpleTypeConverter(String namespace, String simpleTypeName, SimpleTypeConverter converter) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeConverter(qName, converter);
    }

    public void registerSimpleTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        if (simpleTypeName != null && converter != null) {
            this._typeConverterMap.put(simpleTypeName, converter);
        }
    }

    public final void registerPropertyEditor(String namespace, String simpleTypeName, Class propertyEditor) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerPropertyEditor(qName, propertyEditor);
    }

    public void registerPropertyEditor(QualifiedName simpleTypeName, Class propertyEditor) {
        if (!PropertyEditor.class.isAssignableFrom(propertyEditor)) {
            throw new IllegalArgumentException("propertyEditor must implement java.beans.PropertyEditor");
        }
        if (simpleTypeName != null) {
            this._propertyEditorClasses.put(simpleTypeName, propertyEditor);
        }
    }

    public final void registerPropertyEditor(SimpleTypePropertyEditorProvider provider) {
        if (!this._propertyEditorProviders.contains(provider)) {
            this._propertyEditorProviders.add(provider);
        }
    }

    public final void registerSimpleTypeValueProvider(String namespace, String simpleTypeName, SimpleTypeValueProvider provider) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeValueProvider(qName, provider);
    }

    public void registerSimpleTypeValueProvider(QualifiedName simpleTypeName, SimpleTypeValueProvider provider) {
        if (simpleTypeName != null) {
            this._simpleTypeValueProvider.put(simpleTypeName, provider);
        }
    }

    private List _handleListVariety(String value, SimpleType simpleType) throws GrammarException {
        SimpleType listItemType;
        SimpleTypeConverter itemConverter;
        ArrayList<Object> list = new ArrayList<Object>(3);
        if (value != null && (itemConverter = this._getConverterForListItem(listItemType = simpleType.getListItemType())) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                Object javaObject = item;
                javaObject = itemConverter.convertToJavaType(item, listItemType);
                list.add(javaObject);
            }
        }
        return list;
    }

    private String _handleListVarietyStringRepresentation(Object javaType, SimpleType simpleType) throws GrammarException {
        List l;
        StringBuilder sb = new StringBuilder(3);
        SimpleType listItemType = simpleType.getListItemType();
        SimpleTypeConverter itemConverter = this._getConverterForListItem(listItemType);
        if (itemConverter != null && (l = JavaTypeManager._as(List.class, javaType)) != null) {
            for (Object o : l) {
                String s = itemConverter.convertToString(o, listItemType);
                if (s == null) continue;
                sb.append(s);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    private SimpleTypeConverter _getConverterForListItem(SimpleType simpleType) {
        if (simpleType != null) {
            return this._findBestMatch(simpleType, this._typeConverterMap);
        }
        return null;
    }

    private <T> T _findBestMatch(SimpleType simpleType, HashMap<QualifiedName, T> search) {
        T o = this._getExactMatch(simpleType, search);
        if (o == null && (o = this._getExactMatch(simpleType.getBuiltInBaseType(), search)) == null) {
            o = this._getExactMatch(simpleType.getPrimitiveType(), search);
        }
        return o;
    }

    private <T> T _getExactMatch(SimpleType simpleType, HashMap<QualifiedName, T> search) {
        String simpleName;
        T o = null;
        if (simpleType != null && (simpleName = simpleType.getName()) != null && simpleName.length() > 0 && XmlNameUtils.isValidName(simpleName)) {
            String typeNamespace = simpleType.getTargetNamespace();
            if ("string".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            if ("boolean".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            QualifiedName key = QualifiedName.getQualifiedName(typeNamespace, simpleName);
            o = search.get(key);
        }
        return o;
    }

    private static <T> T _as(Class<T> clazz, Object o) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    private JavaTypeManager() {
    }

    static Object maS$_as(Class clazz, Object object) {
        return JavaTypeManager._as(clazz, object);
    }

    private static class StringSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            return value;
        }

        public Class getJavaClass(SimpleType type) {
            return String.class;
        }

        private StringSimpleTypeConverter() {
        }

        StringSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BooleanSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            if ("true".equals(value) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new GrammarException("BooleanSimpleTypeConverter: " + value + " cannot be converted to this type");
        }

        public Class getJavaClass(SimpleType type) {
            return Boolean.class;
        }

        private BooleanSimpleTypeConverter() {
        }

        BooleanSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DecimalSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                BigDecimal bigDecimal = new BigDecimal(value);
                return bigDecimal;
            }
            catch (Exception e) {
                throw new GrammarException("DecimalSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return BigDecimal.class;
        }

        private DecimalSimpleTypeConverter() {
        }

        DecimalSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class FloatSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Float f = Float.valueOf(value);
                return f;
            }
            catch (Exception e) {
                throw new GrammarException("FloatSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Float.class;
        }

        private FloatSimpleTypeConverter() {
        }

        FloatSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DoubleSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Double d = Double.valueOf(value);
                return d;
            }
            catch (Exception e) {
                throw new GrammarException("DoubleSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Double.class;
        }

        private DoubleSimpleTypeConverter() {
        }

        DoubleSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class IntegerSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                BigInteger bigInteger = new BigInteger(value);
                return bigInteger;
            }
            catch (Exception e) {
                throw new GrammarException("IntegerSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return BigInteger.class;
        }

        private IntegerSimpleTypeConverter() {
        }

        IntegerSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LongSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Long l = Long.valueOf(value);
                return l;
            }
            catch (Exception e) {
                throw new GrammarException("LongSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Long.class;
        }

        private LongSimpleTypeConverter() {
        }

        LongSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class IntSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Integer n = Integer.valueOf(value);
                return n;
            }
            catch (Exception e) {
                throw new GrammarException("IntSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Integer.class;
        }

        private IntSimpleTypeConverter() {
        }

        IntSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ShortSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Short s = Short.valueOf(value);
                return s;
            }
            catch (Exception e) {
                throw new GrammarException("ShortSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Short.class;
        }

        private ShortSimpleTypeConverter() {
        }

        ShortSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ByteSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Byte by = Byte.valueOf(value);
                return by;
            }
            catch (Exception e) {
                throw new GrammarException("ByteSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Byte.class;
        }

        private ByteSimpleTypeConverter() {
        }

        ByteSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class AnyUriSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                URI uRI = new URI(value);
                return uRI;
            }
            catch (Exception e) {
                throw new GrammarException("AnyUriSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return URI.class;
        }

        private AnyUriSimpleTypeConverter() {
        }

        AnyUriSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class QNameSimpleTypeConverter
    extends SimpleTypeConverter {
        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                String prefix = null;
                String localName = null;
                int sepIndex = value.indexOf(58);
                if (sepIndex != -1) {
                    prefix = value.substring(0, sepIndex);
                    if (sepIndex + 1 < value.length()) {
                        localName = value.substring(sepIndex + 1);
                    }
                } else {
                    localName = value;
                }
                PrefixName prefixName = PrefixName.getPrefixName(prefix, localName);
                return prefixName;
            }
            catch (Exception e) {
                throw new GrammarException("QNameSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return PrefixName.class;
        }

        public String convertToString(Object javaType, SimpleType simpleType) {
            if (javaType == null) {
                return null;
            }
            PrefixName pn = null;
            pn = (PrefixName)JavaTypeManager.maS$_as(this.getJavaClass(simpleType), javaType);
            if (pn != null) {
                return pn.getPrefixName();
            }
            return super.convertToString(javaType, simpleType);
        }

        private QNameSimpleTypeConverter() {
        }

        QNameSimpleTypeConverter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class StringValueProvider
    implements SimpleTypeValueProvider {
        public String createNewValue(SimpleType type) {
            return "abc";
        }

        private StringValueProvider() {
        }

        StringValueProvider(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BooleanValueProvider
    implements SimpleTypeValueProvider {
        public String createNewValue(SimpleType type) {
            return "false";
        }

        private BooleanValueProvider() {
        }

        BooleanValueProvider(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DecimalValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DecimalValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.123" + d;
        }
    }

    private static class FloatValueProvider
    implements SimpleTypeValueProvider {
        private float _count = 0.0f;

        FloatValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            float f = this._count;
            this._count = f + 1.0f;
            return "123." + f;
        }
    }

    private static class DoubleValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DoubleValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.12" + d;
        }
    }

    private static class IntegerValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        IntegerValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "123" + this._count++;
        }
    }

    private static class IntValueProvider
    implements SimpleTypeValueProvider {
        private int _count = 0;

        IntValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "12" + this._count++;
        }
    }

    private static class LongValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        LongValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "12345" + this._count++;
        }
    }

    private static class ShortValueProvider
    implements SimpleTypeValueProvider {
        private short _count = 0;

        ShortValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            short s = this._count;
            this._count = (short)(s + 1);
            return String.valueOf(s);
        }
    }

    private static class ByteValueProvider
    implements SimpleTypeValueProvider {
        private byte _count = 0;

        ByteValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            byte by = this._count;
            this._count = (byte)(by + 1);
            return Integer.toHexString(by);
        }
    }
}

