/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.NullMetadataProvider;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateMetadataProvider
implements MetadataProvider {
    private static final Logger _LOGGER = Logger.getLogger(AggregateMetadataProvider.class.getName());
    private final MetadataProvider[] _metadataProviders;

    public static MetadataProvider create(Collection<MetadataProvider> providers) {
        if (providers == null || providers.isEmpty()) {
            return NullMetadataProvider.getInstance();
        }
        return new AggregateMetadataProvider(providers);
    }

    private AggregateMetadataProvider(Collection<MetadataProvider> providers) {
        this._metadataProviders = providers.toArray(new MetadataProvider[0]);
    }

    @Override
    public final Map getMetadata(Object key) {
        HashMap combinedMetadata = new HashMap();
        int i = this._metadataProviders.length - 1;
        while (i >= 0) {
            block3: {
                try {
                    Map metadataMap = this._metadataProviders[i].getMetadata(key);
                    combinedMetadata.putAll(metadataMap);
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block3;
                    LogRecord lr = new LogRecord(Level.WARNING, "Error retriving metadata for item {0} from provider {1}");
                    lr.setParameters(new Object[]{key, this._metadataProviders[i]});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
            --i;
        }
        return combinedMetadata;
    }

    @Override
    public final Object getMetadataItem(Object key, Object itemKey) {
        int i = 0;
        while (i < this._metadataProviders.length) {
            block4: {
                try {
                    Object metadataItem = this._metadataProviders[i].getMetadataItem(key, itemKey);
                    if (metadataItem != null) {
                        Object object = metadataItem;
                        return object;
                    }
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block4;
                    LogRecord lr = new LogRecord(Level.WARNING, "Error retriving metadata item {0} for item {1} from provider {2}");
                    lr.setParameters(new Object[]{key, itemKey, this._metadataProviders[i]});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getFunction(String prefix, String name) {
        int i = 0;
        while (i < this._metadataProviders.length) {
            block4: {
                try {
                    Object function = this._metadataProviders[i].getFunction(prefix, name);
                    if (function != null) {
                        Object object = function;
                        return object;
                    }
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block4;
                    LogRecord lr = new LogRecord(Level.WARNING, "Error retriving function for item {0} from provider {1}");
                    lr.setParameters(new Object[]{name, this._metadataProviders[i]});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public Collection getPseudoXmlKeys(Object baseKey) {
        LinkedList combinedKeys = new LinkedList();
        int i = 0;
        while (i < this._metadataProviders.length) {
            block4: {
                try {
                    Collection pseudoKeys = this._metadataProviders[i].getPseudoXmlKeys(baseKey);
                    if (pseudoKeys != null && !pseudoKeys.isEmpty()) {
                        combinedKeys.addAll(pseudoKeys);
                    }
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block4;
                    LogRecord lr = new LogRecord(Level.WARNING, "Error retriving pseudoXmlKeys for item {0} from provider {1}");
                    lr.setParameters(new Object[]{baseKey, this._metadataProviders[i]});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
            ++i;
        }
        return Collections.unmodifiableCollection(combinedKeys);
    }

    @Override
    public final List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        int i = 0;
        while (i < this._metadataProviders.length) {
            block4: {
                try {
                    List<StructuredMetadataBean> globalMetadataList = this._metadataProviders[i].getGlobalMetadata(globalItemName);
                    if (globalMetadataList != null && !globalMetadataList.isEmpty()) {
                        combinedList.addAll(globalMetadataList);
                    }
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block4;
                    LogRecord lr = new LogRecord(Level.WARNING, "Error retriving global Metadata item {0} from provider {1}");
                    lr.setParameters(new Object[]{globalItemName, this._metadataProviders[i]});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
            ++i;
        }
        return combinedList;
    }
}

