/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomNodeXmlKey {
    public static XmlKey createImmutableXmlKey(GrammarResolver resolver, Node node) {
        List elementPath;
        QualifiedName attrQName = null;
        switch (node.getNodeType()) {
            case 9: {
                return GlobalNodeTypeKey.DOCUMENT_KEY;
            }
            case 3: {
                return GlobalNodeTypeKey.TEXT_KEY;
            }
            case 4: {
                return GlobalNodeTypeKey.CDATA_SECTION_KEY;
            }
            case 8: {
                return GlobalNodeTypeKey.COMMENT_KEY;
            }
            case 7: {
                return GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY;
            }
            case 10: {
                return GlobalNodeTypeKey.DOCUMENT_TYPE_KEY;
            }
            case 2: {
                String attrName = DomUtils.getLocalName(node);
                String namespace = node.getNamespaceURI();
                attrQName = QualifiedName.getQualifiedName(namespace, attrName);
                Element ownerElement = ((Attr)node).getOwnerElement();
                if (ownerElement != null) break;
                throw new IllegalArgumentException(DomNodeXmlKey._getBadNodeErrorMessage(node));
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type: " + node.getNodeType() + " node=" + node);
            }
        }
        if ((elementPath = DomNodeXmlKey.createElementQNamePath(resolver, node)) == null) {
            return null;
        }
        if (attrQName != null) {
            return ImmutableXmlKey.createAttributeKey(elementPath, attrQName);
        }
        return ImmutableXmlKey.createElementKey(elementPath);
    }

    public static List createElementQNamePath(GrammarResolver resolver, Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        QualifiedName attrQName = null;
        Element element = null;
        switch (nodeType) {
            case 2: {
                element = ((Attr)node).getOwnerElement();
                attrQName = QualifiedName.getQualifiedName(node.getNamespaceURI(), DomUtils.getLocalName(node));
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                return null;
            }
        }
        return DomNodeXmlKey._createElementQNamePath(resolver, element, attrQName);
    }

    private static List _createElementQNamePath(GrammarResolver resolver, Element element, QualifiedName attrQName) {
        ArrayList<Object> elementNamePath;
        if (element == null) {
            return null;
        }
        int subtreeDepth = DomUtils.getNodeSubtreeDepth(element);
        Node topAncestor = DomUtils.getAncestor(element, subtreeDepth - 1);
        if (topAncestor.getNodeType() == 9) {
            --subtreeDepth;
        }
        ArrayList<Object> defPath = new ArrayList<Object>(subtreeDepth);
        int i = 0;
        while (i < subtreeDepth) {
            defPath.add(null);
            ++i;
        }
        int startPathIndex = subtreeDepth - 1;
        Element currentElement = element;
        while (true) {
            defPath.set(startPathIndex, currentElement);
            Node parentNode = currentElement.getParentNode();
            if (parentNode == null || parentNode.getNodeType() != 1) break;
            currentElement = (Element)parentNode;
            --startPathIndex;
        }
        ElementDef currentDef = null;
        int i2 = startPathIndex;
        while (i2 < subtreeDepth) {
            FixedAttributeElementDef variant;
            String fVal;
            QualifiedName fAttrName;
            Grammar grammar;
            currentElement = (Element)defPath.get(i2);
            String namespace = currentElement.getNamespaceURI();
            String localName = DomUtils.getLocalName(currentElement);
            ElementDef tempDef = null;
            if (currentDef != null) {
                tempDef = currentDef.getElementDefByName(namespace, localName);
            }
            if (tempDef == null && (grammar = resolver.getGrammarForNamespace(namespace)) != null) {
                tempDef = grammar.getElementDefByName(localName);
            }
            if (tempDef != null && (fAttrName = resolver.getFixedAttributeName(tempDef)) != null && (fVal = currentElement.getAttributeNS(fAttrName.getNamespace(), fAttrName.getName())) != null && fVal.length() > 0 && (variant = resolver.getFixedAttributeElementDef(tempDef, fAttrName, fVal)) != null) {
                tempDef = variant;
            }
            if ((currentDef = tempDef) == null) {
                startPathIndex = i2 + 1;
            }
            defPath.set(i2, currentDef);
            ++i2;
        }
        if (attrQName != null) {
            boolean isGlobalAttr = false;
            boolean hasNamespace = false;
            boolean hasNamespaceGrammar = false;
            AttributeDef globalDef = null;
            AttributeDef localDef = null;
            String attrNamespace = attrQName.getNamespace();
            if (attrNamespace != null && attrNamespace.length() != 0) {
                hasNamespace = true;
                Grammar attrGrammar = resolver.getGrammarForNamespace(attrNamespace);
                if (attrGrammar != null) {
                    hasNamespaceGrammar = true;
                    globalDef = attrGrammar.getAttributeDefByName(attrQName.getName());
                }
            }
            if (currentDef != null && (localDef = currentDef.getAttributeDefByName(attrQName)) != null && localDef.isReference()) {
                localDef = localDef.getReferencedAttributeDef();
            }
            if (localDef != null) {
                if (globalDef != null) {
                    isGlobalAttr = localDef == globalDef;
                }
            } else {
                isGlobalAttr = hasNamespace;
                if (isGlobalAttr && hasNamespaceGrammar && globalDef == null) {
                    isGlobalAttr = false;
                }
            }
            if (isGlobalAttr) {
                return Collections.EMPTY_LIST;
            }
        }
        if (startPathIndex == subtreeDepth) {
            QualifiedName elementQName = QualifiedName.getQualifiedName(element.getNamespaceURI(), DomUtils.getLocalName(element));
            return Collections.singletonList(elementQName);
        }
        int globalStartIndex = GrammarUtils.getMinimalElementDefPathStartIndex(resolver, defPath, startPathIndex);
        if (globalStartIndex == 0) {
            elementNamePath = defPath;
        } else {
            int pathSize = defPath.size();
            if (pathSize == globalStartIndex) {
                globalStartIndex = subtreeDepth - 1;
                elementNamePath = new ArrayList(1);
            }
            elementNamePath = new ArrayList(pathSize - globalStartIndex);
        }
        GrammarUtils.copyElementQNamesFromElementDefs(defPath, globalStartIndex, elementNamePath);
        return elementNamePath;
    }

    private static String _getBadNodeErrorMessage(Node node) {
        return "No absolute path to Node " + node + "(" + DomUtils.getLocalName(node) + ")";
    }
}

