/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.functions.MethodFunction;

public class MetadataFunctionRegistry {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Map<String, MetadataFunction> _functionMap;
    private static final Logger _LOGGER;

    public MetadataFunctionRegistry() {
        this.$init$();
    }

    public void registerMethod(String qname, String className, String nameAndSig, boolean isMacro) {
        this._functionMap.put(qname, new MethodFunction(className, nameAndSig, isMacro));
    }

    public void registerInstanceFunction(String qname, String className) {
        try {
            Class clazz = ClassLoaderUtils.loadClass((String)className);
            Object instance = clazz.newInstance();
            if (instance instanceof MetadataFunction) {
                MetadataFunction function = (MetadataFunction)instance;
                this._functionMap.put(qname, function);
            }
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Exception creating object for instance metadata function; name={0} classname={1}");
            lr.setThrown(e);
            lr.setParameters(new Object[]{qname, className});
            _LOGGER.log(lr);
        }
    }

    public void unregisterFunction(String qname) {
        this._functionMap.remove(qname);
    }

    static {
        $assertionsDisabled = MetadataFunctionRegistry.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(MetadataFunctionRegistry.class.getName());
    }

    public MetadataFunction getFunction(String prefix, String name) {
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this._functionMap.get(prefix + ":" + name);
    }

    private void $init$() {
        this._functionMap = new HashMap<String, MetadataFunction>();
    }
}

