/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.List;
import java.util.WeakHashMap;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;

public abstract class XmlKey {
    public static final short NAMESPACE_NODE = 0;
    private static final String[] _NODE_TYPE_STRINGS = new String[]{"Namespace", "Element", "Attribute", "Text", "CDATA", "EntityReference", "Entity", "Processing Instruction", "Comment", "Document", "Document Type", "Document Fragment", "Notation"};
    private static final Class _CLASS = XmlKey.class;
    private static final int _INITIAL_RESULT = 17;
    private static final int _RESULT_MULTIPLIER = 37;
    private static final WeakHashMap _sInternedKeys = new WeakHashMap(503, 0.5f);
    private int _cachedHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XmlKey intern() {
        Class clazz = _CLASS;
        synchronized (clazz) {
            Object internedKeyObject = _sInternedKeys.get(this);
            if (internedKeyObject != null) {
                XmlKey xmlKey = (XmlKey)internedKeyObject;
                return xmlKey;
            }
            XmlKey internedKey = XmlKey.getImmutableKey(this);
            _sInternedKeys.put(internedKey, internedKey);
            XmlKey xmlKey = internedKey;
            return xmlKey;
        }
    }

    public static XmlKey getImmutableKey(XmlKey key) {
        if (key.isImmutable()) {
            return key;
        }
        switch (key.getNodeType()) {
            case 9: {
                return GlobalNodeTypeKey.DOCUMENT_KEY;
            }
            case 10: {
                return GlobalNodeTypeKey.DOCUMENT_TYPE_KEY;
            }
            case 3: {
                return GlobalNodeTypeKey.TEXT_KEY;
            }
            case 4: {
                return GlobalNodeTypeKey.CDATA_SECTION_KEY;
            }
            case 8: {
                return GlobalNodeTypeKey.COMMENT_KEY;
            }
            case 7: {
                return GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY;
            }
            case 1: {
                return ImmutableXmlKey.createElementKey(key.getElementQNamePath());
            }
            case 2: {
                return ImmutableXmlKey.createAttributeKey(key.getElementQNamePath(), key.getAttributeQName());
            }
            case 0: {
                return ImmutableXmlKey.createNamespaceKey(key.getNamespace());
            }
        }
        throw new IllegalArgumentException("Unknown node type for:" + key);
    }

    public short getNodeType() {
        if (this.getAttributeQName() != null) {
            return 2;
        }
        if (this.getElementQName() != null) {
            return 1;
        }
        return 0;
    }

    public String getNamespace() {
        QualifiedName attributeQName = this.getAttributeQName();
        if (attributeQName != null) {
            return attributeQName.getNamespace();
        }
        QualifiedName elementQName = this.getElementQName();
        if (elementQName != null) {
            return elementQName.getNamespace();
        }
        throw new IllegalStateException("No namespace for:" + this);
    }

    public abstract List getElementQNamePath();

    public abstract QualifiedName getAttributeQName();

    public abstract boolean isImmutable();

    public final String getTargetNamespace() {
        QualifiedName elementQName;
        String namespaceURI;
        QualifiedName attributeQName;
        String targetNamespace = this.getNamespace();
        if (targetNamespace == null && (attributeQName = this.getAttributeQName()) != null && (namespaceURI = attributeQName.getNamespace()) == null && (elementQName = this.getElementQName()) != null) {
            targetNamespace = elementQName.getNamespace();
        }
        return targetNamespace;
    }

    public String getLocalName() {
        String localName = null;
        QualifiedName attributeQName = this.getAttributeQName();
        if (attributeQName != null) {
            localName = attributeQName.getName();
        } else {
            QualifiedName elementQName = this.getElementQName();
            if (elementQName != null) {
                localName = elementQName.getName();
            }
        }
        return localName;
    }

    public QualifiedName getElementQName() {
        int pathSize;
        List elementNamePath = this.getElementQNamePath();
        if (elementNamePath != null && (pathSize = elementNamePath.size()) > 0) {
            return (QualifiedName)elementNamePath.get(pathSize - 1);
        }
        return null;
    }

    public final int hashCode() {
        QualifiedName attributeQName;
        List elementQNamePath;
        String namespace;
        if (this._cachedHash != -1) {
            return this._cachedHash;
        }
        int result = 17;
        short nodeType = this.getNodeType();
        result = result * 37 + nodeType;
        result *= 37;
        if (nodeType == 0 && (namespace = this.getNamespace()) != null) {
            result += this.getNamespace().hashCode();
        }
        if ((elementQNamePath = this.getElementQNamePath()) != null) {
            int pathSize = elementQNamePath.size();
            int i = 0;
            while (i < pathSize) {
                QualifiedName elementQName = (QualifiedName)elementQNamePath.get(i);
                result = result * 37 + elementQName.hashCode();
                ++i;
            }
        }
        if ((attributeQName = this.getAttributeQName()) != null) {
            result = result * 37 + attributeQName.hashCode();
        }
        this._cachedHash = this.isImmutable() ? result : -1;
        return result;
    }

    public final boolean equals(Object obj) {
        QualifiedName keyAttributeQName;
        int keyPathSize;
        short keyNodeType;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XmlKey)) {
            return false;
        }
        XmlKey key = (XmlKey)obj;
        if (this.isImmutable() && key.isImmutable() && this.hashCode() != key.hashCode()) {
            return false;
        }
        short thisNodeType = this.getNodeType();
        if (thisNodeType != (keyNodeType = key.getNodeType())) {
            return false;
        }
        if (thisNodeType == 0) {
            String thisNamespace = this.getNamespace();
            String keyNamespace = key.getNamespace();
            if (thisNamespace == null ? keyNamespace != null : !thisNamespace.equals(keyNamespace)) {
                return false;
            }
        }
        List thisPath = this.getElementQNamePath();
        List keyPath = key.getElementQNamePath();
        int thisPathSize = thisPath != null ? thisPath.size() : 0;
        int n = keyPathSize = keyPath != null ? keyPath.size() : 0;
        if (thisPathSize != keyPathSize) {
            return false;
        }
        int i = 0;
        while (i < thisPathSize) {
            QualifiedName keyElement;
            QualifiedName thisElement = (QualifiedName)thisPath.get(i);
            if (thisElement != (keyElement = (QualifiedName)keyPath.get(i))) {
                return false;
            }
            ++i;
        }
        QualifiedName thisAttributeQName = this.getAttributeQName();
        return thisAttributeQName == (keyAttributeQName = key.getAttributeQName());
    }

    public String toString() {
        String outString = super.toString();
        short nodeType = this.getNodeType();
        String nodeTypeString = nodeType >= 0 && nodeType < _NODE_TYPE_STRINGS.length ? _NODE_TYPE_STRINGS[nodeType] : "Unknown";
        outString = outString + ", type=" + nodeTypeString;
        if (nodeType == 0) {
            outString = outString + ", namespace=" + this.getNamespace();
        } else {
            QualifiedName attrQName;
            int elementQNameCount;
            List elementQNamePath = this.getElementQNamePath();
            int n = elementQNameCount = elementQNamePath != null ? elementQNamePath.size() : 0;
            if (elementQNameCount > 0) {
                if (elementQNameCount == 1) {
                    outString = outString + ", element=" + ((QualifiedName)elementQNamePath.get(0)).getQualifiedName();
                } else {
                    outString = outString + ", elementPath=[";
                    int i = 0;
                    while (i < elementQNameCount) {
                        outString = outString + ((QualifiedName)elementQNamePath.get(i)).getQualifiedName();
                        if (++i >= elementQNameCount) continue;
                        outString = outString + ",";
                    }
                    outString = outString + "]";
                }
            }
            if ((attrQName = this.getAttributeQName()) != null) {
                outString = outString + ", attr=" + attrQName.getQualifiedName();
            }
        }
        return outString;
    }

    private void $init$() {
        this._cachedHash = -1;
    }

    public XmlKey() {
        this.$init$();
    }
}

