/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.HashMap;
import java.util.Locale;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.metadata.XmlMetadataConstants;

public class XmlMetadataTypeConverters {
    private XmlMetadataTypeConverters() {
    }

    public static void registerConverters(ClassLoader loader, Locale locale) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        JavaTypeManager tm = JavaTypeManager.getInstance();
        tm.registerSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS, new JavaClassConverter(loader));
        tm.registerSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSINSTANCE, new JavaClassInstanceConverter(loader));
        tm.registerSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSORDIRECTOBJECT, new JavaClassOrDirectObjectConverter(loader));
    }

    private static class JavaClassConverter
    extends SimpleTypeConverter {
        private static HashMap _sPrimitiveTypes = new HashMap();
        private final ClassLoader _loader;

        public JavaClassConverter(ClassLoader loader) {
            this._loader = loader;
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            Class primitiveClass = (Class)_sPrimitiveTypes.get(value);
            if (primitiveClass != null) {
                return primitiveClass;
            }
            if (Character.isUpperCase(value.charAt(0))) {
                value = "java.lang." + value;
            }
            if (value.endsWith("[]")) {
                return String[].class;
            }
            try {
                Class clazz = ClassLoaderUtils.loadClass((String)value, (ClassLoader)this._loader);
                return clazz;
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Class.class;
        }

        static {
            _sPrimitiveTypes.put("char", Character.TYPE);
            _sPrimitiveTypes.put("byte", Byte.TYPE);
            _sPrimitiveTypes.put("short", Short.TYPE);
            _sPrimitiveTypes.put("int", Integer.TYPE);
            _sPrimitiveTypes.put("long", Long.TYPE);
            _sPrimitiveTypes.put("float", Float.TYPE);
            _sPrimitiveTypes.put("double", Double.TYPE);
            _sPrimitiveTypes.put("boolean", Boolean.TYPE);
        }
    }

    private static class JavaClassInstanceConverter
    extends SimpleTypeConverter {
        private final ClassLoader _loader;

        public JavaClassInstanceConverter(ClassLoader loader) {
            this._loader = loader;
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Class c = ClassLoaderUtils.loadClass((String)value, (ClassLoader)this._loader);
                Object t = c.newInstance();
                return t;
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }

    private static class JavaClassOrDirectObjectConverter
    extends SimpleTypeConverter {
        private final ClassLoader _loader;

        JavaClassOrDirectObjectConverter(ClassLoader loader) {
            this._loader = loader;
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Class clazz = ClassLoaderUtils.loadClass((String)value, (ClassLoader)this._loader);
                return clazz;
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }
}

