/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTBinaryOperator;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Coercions;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;
import oracle.bali.xml.metadata.el.impl.Relational;

public class ASTNotEquals
extends ASTBinaryOperator {
    private static final ASTNotEquals _sInstance = new ASTNotEquals();

    public Object apply(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object lhs = left.getValue(vResolver);
        if (lhs == null) {
            return PrimitiveTypes.getBoolean(right.getValue(vResolver) != null);
        }
        Object rhs = right.getValue(vResolver);
        if (rhs == null) {
            return PrimitiveTypes.getBoolean(true);
        }
        if (lhs == rhs) {
            return PrimitiveTypes.getBoolean(false);
        }
        if (Relational.shouldCoercetoDouble(lhs) || Relational.shouldCoercetoDouble(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toDouble(lhs) != Coercions.toDouble(rhs));
        }
        if (Relational.shouldCoercetoLong(lhs) || Relational.shouldCoercetoLong(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toLong(lhs) != Coercions.toLong(rhs));
        }
        if (Relational.shouldCoercetoBoolean(lhs) || Relational.shouldCoercetoBoolean(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toBoolean(lhs) != Coercions.toBoolean(rhs));
        }
        if (Relational.shouldCoercetoString(lhs) || Relational.shouldCoercetoString(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toString(lhs).equals(Coercions.toString(rhs)) ^ true);
        }
        return PrimitiveTypes.getBoolean(lhs.equals(rhs) ^ true);
    }

    public void toString(StringBuffer buffer, ASTOperand left, ASTOperand right) {
        buffer.append('(');
        left.toString(buffer);
        buffer.append(" != ");
        right.toString(buffer);
        buffer.append(')');
    }

    public Class getType(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        return Boolean.class;
    }

    public static ASTNotEquals sharedInstance() {
        return _sInstance;
    }

    private ASTNotEquals() {
    }
}

