/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.Expression;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;
import oracle.bali.xml.metadata.el.parser.ELParseException;

class Coercions {
    private static final BigDecimal _BIG_ZERO = new BigDecimal(0.0);

    public static Object toObject(VariableResolver vResolver, Expression expr, Class targetType) throws ELException {
        if (Expression.class.equals((Object)targetType)) {
            return expr;
        }
        return Coercions.toObject(expr.getValue(vResolver), targetType);
    }

    public static Object toObject(Object value, Class targetType) throws ELParseException {
        block22: {
            if (value == null && !targetType.isPrimitive()) {
                return null;
            }
            if (Boolean.class.equals((Object)targetType) || Boolean.TYPE.equals(targetType)) {
                return PrimitiveTypes.getBoolean(Coercions.toBoolean(value));
            }
            if (Byte.class.equals((Object)targetType) || Byte.TYPE.equals(targetType)) {
                return PrimitiveTypes.getByte(Coercions.toByte(value));
            }
            if (Character.class.equals((Object)targetType) || Character.TYPE.equals(targetType)) {
                return PrimitiveTypes.getCharacter(Coercions.toChar(value));
            }
            if (Double.class.equals((Object)targetType) || Byte.TYPE.equals(targetType)) {
                return PrimitiveTypes.getDouble(Coercions.toDouble(value));
            }
            if (Float.class.equals((Object)targetType) || Byte.TYPE.equals(targetType)) {
                return PrimitiveTypes.getFloat(Coercions.toFloat(value));
            }
            if (Integer.class.equals((Object)targetType) || Integer.TYPE.equals(targetType)) {
                return PrimitiveTypes.getInteger(Coercions.toInt(value));
            }
            if (Long.class.equals((Object)targetType) || Long.TYPE.equals(targetType)) {
                return PrimitiveTypes.getLong(Coercions.toLong(value));
            }
            if (Short.class.equals((Object)targetType) || Short.TYPE.equals(targetType)) {
                return PrimitiveTypes.getShort(Coercions.toShort(value));
            }
            if (BigInteger.class.equals((Object)targetType)) {
                return Coercions.toBigInteger(value);
            }
            if (BigDecimal.class.equals((Object)targetType)) {
                return Coercions.toBigDecimal(value);
            }
            if (String.class.equals((Object)targetType)) {
                return Coercions.toString(value);
            }
            if (targetType.isArray()) {
                return Coercions.toArray(value, targetType);
            }
            if (value == null) {
                return null;
            }
            Class<?> valueClass = value.getClass();
            if (targetType.isAssignableFrom(valueClass)) {
                return value;
            }
            if (String.class.equals(valueClass)) {
                String valueString = value.toString();
                try {
                    PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
                    if (editor == null) {
                        if (valueString.length() == 0) {
                            Object var7_5 = null;
                            return var7_5;
                        }
                        break block22;
                    }
                    editor.setAsText(valueString);
                    Object object = editor.getValue();
                    return object;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (valueString.length() == 0) {
                        Object var9_9 = null;
                        return var9_9;
                    }
                    throw new ELParseException("Could not coerce " + value + " to " + targetType, t);
                }
            }
        }
        throw new ELParseException("Could not coerce " + value + " to " + targetType);
    }

    public static Object toArray(Object value, Class arrayType) throws ELParseException {
        Class<?> componentType = arrayType.getComponentType();
        if (value == null) {
            return Array.newInstance(componentType, 0);
        }
        if (arrayType.isAssignableFrom(value.getClass())) {
            return value;
        }
        String valueString = Coercions.toString(value);
        StringTokenizer tokens = new StringTokenizer(valueString);
        int count = tokens.countTokens();
        Object array = Array.newInstance(componentType, count);
        int i = 0;
        while (tokens.hasMoreTokens()) {
            Array.set(array, i, Coercions.toObject(tokens.nextToken(), componentType));
            ++i;
        }
        return array;
    }

    public static String toString(Object value) throws ELParseException {
        if (value == null) {
            return "";
        }
        if (String.class.equals(value.getClass())) {
            return (String)value;
        }
        return value.toString();
    }

    public static BigInteger toBigInteger(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return BigInteger.ZERO;
        }
        Class<?> valueClass = value.getClass();
        if (BigInteger.class.equals(valueClass)) {
            return (BigInteger)value;
        }
        if (BigDecimal.class.equals(valueClass)) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (Character.class.equals(valueClass)) {
            return BigInteger.valueOf((short)((Character)value).charValue());
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (String.class.equals(valueClass)) {
            return new BigInteger((String)value);
        }
        throw new ELParseException("Could not coerce " + value + " to BigInteger");
    }

    public static BigDecimal toBigDecimal(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return _BIG_ZERO;
        }
        Class<?> valueClass = value.getClass();
        if (BigDecimal.class.equals(valueClass)) {
            return (BigDecimal)value;
        }
        if (BigInteger.class.equals(valueClass)) {
            return new BigDecimal((BigInteger)value);
        }
        if (Character.class.equals(valueClass)) {
            return new BigDecimal((short)((Character)value).charValue());
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (String.class.equals(valueClass)) {
            return new BigDecimal((String)value);
        }
        throw new ELParseException("Could not coerce " + value + " to BigDecimal");
    }

    public static byte toByte(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0;
        }
        Class<?> valueClass = value.getClass();
        if (Byte.class.equals(valueClass)) {
            return (Byte)value;
        }
        if (Character.class.equals(valueClass)) {
            return (byte)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).byteValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                byte by = Byte.parseByte((String)value);
                return by;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to byte", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to byte");
    }

    public static short toShort(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0;
        }
        Class<?> valueClass = value.getClass();
        if (Short.class.equals(valueClass)) {
            return (Short)value;
        }
        if (Character.class.equals(valueClass)) {
            return (short)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).shortValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                short s = Short.parseShort((String)value);
                return s;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to short", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to short");
    }

    public static int toInt(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0;
        }
        Class<?> valueClass = value.getClass();
        if (Integer.class.equals(valueClass)) {
            return (Integer)value;
        }
        if (Character.class.equals(valueClass)) {
            return (short)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).intValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                int n = Integer.parseInt((String)value);
                return n;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to int", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to int");
    }

    public static long toLong(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        Class<?> valueClass = value.getClass();
        if (Long.class.equals(valueClass)) {
            return (Long)value;
        }
        if (Character.class.equals(valueClass)) {
            return (short)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).longValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                long l = Long.parseLong((String)value);
                return l;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to long", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to long");
    }

    public static float toFloat(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0.0f;
        }
        Class<?> valueClass = value.getClass();
        if (Float.class.equals(valueClass)) {
            return ((Float)value).floatValue();
        }
        if (Character.class.equals(valueClass)) {
            return (short)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).floatValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                float f = Float.parseFloat((String)value);
                return f;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to float", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to float");
    }

    public static double toDouble(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        Class<?> valueClass = value.getClass();
        if (Double.class.equals(valueClass)) {
            return (Double)value;
        }
        if (Character.class.equals(valueClass)) {
            return (short)((Character)value).charValue();
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return ((Number)value).doubleValue();
        }
        if (String.class.equals(valueClass)) {
            try {
                double d = Double.parseDouble((String)value);
                return d;
            }
            catch (NumberFormatException e) {
                throw new ELParseException("Could not coerce " + value + " to double", e);
            }
        }
        throw new ELParseException("Could not coerce " + value + " to double");
    }

    public static char toChar(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return '\u0000';
        }
        Class<?> valueClass = value.getClass();
        if (Character.class.equals(valueClass)) {
            return ((Character)value).charValue();
        }
        if (String.class.equals(valueClass)) {
            return ((String)value).charAt(0);
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return (char)((Number)value).shortValue();
        }
        throw new ELParseException("Could not coerce " + value + " to char");
    }

    public static boolean toBoolean(Object value) throws ELParseException {
        if (value == null || "".equals(value)) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        if (Boolean.class.equals(valueClass)) {
            return (Boolean)value;
        }
        if (String.class.equals(valueClass)) {
            return "true".equals((String)value);
        }
        throw new ELParseException("Could not coerce " + value + " to boolean");
    }

    private Coercions() {
    }
}

