/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.metadata.el.ELException;

final class Lookups {
    public static final Object lookupArray(Object array, int index) throws ELException {
        try {
            Object object = Array.get(array, index);
            return object;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object var5_4 = null;
            return var5_4;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupList(List list, int index) throws ELException {
        try {
            Object e = list.get(index);
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            Object var5_4 = null;
            return var5_4;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupMap(Map map, Object key) throws ELException {
        return map.get(key);
    }

    public static final Object lookupBean(Class beanClass, Object bean, String property) throws ELException {
        Method reader = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                if (property.equals(pds[i].getName())) {
                    reader = pds[i].getReadMethod();
                    if (reader != null) {
                        Object object = reader.invoke(bean, null);
                        return object;
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        if (reader == null) {
            throw new ELException(property + " is not readable");
        }
        return null;
    }

    public static final void updateArray(Object array, int index, Object value) throws ELException {
        try {
            Array.set(array, index, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateList(List list, int index, Object value) throws ELException {
        try {
            list.set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateMap(Map map, Object key, Object value) throws ELException {
        map.put(key, value);
    }

    public static final void updateBean(Class beanClass, Object bean, String property, Object value) throws ELException {
        Method writer = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                if (property.equals(pds[i].getName())) {
                    writer = pds[i].getWriteMethod();
                    if (writer == null) break;
                    try {
                        writer.invoke(bean, value);
                    }
                    catch (Exception e) {
                        throw new ELException("Error setting value " + value + " on property " + pds[i].getName() + " of " + bean, e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            if (e instanceof ELException) {
                throw (ELException)e;
            }
            throw new ELException(e);
        }
        if (writer == null) {
            throw new ELException(property + " is not writable");
        }
    }

    public static final boolean isBeanReadOnly(Class beanClass, Object bean, String property) throws ELException {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                if (property.equals(pds[i].getName())) {
                    Method writer = pds[i].getWriteMethod();
                    if (writer == null) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        throw new ELException("Property \"" + property + "\" does not exist");
    }

    public static final Class getBeanType(Class beanClass, Object bean, String property) throws ELException {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                if (property.equals(pds[i].getName())) {
                    Method reader = pds[i].getReadMethod();
                    if (reader != null) {
                        Class<?> clazz = reader.getReturnType();
                        return clazz;
                    }
                    Method writer = pds[i].getWriteMethod();
                    if (writer != null) {
                        Class<?> clazz = writer.getParameterTypes()[0];
                        return clazz;
                    }
                    throw new ELException("No writers or readers for property \"" + property + "\"");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        throw new ELException("Property \"" + property + "\" does not exist");
    }

    private Lookups() {
    }
}

