/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.grammar;

import java.util.List;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.XmlKey;

public class GrammarUtils {
    public static final ElementDef getElementDef(GrammarProvider provider, XmlKey key) {
        return GrammarUtils.getElementDef(new GrammarResolver(provider), key);
    }

    public static final AttributeDef getAttributeDef(GrammarProvider provider, XmlKey key) {
        return GrammarUtils.getAttributeDef(new GrammarResolver(provider), key);
    }

    public static final GrammarComponent getGrammarComponent(GrammarProvider provider, XmlKey key) {
        return GrammarUtils.getGrammarComponent(new GrammarResolver(provider), key);
    }

    public static final GrammarComponent getGrammarComponent(GrammarResolver resolver, XmlKey key) {
        GrammarComponent component = null;
        if (key != null) {
            String namespace = key.getTargetNamespace();
            switch (key.getNodeType()) {
                case 0: {
                    component = resolver.getGrammarForNamespace(namespace);
                    break;
                }
                case 1: {
                    component = GrammarUtils._getLastElementDef(resolver, key);
                    break;
                }
                case 2: {
                    ElementDef elementDef = GrammarUtils._getLastElementDef(resolver, key);
                    QualifiedName attrName = key.getAttributeQName();
                    if (elementDef != null) {
                        component = elementDef.getAttributeDefByName(attrName);
                        break;
                    }
                    Grammar g = resolver.getGrammarForNamespace(attrName.getNamespace());
                    if (g == null) break;
                    component = g.getAttributeDefByName(attrName.getName());
                    break;
                }
            }
        }
        return component;
    }

    public static final Grammar getGrammar(GrammarResolver resolver, XmlKey key) {
        return (Grammar)GrammarUtils.getGrammarComponent(resolver, key);
    }

    public static final ElementDef getElementDef(GrammarResolver resolver, XmlKey key) {
        return (ElementDef)GrammarUtils.getGrammarComponent(resolver, key);
    }

    public static final AttributeDef getAttributeDef(GrammarResolver resolver, XmlKey key) {
        return (AttributeDef)GrammarUtils.getGrammarComponent(resolver, key);
    }

    public static boolean isElementDefGloballyDefined(GrammarResolver resolver, ElementDef elementDef) {
        boolean isGlobal = true;
        if (!elementDef.isReference()) {
            QualifiedName elementQName = elementDef.getQualifiedName();
            String namespace = elementQName.getNamespace();
            String localName = elementQName.getName();
            String fixedAttrNS = elementQName.getAttributeNamespace();
            String fixedAttrName = elementQName.getAttributeName();
            String fixedAttrValue = elementQName.getAttributeValue();
            Grammar grammar = resolver.getGrammarForNamespace(namespace);
            if (grammar == null) {
                isGlobal = false;
            } else {
                QualifiedName fQName;
                FixedAttributeElementDef fElementDef;
                ElementDef globalElementDef = grammar.getElementDefByName(localName);
                if (fixedAttrName != null && fixedAttrValue != null && (fElementDef = resolver.getFixedAttributeElementDef(globalElementDef, fQName = QualifiedName.getQualifiedName(fixedAttrNS, fixedAttrName), fixedAttrValue)) != null) {
                    globalElementDef = fElementDef;
                }
                isGlobal = elementDef == globalElementDef;
            }
        }
        return isGlobal;
    }

    public static void copyElementQNamesFromElementDefs(List elementDefs, int offset, List elementQNames) {
        int defSize = elementDefs.size();
        int defCount = defSize - offset;
        if (elementDefs == elementQNames) {
            int i = 0;
            while (i < defCount) {
                ElementDef trimDef = (ElementDef)elementDefs.get(i + offset);
                elementQNames.set(i, trimDef.getQualifiedName());
                ++i;
            }
        } else {
            int i = offset;
            while (i < defSize) {
                ElementDef trimDef = (ElementDef)elementDefs.get(i);
                elementQNames.add(trimDef.getQualifiedName());
                ++i;
            }
        }
    }

    public static int getMinimalElementDefPathStartIndex(GrammarResolver resolver, List defPath, int offset) {
        int defPathSize = defPath.size();
        int i = defPathSize - 1;
        while (i >= offset) {
            ElementDef currentDef = (ElementDef)defPath.get(i);
            if (currentDef == null) {
                return i;
            }
            if (GrammarUtils.isElementDefGloballyDefined(resolver, currentDef)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static ElementDef _getLastElementDef(GrammarResolver resolver, XmlKey key) {
        List elementQNamePath = key.getElementQNamePath();
        ElementDef lastElementDef = null;
        if (elementQNamePath != null) {
            for (QualifiedName qName : elementQNamePath) {
                String namespace = qName.getNamespace();
                String localName = qName.getName();
                if (lastElementDef == null) {
                    Grammar currGrammar = resolver.getGrammarForNamespace(namespace);
                    if (currGrammar != null) {
                        lastElementDef = currGrammar.getElementDefByName(localName);
                    }
                } else {
                    lastElementDef = lastElementDef.getElementDefByName(namespace, localName);
                }
                if (lastElementDef != null) {
                    String attrNS = qName.getAttributeNamespace();
                    String attrName = qName.getAttributeName();
                    String attrValue = qName.getAttributeValue();
                    if (attrName != null && attrValue != null) {
                        QualifiedName attrQName = QualifiedName.getQualifiedName(attrNS, attrName);
                        lastElementDef = resolver.getFixedAttributeElementDef(lastElementDef, attrQName, attrValue);
                    }
                }
                if (lastElementDef == null) break;
            }
        }
        return lastElementDef;
    }
}

