/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.MetadataComponent;
import oracle.bali.xml.metadata.standalone.MetadataGroup;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import oracle.bali.xml.metadata.util.PseudoXmlKeyUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementMetadata
implements MetadataComponent {
    private static final String _INCLUDE_GROUP_NAME = "includeGroup";
    private static final String _FIXED_ATTRIBUTE_NAME = "fixedAttribute";
    private static final String _PSEUDO_XML_KEYS_NAME = "pseudoXmlKeys";
    private static final String _ELEMENT_NAME_ATTR = "elementName";
    private static final String _NAME_ATTR = "name";
    private String _targetNamespace;
    private String _elementName;
    private GrammarMetadata _grammarMetadata;
    private HashMap _metadataMap;
    private HashMap _elementMetadataMap;
    private HashMap _attributeMetadataMap;
    private Map _fixedAttributeMetadata;
    private LinkedHashSet<String> _includedGroupNames;
    private PseudoXmlKeyUtil _pxku;
    public static final String ELEMENT_METADATA_NAME = "elementMetadata";

    public ElementMetadata(String targetNamespace, Node elementMetadataNode, GrammarMetadata grammarMetadata) {
        this.$init$();
        this._targetNamespace = targetNamespace;
        this._grammarMetadata = grammarMetadata;
        this._metadataMap = new HashMap(grammarMetadata.getSharedElementMetadata());
        this._buildMetadataMaps(elementMetadataNode);
    }

    public ElementMetadata getElementMetadataByName(String elementName) {
        ElementMetadata elementMetadata = (ElementMetadata)this._elementMetadataMap.get(elementName);
        if (elementMetadata == null) {
            for (MetadataGroup group : this.getMetadataGroups()) {
                elementMetadata = group.getElementMetadataByName(elementName);
                if (elementMetadata != null) break;
            }
        }
        return elementMetadata;
    }

    public AttributeMetadata getAttributeMetadataByName(String attributeName) {
        AttributeMetadata attributeMetadata = (AttributeMetadata)this._attributeMetadataMap.get(attributeName);
        if (attributeMetadata == null) {
            for (MetadataGroup group : this.getMetadataGroups()) {
                attributeMetadata = group.getAttributeMetadataByName(attributeName);
                if (attributeMetadata != null) break;
            }
        }
        return attributeMetadata;
    }

    public Map getElementMetadataMap() {
        return this._elementMetadataMap;
    }

    public Map getAttributeMetadataMap() {
        return this._attributeMetadataMap;
    }

    public List<MetadataGroup> getMetadataGroups() {
        LinkedList<MetadataGroup> metadataGroups = new LinkedList<MetadataGroup>();
        for (String name : this._includedGroupNames) {
            MetadataGroup group = this._grammarMetadata.getMetadataGroupByName(name);
            if (group == null) continue;
            metadataGroups.add(group);
        }
        return metadataGroups;
    }

    @Override
    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    @Override
    public Map getMetadataMap() {
        return this._metadataMap;
    }

    public String getElementName() {
        return this._elementName;
    }

    public Map getFixedAttributeMetadataMap(String attrNamespace, String attrName, String attrValue) {
        QualifiedName attrQName;
        Map valueMap;
        Map metadataMap = Collections.EMPTY_MAP;
        if (attrName != null && attrValue != null && (valueMap = (Map)this._fixedAttributeMetadata.get(attrQName = QualifiedName.getQualifiedName(attrNamespace, attrName))) != null && (metadataMap = (Map)valueMap.get(attrValue)) == null) {
            metadataMap = Collections.EMPTY_MAP;
        }
        return metadataMap;
    }

    public Collection<String> getPseudoXmlKeyIdentifiers() {
        Collection<String> identifers = Collections.emptyList();
        if (this._pxku != null) {
            identifers = this._pxku.getPseudoXmlKeyIdentifiers();
        }
        return identifers;
    }

    public Map getPseudoXmlKeyMetadataMap(String identifier) {
        Map metadataMap = Collections.EMPTY_MAP;
        if (this._pxku != null) {
            metadataMap = this._pxku.getMetadataMap(identifier);
        }
        return metadataMap;
    }

    private void _buildMetadataMaps(Node elementMetadataNode) {
        this._elementName = ((Element)elementMetadataNode).getAttribute(_ELEMENT_NAME_ATTR);
        Node currNode = elementMetadataNode.getFirstChild();
        while (currNode != null) {
            if (currNode.getNodeType() == 1) {
                String localName = currNode.getLocalName();
                if (localName.equals(ELEMENT_METADATA_NAME)) {
                    OracleStandaloneMetadataFactory.addElementMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._elementMetadataMap);
                } else if (localName.equals("attributeMetadata")) {
                    OracleStandaloneMetadataFactory.addAttributeMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._attributeMetadataMap);
                } else if (localName.equals(_INCLUDE_GROUP_NAME)) {
                    this._addIncludedGroupToList(currNode);
                } else if (localName.equals(_FIXED_ATTRIBUTE_NAME)) {
                    this._fixedAttributeMetadata = MetadataProviderUtils.processFixedAttributeElement((Element)currNode);
                } else if (localName.equals(_PSEUDO_XML_KEYS_NAME)) {
                    this._pxku = new PseudoXmlKeyUtil((Element)currNode);
                } else {
                    MetadataProviderUtils.addMetadataToMap(this._metadataMap, (Element)currNode);
                }
            }
            currNode = currNode.getNextSibling();
        }
    }

    private void _addIncludedGroupToList(Node includeGroupNode) {
        String groupName = ((Element)includeGroupNode).getAttribute(_NAME_ATTR);
        this._includedGroupNames.add(groupName);
    }

    private void $init$() {
        this._elementMetadataMap = new HashMap();
        this._attributeMetadataMap = new HashMap();
        this._fixedAttributeMetadata = Collections.EMPTY_MAP;
        this._includedGroupNames = new LinkedHashSet(2);
    }
}

