/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.ElementMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataGroup {
    private static final String _NAME_ATTR = "name";
    private String _targetNamespace;
    private String _groupName;
    private GrammarMetadata _grammarMetadata;
    private Map _attributeMetadataMap;
    private Map _elementMetadataMap;

    public MetadataGroup(String targetNamespace, Node defineGroupNode, GrammarMetadata grammarMetadata) {
        this.$init$();
        this._targetNamespace = targetNamespace;
        this._grammarMetadata = grammarMetadata;
        this._buildMetadataMaps(defineGroupNode);
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getName() {
        return this._groupName;
    }

    public ElementMetadata getElementMetadataByName(String elementName) {
        return (ElementMetadata)this._elementMetadataMap.get(elementName);
    }

    public AttributeMetadata getAttributeMetadataByName(String attributeName) {
        return (AttributeMetadata)this._attributeMetadataMap.get(attributeName);
    }

    public Map getElementMetadataMap() {
        return this._elementMetadataMap;
    }

    public Map getAttributeMetadataMap() {
        return this._attributeMetadataMap;
    }

    private void _buildMetadataMaps(Node defineGroupNode) {
        this._groupName = ((Element)defineGroupNode).getAttribute(_NAME_ATTR);
        Node currNode = defineGroupNode.getFirstChild();
        while (currNode != null) {
            if (currNode.getNodeType() == 1) {
                String localName = currNode.getLocalName();
                if (localName.equals("elementMetadata")) {
                    OracleStandaloneMetadataFactory.addElementMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._elementMetadataMap);
                } else if (localName.equals("attributeMetadata")) {
                    OracleStandaloneMetadataFactory.addAttributeMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._attributeMetadataMap);
                }
            }
            currNode = currNode.getNextSibling();
        }
    }

    private void $init$() {
        this._attributeMetadataMap = new HashMap();
        this._elementMetadataMap = new HashMap();
    }
}

