/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataProvider;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneUtils;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneMetadataProvider
extends XmlMetadataProvider {
    private final Map<XmlKey, Map> _layerMetadataMap;
    private final Map<XmlKey, Collection<XmlKey>> _layerPseudoXmlKeyMap;
    private final StandaloneMetadataFileRegistry _registry;

    public static MetadataProvider create(URL ... urls) throws StandaloneMetadataFileException {
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            StandaloneMetadataFile f = OracleStandaloneMetadataFactory.createStandaloneMetadataFile(url);
            registry.addStandaloneMetadataFile(f);
            ++n;
        }
        return new StandaloneMetadataProvider(registry);
    }

    public StandaloneMetadataProvider(StandaloneMetadataFileRegistry registry) {
        this(null, registry);
    }

    public StandaloneMetadataProvider(MetadataProvider base, StandaloneMetadataFileRegistry registry) {
        super(base);
        this.$init$();
        this._registry = registry;
    }

    @Override
    protected Map getLayerMetadata(Object key) {
        if (!(key instanceof XmlKey)) {
            return null;
        }
        XmlKey xmlKey = (XmlKey)key;
        Map layerMetadata = this._layerMetadataMap.get(xmlKey);
        if (layerMetadata != null) {
            return layerMetadata;
        }
        layerMetadata = StandaloneUtils.getMetadataMap(this._registry, xmlKey);
        this._layerMetadataMap.put(xmlKey, layerMetadata);
        return layerMetadata;
    }

    @Override
    protected Object getLayerMetadataItem(Object key, Object itemKey) {
        Object metadataItem = null;
        Map metadata = this.getLayerMetadata(key);
        if (metadata != null) {
            metadataItem = metadata.get(itemKey);
        }
        return metadataItem;
    }

    @Override
    protected Object getLayerFunction(String prefix, String name) {
        StandaloneMetadataFile[] standaloneMetadataFileArray = this._registry.getStandaloneMetadataFiles();
        int n = 0;
        while (n < standaloneMetadataFileArray.length) {
            StandaloneMetadataFile file = standaloneMetadataFileArray[n];
            GrammarMetadata gmd = file.getGrammarMetadata();
            Object function = gmd.getFunction(prefix, name);
            if (function != null) {
                return function;
            }
            ++n;
        }
        return null;
    }

    @Override
    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        StandaloneMetadataFile[] standaloneMetadataFileArray = this._registry.getStandaloneMetadataFiles();
        int n = 0;
        while (n < standaloneMetadataFileArray.length) {
            StandaloneMetadataFile file = standaloneMetadataFileArray[n];
            GrammarMetadata gmd = file.getGrammarMetadata();
            List<StructuredMetadataBean> perGrammarList = gmd.getGlobalMetadata(globalItemName);
            if (perGrammarList != null) {
                combinedList.addAll(perGrammarList);
            }
            ++n;
        }
        if (combinedList.isEmpty()) {
            return Collections.emptyList();
        }
        return combinedList;
    }

    @Override
    protected Collection getLayerPseudoXmlKeys(Object baseKey) {
        if (!(baseKey instanceof XmlKey)) {
            return Collections.emptyList();
        }
        XmlKey baseXmlKey = (XmlKey)baseKey;
        if (baseXmlKey.getNodeType() != 1) {
            return Collections.EMPTY_LIST;
        }
        Collection<XmlKey> pseudoKeys = this._layerPseudoXmlKeyMap.get(baseXmlKey);
        if (pseudoKeys == null) {
            pseudoKeys = StandaloneUtils.getPseudoXmlKeys(baseXmlKey, this._registry);
            this._layerPseudoXmlKeyMap.put(baseXmlKey, pseudoKeys);
        }
        return pseudoKeys;
    }

    private void $init$() {
        this._layerMetadataMap = new HashMap<XmlKey, Map>();
        this._layerPseudoXmlKeyMap = new HashMap<XmlKey, Collection<XmlKey>>();
    }
}

