/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.structured;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.structured.MutableStructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StructuredMetadataUtils {
    public static final StructuredMetadataBean createStructuredMetadata(Element element) {
        String textContent;
        MutableStructuredMetadataBean bean = new MutableStructuredMetadataBean(element.getNamespaceURI(), DomUtils.getLocalName(element));
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null) {
            int numAttrs = attrMap.getLength();
            int i = 0;
            while (i < numAttrs) {
                String value;
                Attr attr = (Attr)attrMap.item(i);
                if (attr != null && (value = attr.getValue()) != null) {
                    bean.addProperty(attr.getNamespaceURI(), DomUtils.getLocalName(attr), value.trim());
                }
                ++i;
            }
        }
        if ((textContent = element.getTextContent()) != null) {
            bean.setValue(textContent.trim());
        }
        Node currentChild = element.getFirstChild();
        while (currentChild != null) {
            if (DomUtils.isElement(currentChild)) {
                Element childElement = (Element)currentChild;
                bean.addChild(StructuredMetadataUtils.createStructuredMetadata(childElement));
            }
            currentChild = currentChild.getNextSibling();
        }
        return bean;
    }
}

