/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.tools;

import java.util.Collection;
import java.util.Iterator;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;

public class MetadataFileGenerator {
    public void generate(StringBuffer buffer, Grammar g, String startingRoot) {
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<grammarMetadata xmlns=\"http://xmlns.oracle.com/bali/xml/metadata\"\n");
        buffer.append("                 xmlns:md=\"http://xmlns.oracle.com/bali/xml/metadata\"\n");
        buffer.append("                 xmlns:mmd=\"http://xmlns.oracle.com/bali/xml/metadata/model\"\n");
        if (g.getTargetNamespace() != null) {
            buffer.append("                 namespace=\"");
            buffer.append(g.getTargetNamespace());
            buffer.append("\">\n");
        } else {
            buffer.append(">\n");
        }
        String indent = "  ";
        this.generateGrammarMetadata(buffer, g, indent);
        this.generateSharedMetadata(buffer, g, indent);
        if (startingRoot != null) {
            ElementDef ed = g.getElementDefByName(startingRoot);
            if (ed == null) {
                System.err.println("Starting root " + startingRoot + " not found");
            } else {
                this._generateElementMetadataTag(buffer, g, ed, indent);
            }
        } else {
            for (ElementDef ed : g.getElementDefs()) {
                this._generateElementMetadataTag(buffer, g, ed, indent);
            }
        }
        buffer.append("</grammarMetadata>\n");
    }

    protected void generateGrammarMetadata(StringBuffer buffer, Grammar g, String indent) {
    }

    protected void generateSharedMetadata(StringBuffer buffer, Grammar g, String indent) {
    }

    protected boolean shouldGenerateElementMetadata(Grammar g, ElementDef ed) {
        return true;
    }

    protected boolean shouldGenerateAttributeMetadata(Grammar g, ElementDef ed, AttributeDef ad) {
        return true;
    }

    protected void generateElementMetadata(StringBuffer buffer, Grammar g, ElementDef ed, String indent) {
        buffer.append("\n");
    }

    protected void generateAttributeMetadata(StringBuffer buffer, Grammar g, ElementDef ed, AttributeDef ad, String indent) {
        buffer.append("\n");
    }

    private void _generateElementMetadataTag(StringBuffer buffer, Grammar g, ElementDef ed, String indent) {
        if (!this._shouldGenerateElementMetadata(g, ed)) {
            return;
        }
        buffer.append(indent);
        buffer.append("<elementMetadata elementName=\"");
        buffer.append(ed.getName());
        buffer.append("\">\n");
        String nextIndent = indent + "  ";
        this.generateElementMetadata(buffer, g, ed, nextIndent);
        this._generateAttributeMetadata(buffer, g, ed, nextIndent);
        buffer.append("\n");
        if (this._generateChildElementMetadata(buffer, g, ed, nextIndent)) {
            buffer.append("\n");
        }
        buffer.append(indent);
        buffer.append("</elementMetadata>\n");
    }

    private void _generateAttributeMetadataTag(StringBuffer buffer, Grammar g, ElementDef ed, AttributeDef ad, String indent) {
        if (!this.shouldGenerateAttributeMetadata(g, ed, ad)) {
            return;
        }
        buffer.append(indent);
        buffer.append("<attributeMetadata attributeName=\"");
        buffer.append(ad.getName());
        buffer.append("\">\n");
        String nextIndent = indent + "  ";
        this.generateAttributeMetadata(buffer, g, ed, ad, nextIndent);
        buffer.append(indent);
        buffer.append("</attributeMetadata>\n");
    }

    private boolean _shouldGenerateElementMetadata(Grammar g, ElementDef ed) {
        return !ed.isReference() && this.shouldGenerateElementMetadata(g, ed);
    }

    private boolean _generateAttributeMetadata(StringBuffer buffer, Grammar g, ElementDef ed, String indent) {
        Collection attributes = ed.getAttributeDefs();
        if (attributes == null) {
            return false;
        }
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            AttributeDef ad = (AttributeDef)i.next();
            this._generateAttributeMetadataTag(buffer, g, ed, ad, indent);
            if (!i.hasNext()) continue;
            buffer.append("\n");
        }
        return attributes.size() > 0;
    }

    private boolean _generateChildElementMetadata(StringBuffer buffer, Grammar g, ElementDef ed, String indent) {
        Collection elements = ed.getElementDefs();
        if (elements == null) {
            return false;
        }
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ElementDef child = (ElementDef)i.next();
            this._generateElementMetadataTag(buffer, g, child, indent);
            if (!i.hasNext()) continue;
            buffer.append("\n");
        }
        return elements.size() > 0;
    }
}

