/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.tools;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.MetadataValueConverter;
import oracle.bali.xml.metadata.XmlMetadataTypeConverters;

public class MetadataMethodsGenerator {
    private static final String _XML_MD_SCHEMA_LOCATION = "oracle/bali/xml/metadata/XmlMetadata.xsd";
    private static final String _XML_MD_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";

    public static void main(String[] args) {
        try {
            if (args.length == 5) {
                MetadataMethodsGenerator.go(args[0], args[1], args[2], args[3], args[4]);
            } else if (args.length > 0) {
                System.out.println("Usage is either no args or all five!");
            } else {
                MetadataMethodsGenerator.go(_XML_MD_SCHEMA_LOCATION, _XML_MD_NAMESPACE, "D:/XmlMetadataMethods.java", "oracle.bali.xml.metadata", "XmlMetadataMethods");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void go(String mdSchemaLocation, String mdNamespace, String outputPath, String packageStr, String classStr) throws Exception {
        System.out.println("Metadata methods generator running for: " + mdSchemaLocation);
        XmlMetadataTypeConverters.registerConverters(Thread.currentThread().getContextClassLoader(), Locale.getDefault());
        if (!_XML_MD_SCHEMA_LOCATION.equals(mdSchemaLocation)) {
            MetadataMethodsGenerator.registerMdSchema(_XML_MD_SCHEMA_LOCATION);
        }
        MetadataMethodsGenerator.registerMdSchema(mdSchemaLocation);
        GrammarProvider gp = MetadataSchemaRegistry.getInstance().getMetadataGrammars();
        StringBuffer publicBuffer = new StringBuffer();
        publicBuffer.append("//WARNING: this file is auto-generated.  Do NOT modify.\n");
        publicBuffer.append("//Copyright Oracle Corporation 2004.\n\n");
        publicBuffer.append("package " + packageStr + ";\n\n");
        publicBuffer.append("import oracle.bali.xml.grammar.QualifiedName;\n");
        publicBuffer.append("import oracle.bali.xml.metadata.MetadataEvaluator;\n");
        publicBuffer.append("import org.w3c.dom.Node;\n\n");
        publicBuffer.append("public class " + classStr + "\n");
        publicBuffer.append("{\n");
        Grammar mdGrammar = gp.getGrammarForNamespace(mdNamespace);
        MetadataValueConverter converter = new MetadataValueConverter();
        Collection mdItems = mdGrammar.getElementDefs();
        for (ElementDef itemDef : mdItems) {
            QualifiedName itemKey = itemDef.getQualifiedName();
            Class expectedType = converter.getExpectedMetadataType(itemKey);
            if (expectedType == null) continue;
            publicBuffer.append("  public static ");
            String expectedTypeString = expectedType.getName();
            if (expectedType.isArray()) {
                expectedTypeString = expectedType.getComponentType().getName() + "[]";
            }
            if (expectedTypeString.startsWith("java.lang.")) {
                expectedTypeString = expectedTypeString.substring("java.lang.".length());
            }
            publicBuffer.append(expectedTypeString);
            String methodType = "";
            methodType = expectedType == Boolean.class ? "is" : "get";
            publicBuffer.append(" ");
            publicBuffer.append(methodType);
            String itemName = itemKey.getName();
            itemName = Character.toUpperCase(itemName.charAt(0)) + itemName.substring(1);
            publicBuffer.append(itemName);
            publicBuffer.append("(MetadataEvaluator evaluator, Object key, Node node)");
            publicBuffer.append("\n  {\n");
            publicBuffer.append("    Object value = evaluator.getMetadataItem(\n");
            publicBuffer.append("      key, \n");
            publicBuffer.append("      QualifiedName.getQualifiedName(\"" + mdNamespace + "\", //NOTRANS\n");
            publicBuffer.append("                                     \"" + itemKey.getName() + "\"),  //NOTRANS\n");
            publicBuffer.append("      node);");
            publicBuffer.append("\n");
            publicBuffer.append("    try {\n");
            publicBuffer.append("      return (" + expectedTypeString + ") value;\n");
            publicBuffer.append("    }\n");
            publicBuffer.append("    catch(Exception e) {\n");
            publicBuffer.append("      System.err.println(\"Error getting metadata for key \" + key + \", node \" + node + \", itemKey " + itemKey + "\");  //NOTRANS \n");
            publicBuffer.append("      System.err.println(\"Value from evaluator is \" + value);  //NOTRANS \n");
            publicBuffer.append("      e.printStackTrace();\n");
            publicBuffer.append("      return null;");
            publicBuffer.append("\n    }");
            publicBuffer.append("\n  }");
            publicBuffer.append("\n\n");
        }
        publicBuffer.append("}");
        try {
            FileWriter w = new FileWriter(outputPath);
            w.write(publicBuffer.toString());
            w.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void registerMdSchema(String mdSchemaLocation) {
        URL xmlMdSchemaURL = ClassLoaderUtils.getResource((String)mdSchemaLocation);
        if (xmlMdSchemaURL == null) {
            System.err.println("ERROR: Unable to find metadata schema: " + mdSchemaLocation);
            System.exit(1);
        }
        MetadataSchemaRegistry.getInstance().registerSchema(xmlMdSchemaURL);
    }
}

