/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.tools;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.metadata.tools.MetadataFileGenerator;

public class StandaloneMetadataFileGenerator {
    public static final void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage:  StandaloneMetadataFileGenerator schemaFile outputFile namespace [rootElement]");
            System.exit(1);
        }
        String schemaFile = args[0];
        String outputFileName = args[1];
        String ns = args[2];
        if ("null".equals(ns)) {
            ns = null;
        }
        String root = args.length >= 4 ? args[3] : null;
        StandaloneMetadataFileGenerator smfg = new StandaloneMetadataFileGenerator();
        smfg.run(schemaFile, outputFileName, ns, root);
    }

    public void run(String schemaFile, String outputFileName, String namespace) {
        this.run(schemaFile, outputFileName, namespace, null);
    }

    public void run(String schemaFile, String outputFileName, String ns, String root) {
        URL schemaURL = null;
        try {
            schemaURL = new URL(schemaFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (schemaURL == null) {
            try {
                File aFile = new File(schemaFile);
                schemaFile = aFile.getCanonicalPath();
                schemaFile = schemaFile.charAt(0) == '/' ? "file:" + schemaFile : "file:/" + schemaFile;
                schemaURL = new URL(schemaFile);
            }
            catch (Exception e) {
                System.err.println("Could not find file " + schemaFile);
                System.exit(1);
            }
        }
        SchemaGrammarProvider grammarProvider = new SchemaGrammarProvider();
        Grammar grammar = null;
        try {
            Set grammars = grammarProvider.addSchema(schemaURL);
            for (Grammar g : grammars) {
                String grammarNS = g.getTargetNamespace();
                if ((grammarNS == null || !grammarNS.equals(ns)) && (grammarNS != null || ns != null)) continue;
                grammar = g;
                break;
            }
        }
        catch (GrammarException ex) {
            System.err.println("grammar exception " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        if (grammar == null) {
            System.err.println("Could not find namespace " + ns);
            System.exit(1);
        }
        FileWriter outputWriter = null;
        try {
            outputWriter = new FileWriter(outputFileName);
        }
        catch (Exception e) {
            System.err.println("Could not open output file " + outputFileName);
            System.exit(1);
        }
        StringBuffer sb = new StringBuffer();
        MetadataFileGenerator generator = this.createGenerator();
        generator.generate(sb, grammar, root);
        try {
            outputWriter.write(sb.toString());
            outputWriter.flush();
            outputWriter.close();
        }
        catch (Exception e) {
            System.err.println("exception writing to output file" + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected MetadataFileGenerator createGenerator() {
        return new MetadataFileGenerator();
    }
}

