/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.util;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunctionRegistry;
import oracle.bali.xml.metadata.XmlKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataProviderUtils {
    public static final String METADATA_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";
    public static final QualifiedName FUNCTIONS_QNAME = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata", "functions");
    public static final QualifiedName GLOBAL_METADATA_QNAME = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata", "globalMetadata");
    public static final QualifiedName PREFERRED_PREFIX_QNAME = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata", "preferredPrefix");
    private static final String _NAME_ATTR = "name";
    private static final String _NAMESPACE_ATTR = "namespace";
    private static final String _VALUE_ATTR = "value";
    private static final String _FIXED_VALUE = "fixedValue";

    private MetadataProviderUtils() {
    }

    public static void addMetadataToMap(Map metadataMap, Element metadataItem) {
        String itemText;
        QualifiedName itemName = QualifiedName.getQualifiedName(metadataItem.getNamespaceURI(), metadataItem.getLocalName());
        StringBuffer buffer = new StringBuffer();
        Node itemChild = metadataItem.getFirstChild();
        while (itemChild != null) {
            String childValue;
            short childType = itemChild.getNodeType();
            if ((childType == 3 || childType == 4) && (childValue = itemChild.getNodeValue()) != null) {
                buffer.append(childValue);
            }
            itemChild = itemChild.getNextSibling();
        }
        if (buffer.length() > 0 && (itemText = buffer.toString().trim()).length() > 0) {
            metadataMap.put(itemName, itemText.intern());
        }
    }

    public static Map processFixedAttributeElement(Element fixedAttrElement) {
        HashMap outerMap = new HashMap(5);
        String attrNS = fixedAttrElement.getAttributeNS(null, _NAMESPACE_ATTR);
        String attrName = fixedAttrElement.getAttributeNS(null, _NAME_ATTR);
        if ("".equals(attrNS)) {
            attrNS = null;
        }
        QualifiedName attrQName = QualifiedName.getQualifiedName(attrNS, attrName);
        HashMap innerMap = new HashMap();
        outerMap.put(attrQName, innerMap);
        Node currentChild = fixedAttrElement.getFirstChild();
        while (currentChild != null) {
            Element fixedValue;
            String value;
            if (currentChild.getNodeType() == 1 && METADATA_NAMESPACE.equals(currentChild.getNamespaceURI()) && _FIXED_VALUE.equals(DomUtils.getLocalName(currentChild)) && (value = (fixedValue = (Element)currentChild).getAttributeNS(null, _VALUE_ATTR)) != null) {
                HashMap metadataItemMap = new HashMap();
                Node metadataItem = currentChild.getFirstChild();
                while (metadataItem != null) {
                    if (metadataItem.getNodeType() == 1) {
                        MetadataProviderUtils.addMetadataToMap(metadataItemMap, (Element)metadataItem);
                    }
                    metadataItem = metadataItem.getNextSibling();
                }
                innerMap.put(value, metadataItemMap);
            }
            currentChild = currentChild.getNextSibling();
        }
        return outerMap;
    }

    public static void processFunctionsElement(Element functionsElement, MetadataFunctionRegistry registry, String preferredPrefix, boolean add) throws MetadataException {
        String prefix = preferredPrefix;
        String prefixAttr = functionsElement.getAttributeNS(null, "prefix");
        if (prefixAttr != null && !"".equals(prefixAttr)) {
            prefix = prefixAttr;
        }
        if (prefix == null || "".equals(prefix)) {
            throw new MetadataException("no prefix passed to process functions for " + functionsElement);
        }
        Node child = functionsElement.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && METADATA_NAMESPACE.equals(child.getNamespaceURI())) {
                Element function = (Element)child;
                String name = function.getAttribute(_NAME_ATTR);
                String className = function.getAttribute("class");
                String qname = prefix + ":" + name;
                if (add) {
                    String funcLocalName = function.getLocalName();
                    if ("method".equals(funcLocalName)) {
                        String nameAndSig = function.getAttribute("nameAndSig");
                        String isMacroString = function.getAttribute("isMacro");
                        boolean isMacro = false;
                        if (isMacroString != null && !"".equals(isMacroString)) {
                            isMacro = Boolean.parseBoolean(isMacroString);
                        }
                        registry.registerMethod(qname, className, nameAndSig, isMacro);
                    } else if ("instance".equals(funcLocalName)) {
                        registry.registerInstanceFunction(qname, className);
                    }
                } else {
                    registry.unregisterFunction(qname);
                }
            }
            child = child.getNextSibling();
        }
    }

    public static String convertItemName(String facesItemName) {
        StringBuffer convertedName = new StringBuffer(facesItemName);
        int dashIndex = convertedName.indexOf("-");
        while (dashIndex != -1) {
            convertedName = convertedName.delete(dashIndex, dashIndex + 1);
            convertedName.setCharAt(dashIndex, Character.toUpperCase(convertedName.charAt(dashIndex)));
            dashIndex = convertedName.indexOf("-");
        }
        return convertedName.toString();
    }

    public static Object convertToGlobalKey(Object key) {
        Object convertedKey = key;
        if (key instanceof XmlKey) {
            QualifiedName lastElementQName;
            XmlKey xmlKey = (XmlKey)key;
            if (xmlKey.getNodeType() == 1) {
                QualifiedName lastElementQName2 = xmlKey.getElementQName();
                if (lastElementQName2 != null) {
                    convertedKey = ImmutableXmlKey.createElementKey(lastElementQName2);
                }
            } else if (xmlKey.getNodeType() == 2 && (lastElementQName = xmlKey.getElementQName()) != null) {
                convertedKey = ImmutableXmlKey.createAttributeKey(lastElementQName, xmlKey.getAttributeQName());
            }
        }
        return convertedKey;
    }
}

