/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlReader
implements XMLReader {
    private static final DefaultHandler _DEFAULT_HANDLER = new DefaultHandler();
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;

    protected AbstractXmlReader() {
        this.$init$();
    }

    public abstract void parse(InputSource var1) throws IOException, SAXException;

    public abstract boolean getFeature(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract void setFeature(String var1, boolean var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract Object getProperty(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver == null ? _DEFAULT_HANDLER : resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    private void $init$() {
        this._entityResolver = _DEFAULT_HANDLER;
        this._dtdHandler = _DEFAULT_HANDLER;
        this._contentHandler = _DEFAULT_HANDLER;
        this._errorHandler = _DEFAULT_HANDLER;
    }
}

