/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import oracle.bali.xml.sax.LexicalHandlerWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class StringCaptureXmlFilter
extends XMLFilterImpl {
    private static final String _INDENT_CHARS = "  ";
    private String _lastOpenedTag;
    private int _indentLevel;
    private boolean _inCdataSection;
    private boolean _preserveCdataSections;
    private final boolean _addXmlDecl;
    private final StringBuffer _buffer;

    public StringCaptureXmlFilter() {
        this(null);
    }

    public StringCaptureXmlFilter(XMLReader parent) {
        this(parent, true);
    }

    public StringCaptureXmlFilter(XMLReader parent, boolean addXmlDecl) {
        super(parent);
        this.$init$();
        this._addXmlDecl = addXmlDecl;
        LexicalHandler baseLex = null;
        try {
            Object b = this.getProperty("http://xml.org/sax/properties/lexical-handler");
            if (b instanceof LexicalHandler) {
                baseLex = (LexicalHandler)b;
            }
        }
        catch (SAXException e) {
            // empty catch block
        }
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", new LexHandler(baseLex));
        }
        catch (SAXException e) {
            // empty catch block
        }
    }

    public void setPreserveCdataSections(boolean val) {
        this._preserveCdataSections = val;
    }

    public String getXMLSource() {
        return this._buffer.toString();
    }

    public void startDocument() throws SAXException {
        this._buffer.delete(0, this._buffer.length());
        if (this._addXmlDecl) {
            this._buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this._closeStartTagIfNeeded();
        this._newline();
        super.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this._closeStartTagIfNeeded();
        this._newlineBeforeCurrent();
        this._buffer.append('<');
        this._lastOpenedTag = this._getName(qName, localName);
        this._buffer.append(this._lastOpenedTag);
        int numAttrs = attrs.getLength();
        int i = 0;
        while (i < numAttrs) {
            String value;
            this._buffer.append(' ');
            String name = attrs.getQName(i);
            if (name == null) {
                name = attrs.getLocalName(i);
            }
            if ((value = attrs.getValue(i)) == null) {
                value = "";
            }
            this._buffer.append(name);
            this._buffer.append("=\"");
            this._buffer.append(this._escape(value));
            this._buffer.append("\"");
            ++i;
        }
        ++this._indentLevel;
        super.startElement(uri, localName, qName, attrs);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this._indentLevel;
        String name = this._getName(qName, localName);
        if (this._lastOpenedTag != null && !name.equals(this._lastOpenedTag)) {
            throw new IllegalStateException("last opened tag != null but not right! last opened=" + this._lastOpenedTag + " end now=" + name);
        }
        if (!name.equals(this._lastOpenedTag)) {
            this._newlineInsideCurrent();
            this._buffer.append("</");
            this._buffer.append(name);
            this._buffer.append('>');
        } else {
            this._buffer.append(" />");
            this._lastOpenedTag = null;
        }
        super.endElement(uri, localName, qName);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this._closeStartTagIfNeeded();
        this._newlineBeforeCurrent();
        this._buffer.append("<?");
        this._buffer.append(target);
        this._buffer.append(' ');
        this._buffer.append(data);
        this._buffer.append("?>");
        super.processingInstruction(target, data);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._closeStartTagIfNeeded();
        if (this._inCdataSection) {
            this._buffer.append(ch, start, length);
        } else {
            String chars = new String(ch, start, length);
            this._buffer.append(this._escape(chars));
        }
        super.characters(ch, start, length);
    }

    protected StringBuffer getBuffer() {
        return this._buffer;
    }

    protected boolean putWhitespaceBeforeCurrent() {
        return true;
    }

    protected boolean putWhitespaceInsideCurrent() {
        return true;
    }

    private void _closeStartTagIfNeeded() {
        if (this._lastOpenedTag != null) {
            this._buffer.append('>');
            this._lastOpenedTag = null;
        }
    }

    private String _getName(String qName, String localName) {
        return qName != null ? qName : localName;
    }

    private void _newlineBeforeCurrent() {
        if (this.putWhitespaceBeforeCurrent()) {
            this._newline();
        }
    }

    private void _newlineInsideCurrent() {
        if (this.putWhitespaceInsideCurrent()) {
            this._newline();
        }
    }

    private void _newline() {
        if (this._buffer.length() == 0) {
            return;
        }
        this._buffer.append('\n');
        int i = 0;
        while (i < this._indentLevel) {
            this._buffer.append(_INDENT_CHARS);
            ++i;
        }
    }

    private String _escape(String in) {
        String out = in.replaceAll("&", "&amp;");
        out = out.replaceAll("<", "&lt;");
        out = out.replaceAll(">", "&gt;");
        out = out.replaceAll("\"", "&quot;");
        return out;
    }

    private void $init$() {
        this._lastOpenedTag = null;
        this._indentLevel = 0;
        this._inCdataSection = false;
        this._preserveCdataSections = true;
        this._buffer = new StringBuffer();
    }

    static void mav$_closeStartTagIfNeeded(StringCaptureXmlFilter stringCaptureXmlFilter) {
        stringCaptureXmlFilter._closeStartTagIfNeeded();
    }

    static void mav$_newlineBeforeCurrent(StringCaptureXmlFilter stringCaptureXmlFilter) {
        stringCaptureXmlFilter._newlineBeforeCurrent();
    }

    static StringBuffer ra$_buffer(StringCaptureXmlFilter stringCaptureXmlFilter) {
        return stringCaptureXmlFilter._buffer;
    }

    static boolean ra$_preserveCdataSections(StringCaptureXmlFilter stringCaptureXmlFilter) {
        return stringCaptureXmlFilter._preserveCdataSections;
    }

    static void wa$_inCdataSection(StringCaptureXmlFilter stringCaptureXmlFilter, boolean bl) {
        stringCaptureXmlFilter._inCdataSection = bl;
    }

    private class LexHandler
    extends LexicalHandlerWrapper {
        public LexHandler(LexicalHandler parent) {
            super(parent);
        }

        public void startCDATA() throws SAXException {
            super.startCDATA();
            if (StringCaptureXmlFilter.ra$_preserveCdataSections(StringCaptureXmlFilter.this)) {
                StringCaptureXmlFilter.mav$_closeStartTagIfNeeded(StringCaptureXmlFilter.this);
                StringCaptureXmlFilter.mav$_newlineBeforeCurrent(StringCaptureXmlFilter.this);
                StringCaptureXmlFilter.ra$_buffer(StringCaptureXmlFilter.this).append("<![CDATA[");
                StringCaptureXmlFilter.wa$_inCdataSection(StringCaptureXmlFilter.this, true);
            }
        }

        public void endCDATA() throws SAXException {
            if (StringCaptureXmlFilter.ra$_preserveCdataSections(StringCaptureXmlFilter.this)) {
                StringCaptureXmlFilter.ra$_buffer(StringCaptureXmlFilter.this).append("]]>");
                StringCaptureXmlFilter.wa$_inCdataSection(StringCaptureXmlFilter.this, false);
            }
            super.endCDATA();
        }

        public void comment(char[] chars, int start, int length) {
            StringCaptureXmlFilter.mav$_closeStartTagIfNeeded(StringCaptureXmlFilter.this);
            StringCaptureXmlFilter.mav$_newlineBeforeCurrent(StringCaptureXmlFilter.this);
            StringCaptureXmlFilter.ra$_buffer(StringCaptureXmlFilter.this).append("<!--");
            StringCaptureXmlFilter.ra$_buffer(StringCaptureXmlFilter.this).append(chars, start, length);
            StringCaptureXmlFilter.ra$_buffer(StringCaptureXmlFilter.this).append("-->");
        }
    }
}

