/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.xml.sax.AbstractXmlReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;

public abstract class XmlReaderMultiplexer
extends AbstractXmlReader {
    private final TreeMap _features;
    private final TreeMap _properties;

    protected XmlReaderMultiplexer() {
        this.$init$();
        this.setFeature("http://xml.org/sax/features/namespaces", true);
        this.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
    }

    protected abstract XMLReader getDelegate(InputSource var1) throws IOException, SAXException;

    public void parse(InputSource input) throws IOException, SAXException {
        XMLReader delegate = this.getDelegate(input);
        for (Map.Entry entry : this._features.entrySet()) {
            delegate.setFeature((String)entry.getKey(), Boolean.TRUE.equals(entry.getValue()));
        }
        for (Map.Entry entry : this._properties.entrySet()) {
            delegate.setProperty((String)entry.getKey(), entry.getValue());
        }
        delegate.setContentHandler(this.getContentHandler());
        delegate.setDTDHandler(this.getDTDHandler());
        delegate.setEntityResolver(this.getEntityResolver());
        delegate.setErrorHandler(this.getErrorHandler());
        delegate.parse(input);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException {
        return Boolean.TRUE.equals(this._get(this._features, name));
    }

    public Object getProperty(String name) throws SAXNotRecognizedException {
        return this._get(this._properties, name);
    }

    public void setFeature(String name, boolean value) {
        this._features.put(name, BooleanUtils.getBoolean((boolean)value));
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    private Object _get(Map map, Object key) throws SAXNotRecognizedException {
        Object value = map.get(key);
        if (value == null) {
            throw new SAXNotRecognizedException(key.toString());
        }
        return value;
    }

    private void $init$() {
        this._features = new TreeMap();
        this._properties = new TreeMap();
    }
}

