/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WeakListenerManager {
    private final List _listenerRefs;
    private final ReferenceQueue _queue;
    private final String _sourceDesc;
    private static final Logger _sLOGGER = Logger.getLogger(WeakListenerManager.class.getName());

    public WeakListenerManager(String sourceDesc) {
        this.$init$();
        this._sourceDesc = sourceDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Object listener) {
        boolean wasEmpty = this.areListenersAttached() ^ true;
        List list = this._listenerRefs;
        synchronized (list) {
            Iterator toAddItor = this._findListener(listener);
            if (toAddItor != null) {
                _sLOGGER.warning("Tried to add listener that was already attached: listener=" + listener + "source=" + this._sourceDesc);
            } else {
                WeakReference<Object> ref = new WeakReference<Object>(listener, this._queue);
                if (_sLOGGER.isLoggable(Level.FINER)) {
                    _sLOGGER.log(Level.FINER, "Adding listener {0} via ref {1}", new Object[]{listener, ref});
                }
                this._listenerRefs.add(ref);
            }
        }
        if (wasEmpty) {
            this.areListenersAttachedChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(Object listener) {
        List list = this._listenerRefs;
        synchronized (list) {
            Iterator toRemoveItor = this._findListener(listener);
            if (toRemoveItor == null) {
                _sLOGGER.warning("Tried to remove listener that was not attached: listener=" + listener + "source=" + this._sourceDesc);
            } else {
                if (_sLOGGER.isLoggable(Level.FINER)) {
                    _sLOGGER.log(Level.FINER, "Removing listener {0}; refs set before={1}", new Object[]{listener, this._listenerRefs});
                }
                toRemoveItor.remove();
                if (_sLOGGER.isLoggable(Level.FINER)) {
                    _sLOGGER.log(Level.FINER, "Removed listener {0}; refs set after={1}", new Object[]{listener, this._listenerRefs});
                }
            }
            this._removeDeadListenerReferences();
        }
        if (!this.areListenersAttached()) {
            this.areListenersAttachedChanged();
        }
    }

    protected abstract void notifyListenerImpl(Object var1, Object var2, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean areListenersAttached() {
        List list = this._listenerRefs;
        synchronized (list) {
            boolean bl = this._listenerRefs.isEmpty() ^ true;
            return bl;
        }
    }

    protected void areListenersAttachedChanged() {
    }

    public final void notifyListeners(Object event) {
        this.notifyListeners(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyListeners(Object event, Object deliveryHint) {
        if (this.areListenersAttached()) {
            Reference[] refs;
            List list = this._listenerRefs;
            synchronized (list) {
                this._removeDeadListenerReferences();
                if (!this.areListenersAttached()) {
                    this.areListenersAttachedChanged();
                    refs = null;
                } else {
                    refs = this._listenerRefs.toArray(new Reference[this._listenerRefs.size()]);
                }
            }
            if (refs != null && refs.length > 0) {
                int i = 0;
                while (i < refs.length) {
                    Object listener = refs[i].get();
                    if (listener != null) {
                        try {
                            this.notifyListenerImpl(listener, event, deliveryHint);
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            _sLOGGER.log(Level.SEVERE, "Unexpected exception notifying listener " + listener + "; source=" + this._sourceDesc, t);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void _removeDeadListenerReferences() {
        Reference ref;
        int removedCount = 0;
        while ((ref = this._queue.poll()) != null) {
            boolean ok = this._listenerRefs.remove(ref);
            if (!ok) {
                _sLOGGER.log(Level.SEVERE, "Dead reference not found in the set! {0}", ref);
            }
            ++removedCount;
        }
        if (_sLOGGER.isLoggable(Level.FINER)) {
            _sLOGGER.log(Level.FINER, "Cleaned up {0} dead listener references; attached={1}", new Object[]{new Integer(removedCount), this._listenerRefs});
        }
    }

    private Iterator _findListener(Object listener) {
        Iterator itor = this._listenerRefs.iterator();
        while (itor.hasNext()) {
            Reference ref = (Reference)itor.next();
            if (listener != ref.get()) continue;
            return itor;
        }
        return null;
    }

    private void $init$() {
        this._listenerRefs = new ArrayList();
        this._queue = new ReferenceQueue();
    }
}

