/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import oracle.bali.xml.util.NameToStringUtils;
import oracle.bali.xml.util.XmlNameUtils;

class BaseParser {
    private final CharSequence _input;
    private final int _length;
    private final int _startIndex;
    private int _i;

    protected void requireAndSkipChar(char c) throws NameToStringUtils.ParseException {
        if (this.atEnd() || this.curChar() != c) {
            this.fail("Expected char not found: " + c);
        }
        ++this._i;
    }

    protected String parseName() throws NameToStringUtils.ParseException {
        StringBuilder out = new StringBuilder();
        while (this.notAtEnd()) {
            char c = this.curChar();
            if (out.length() == 0) {
                if (!XmlNameUtils.isNameStartChar(c)) {
                    this.fail("Invalid name start char: " + c);
                }
            } else if (!XmlNameUtils.isNameChar(c)) break;
            out.append(c);
            ++this._i;
        }
        return out.toString();
    }

    protected boolean notAtEnd() {
        return this._i < this._length;
    }

    protected boolean atEnd() {
        return this._i >= this._length;
    }

    protected void fail(String msg) throws NameToStringUtils.ParseException {
        throw new NameToStringUtils.ParseException(this._input, this._startIndex, this._i, msg);
    }

    protected char getChar(int i) {
        return this._input.charAt(i);
    }

    protected char curChar() {
        return this.getChar(this._i);
    }

    protected char nextChar() {
        return this.getChar(this._i + 1);
    }

    protected int numCharsToEnd() {
        return this._length - this._i;
    }

    protected void moveNext() {
        ++this._i;
    }

    protected int getNextIndex() {
        return this._i;
    }

    protected void setNextIndex(int i) {
        this._i = i;
    }

    protected void parseUntil(StringBuilder out, char ... stopAt) {
        while (this.notAtEnd()) {
            char c = this.curChar();
            char[] cArray = stopAt;
            int n = 0;
            while (n < cArray.length) {
                char check = cArray[n];
                if (c == check) {
                    return;
                }
                ++n;
            }
            out.append(c);
            this.moveNext();
        }
    }

    BaseParser(CharSequence valueStr, int startIndex) {
        this._input = valueStr;
        this._length = this._input.length();
        this._i = startIndex;
        this._startIndex = startIndex;
    }
}

