/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.BaseParser;
import oracle.bali.xml.util.NameToStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QualifiedNameParser
extends BaseParser {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Map<String, String> _prefixToNamespace;
    private String _name;
    private String _namespace;
    private String _attrName;
    private String _attrNamespace;
    private String _attrValue;
    private String _identifier;
    private final List<QualifiedName> elementQNamePath;
    private QualifiedName attrQName;

    public static XmlKey parseXmlKey(Map<String, String> prefixToNamespace, CharSequence input, int[] indexInOut) throws NameToStringUtils.ParseException {
        if (input == null) {
            throw new NameToStringUtils.ParseException(input, indexInOut[0], indexInOut[0], "null input");
        }
        QualifiedNameParser parser = new QualifiedNameParser(prefixToNamespace, input, indexInOut[0]);
        XmlKey ret = parser._parseXmlKey();
        indexInOut[0] = parser.getNextIndex();
        return ret;
    }

    static {
        $assertionsDisabled = QualifiedNameParser.class.desiredAssertionStatus() ^ true;
    }

    static QualifiedName __parseQualifiedNameString(Map<String, String> prefixToNamespace, CharSequence input, int[] index) throws NameToStringUtils.ParseException {
        if (!($assertionsDisabled || index != null && index.length == 1)) {
            throw new AssertionError();
        }
        if (input == null) {
            throw new NameToStringUtils.ParseException(input, index[0], index[0], "null input");
        }
        QualifiedNameParser helper = new QualifiedNameParser(prefixToNamespace, input, index[0]);
        QualifiedName ret = helper._parseQName(true);
        index[0] = helper.getNextIndex();
        return ret;
    }

    private QualifiedName _parseQName(boolean respectNullPrefixMap) throws NameToStringUtils.ParseException {
        char next;
        this._name = null;
        this._namespace = null;
        this._attrName = null;
        this._attrNamespace = null;
        this._attrValue = null;
        this._identifier = null;
        if (this.atEnd()) {
            this.fail("No name found, reached end of input");
        }
        if (this.curChar() == '!') {
            this.moveNext();
            this._identifier = this.parseName();
            if (this._identifier.length() == 0) {
                this.fail("Identifier is empty");
            }
            this.requireAndSkipChar('!');
        }
        this._parseNamespaceAndName(false, respectNullPrefixMap);
        if (this.notAtEnd() && (next = this.curChar()) == '[') {
            this.moveNext();
            this.requireAndSkipChar('@');
            this._parseNamespaceAndName(true, false);
            this.requireAndSkipChar('=');
            this._attrValue = this._parseAttributeValue();
            this.requireAndSkipChar(']');
        }
        if (this._name == null || "".equals(this._name)) {
            this.fail("Empty local name not allowed");
        }
        if (this._identifier != null) {
            return QualifiedName.getQualifiedName(this._namespace, this._name, this._identifier);
        }
        if (this._attrName != null && "".equals(this._attrName)) {
            this.fail("Empty attribute local name not allowed");
        }
        return QualifiedName.getQualifiedName(this._namespace, this._name, this._attrNamespace, this._attrName, this._attrValue);
    }

    private void _parseNamespaceAndName(boolean isAttrCase, boolean respectNullPrefixMap) throws NameToStringUtils.ParseException {
        String tempName = null;
        String tempNamespace = null;
        tempName = this.parseName();
        if (this.notAtEnd() && this.curChar() == ':') {
            tempNamespace = this._prefixToNamespace.get(tempName);
            if (tempNamespace == null) {
                this.fail("Prefix unbound: " + tempName);
            }
            this.moveNext();
            tempName = this.parseName();
        } else if (respectNullPrefixMap) {
            tempNamespace = this._prefixToNamespace.get(null);
        }
        if (isAttrCase) {
            this._attrName = tempName;
            this._attrNamespace = tempNamespace;
        } else {
            this._name = tempName;
            this._namespace = tempNamespace;
        }
    }

    private String _parseAttributeValue() throws NameToStringUtils.ParseException {
        this.requireAndSkipChar('\'');
        StringBuilder out = new StringBuilder(this.numCharsToEnd());
        while (this.notAtEnd()) {
            char c = this.curChar();
            this.moveNext();
            if (c == '\'') {
                if (this.atEnd() || this.curChar() != '\'') break;
                this.moveNext();
            }
            out.append(c);
        }
        return out.toString();
    }

    private XmlKey _parseXmlKey() throws NameToStringUtils.ParseException {
        while (this.notAtEnd()) {
            char c;
            if (this.attrQName != null) {
                this.fail("key continued past attribute qname");
            }
            if ((c = this.curChar()) == '@') {
                this.moveNext();
                this.attrQName = this._parseQName(false);
                continue;
            }
            if (c == '{') {
                return this._parseNamespaceKey();
            }
            QualifiedName name = this._parseQName(true);
            if (this.numCharsToEnd() >= 2 && this.curChar() == '(' && this.nextChar() == ')') {
                this.moveNext();
                this.moveNext();
                if (this.attrQName != null || !this.elementQNamePath.isEmpty()) {
                    this.fail("global node key " + name.getName() + " found, but was not at start of string");
                }
                if ("text".equals(name.getName())) {
                    return GlobalNodeTypeKey.TEXT_KEY;
                }
                if ("cdata-section".equals(name.getName())) {
                    return GlobalNodeTypeKey.CDATA_SECTION_KEY;
                }
                if ("comment".equals(name.getName())) {
                    return GlobalNodeTypeKey.COMMENT_KEY;
                }
                if ("document-node".equals(name.getName())) {
                    return GlobalNodeTypeKey.DOCUMENT_KEY;
                }
                if ("document-type".equals(name.getName())) {
                    return GlobalNodeTypeKey.DOCUMENT_TYPE_KEY;
                }
                if ("processing-instruction".equals(name.getName())) {
                    return GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY;
                }
                this.fail("invalid global node-seeming key string: " + name.getName());
                continue;
            }
            this.elementQNamePath.add(name);
            if (!this.notAtEnd() || this.curChar() != '/') break;
            this.moveNext();
        }
        if (this.attrQName != null) {
            if (this.elementQNamePath.isEmpty()) {
                return ImmutableXmlKey.createAttributeKey(this.attrQName);
            }
            return ImmutableXmlKey.createAttributeKey(this.elementQNamePath, this.attrQName);
        }
        if (!this.elementQNamePath.isEmpty()) {
            return ImmutableXmlKey.createElementKey(this.elementQNamePath);
        }
        this.fail("no key information found!");
        return null;
    }

    private XmlKey _parseNamespaceKey() throws NameToStringUtils.ParseException {
        this.moveNext();
        StringBuilder out = new StringBuilder();
        this.parseUntil(out, '}');
        this.requireAndSkipChar('}');
        String namespace = out.length() == 0 ? null : out.toString();
        return ImmutableXmlKey.createNamespaceKey(namespace);
    }

    private QualifiedNameParser(Map<String, String> prefixToNamespace, CharSequence valueStr, int startIndex) {
        super(valueStr, startIndex);
        this.$init$();
        this._prefixToNamespace = prefixToNamespace;
    }

    private void $init$() {
        this._name = null;
        this._namespace = null;
        this._attrName = null;
        this._attrNamespace = null;
        this._attrValue = null;
        this._identifier = null;
        this.elementQNamePath = new LinkedList<QualifiedName>();
        this.attrQName = null;
    }
}

