/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationException
extends SAXParseException {
    public static final int TYPE_UNKNOWN = 0;
    public static final int WARNING_GRAMMAR_UNAVAILABLE = 10;
    public static final int WARNING_DOCUMENT_GRAMMAR_UNAVAILABLE = 11;
    public static final int ERROR_ELEMENT_UNKNOWN = 20;
    public static final int ERROR_ELEMENT_UNEXPECTED = 21;
    public static final int ERROR_ELEMENT_SIMPLE_TYPE = 22;
    public static final int ERROR_ELEMENT_MISSING = 23;
    public static final int ERROR_ELEMENT_RESTRICTED = 24;
    public static final int ERROR_ELEMENT_FIXED = 25;
    public static final int WARNING_ELEMENT_TYPE_NULL = 26;
    public static final int ERROR_ATTRIBUTE_UNKNOWN = 30;
    public static final int ERROR_ATTRIBUTE_SIMPLE_TYPE = 31;
    public static final int ERROR_ATTRIBUTE_MISSING = 32;
    public static final int ERROR_ATTRIBUTE_FIXED = 33;
    public static final int WARNING_ATTRIBUTE_TYPE_NULL = 34;
    public static final int WARNING_ATTRIBUTE_UNKNOWN = 35;
    public static final int WARNING_ATTRIBUTE_MISSING = 122;
    public static final int ERROR_CHARACTER_DATA_NOT_ALLOWED = 38;
    public static final int ERROR_TOO_MANY = 40;
    public static final int ERROR_TOO_FEW = 41;
    public static final int ERROR_SEQUENCE = 42;
    public static final int ERROR_UNBOUND_IDREF = 45;
    public static final int USAGE_ERROR_ROOT_WRONG_TYPE = 50;
    public static final int USAGE_ERROR_ROOT_ARG_NULL = 51;
    public static final int USAGE_ERROR_NO_OWNER = 52;
    public static final int USAGE_ERROR_NULL_DOCUMENT_ELEMENT = 53;
    public static final String XML_TYPE_UNKNOWN = "XML-TYPE-UNKNOWN";
    public static final String XML_WARNING_GRAMMAR_UNAVAILABLE = "XML-WARNING-GRAMMAR-UNAVAILABLE";
    public static final String XML_WARNING_DOCUMENT_GRAMMAR_UNAVAILABLE = "XML-WARNING-DOCUMENT-GRAMMAR-UNAVAILABLE";
    public static final String XML_ERROR_ELEMENT_UNKNOWN = "XML-ELEMENT-UNKNOWN";
    public static final String XML_ERROR_ELEMENT_UNEXPECTED = "XML-ELEMENT-UNEXPECTED";
    public static final String XML_ERROR_ELEMENT_SIMPLE_TYPE = "XML-ELEMENT-SIMPLE-TYPE";
    public static final String XML_ERROR_ELEMENT_MISSING = "XML-ELEMENT-MISSING";
    public static final String XML_ERROR_ELEMENT_RESTRICTED = "XML-ELEMENT-RESTRICTED";
    public static final String XML_ERROR_ELEMENT_FIXED = "XML-ELEMENT-FIXED";
    public static final String XML_WARNING_ELEMENT_TYPE_NULL = "XML-WARNING-ELEMENT-TYPE-NULL";
    public static final String XML_ERROR_ATTRIBUTE_UNKNOWN = "XML-ATTRIBUTE-UNKNOWN";
    public static final String XML_ERROR_ATTRIBUTE_SIMPLE_TYPE = "XML-ATTRIBUTE-SIMPLE-TYPE";
    public static final String XML_ERROR_ATTRIBUTE_MISSING = "XML-ATTRIBUTE-MISSING";
    public static final String XML_ERROR_ATTRIBUTE_FIXED = "XML-ATTRIBUTE-FIXED";
    public static final String XML_WARNING_ATTRIBUTE_TYPE_NULL = "XML-WARNING-ATTRIBUTE-TYPE-NULL";
    public static final String XML_WARNING_ATTRIBUTE_UNKNOWN = "XML-WARNING-ATTRIBUTE-UNKNOWN";
    public static final String XML_WARNING_ATTRIBUTE_MISSING = "XML-WARNING-ATTRIBUTE-MISSING";
    public static final String XML_ERROR_CHARACTER_DATA_NOT_ALLOWED = "XML-CHARACTER-DATA-NOT-ALLOWED";
    public static final String XML_ERROR_TOO_MANY = "XML-TOO-MANY";
    public static final String XML_ERROR_TOO_FEW = "XML-TOO-FEW";
    public static final String XML_ERROR_SEQUENCE = "XML-SEQUENCE";
    public static final String XML_ERROR_UNBOUND_IDREF = "XML-UNBOUND-IDREF";
    public static final String XML_USAGE_ERROR_ROOT_WRONG_TYPE = "XML-USAGE-ROOT-WRONG-TYPE";
    public static final String XML_USAGE_ERROR_ROOT_ARG_NULL = "XML-USAGE-ROOT-ARG-NULL";
    public static final String XML_USAGE_ERROR_NO_OWNER = "XML-USAGE-NO-OWNER";
    public static final String XML_USAGE_ERROR_NULL_DOCUMENT_ELEMENT = "XML-USAGE-NULL-DOCUMENT-ELEMENT";
    private static final Map<Integer, String> _errorTypeMap = new HashMap<Integer, String>();
    private int _type;
    private Node _invalidNode;
    private Object _relatedObject;
    private Map<String, Object> _parametersMap;

    public ValidationException(int type, String message, Node invalidNode) {
        super(message, "", "", 0, 0);
        this.$init$();
        this._invalidNode = invalidNode;
        this._type = type;
    }

    public ValidationException(int type, String message, Node invalidNode, Exception source) {
        super(message, "", "", 0, 0, source);
        this.$init$();
        this._invalidNode = invalidNode;
        this._type = type;
    }

    public Node getInvalidNode() {
        return this._invalidNode;
    }

    public int getType() {
        return this._type;
    }

    public String getTypeString() {
        return _errorTypeMap.get(this.getType());
    }

    public Object getRelatedObject() {
        return this._relatedObject;
    }

    public void setRelatedObject(Object obj) {
        this._relatedObject = obj;
    }

    public Map<String, Object> getParameters() {
        return this._parametersMap;
    }

    public void setParameters(Map<String, Object> params) {
        if (params != null) {
            this._parametersMap = params;
        }
    }

    public Object getParameter(String key) {
        return this._parametersMap.get(key);
    }

    public void setParmeter(String key, Object value) {
        this._parametersMap.put(key, value);
    }

    static {
        _errorTypeMap.put(new Integer(0), XML_TYPE_UNKNOWN);
        _errorTypeMap.put(new Integer(10), XML_WARNING_GRAMMAR_UNAVAILABLE);
        _errorTypeMap.put(new Integer(11), XML_WARNING_DOCUMENT_GRAMMAR_UNAVAILABLE);
        _errorTypeMap.put(new Integer(20), XML_ERROR_ELEMENT_UNKNOWN);
        _errorTypeMap.put(new Integer(21), XML_ERROR_ELEMENT_UNEXPECTED);
        _errorTypeMap.put(new Integer(22), XML_ERROR_ELEMENT_SIMPLE_TYPE);
        _errorTypeMap.put(new Integer(23), XML_ERROR_ELEMENT_MISSING);
        _errorTypeMap.put(new Integer(24), XML_ERROR_ELEMENT_RESTRICTED);
        _errorTypeMap.put(new Integer(25), XML_ERROR_ELEMENT_FIXED);
        _errorTypeMap.put(new Integer(26), XML_WARNING_ELEMENT_TYPE_NULL);
        _errorTypeMap.put(new Integer(30), XML_ERROR_ATTRIBUTE_UNKNOWN);
        _errorTypeMap.put(new Integer(31), XML_ERROR_ATTRIBUTE_SIMPLE_TYPE);
        _errorTypeMap.put(new Integer(32), XML_ERROR_ATTRIBUTE_MISSING);
        _errorTypeMap.put(new Integer(33), XML_ERROR_ATTRIBUTE_FIXED);
        _errorTypeMap.put(new Integer(34), XML_WARNING_ATTRIBUTE_TYPE_NULL);
        _errorTypeMap.put(new Integer(35), XML_WARNING_ATTRIBUTE_UNKNOWN);
        _errorTypeMap.put(new Integer(122), XML_WARNING_ATTRIBUTE_MISSING);
        _errorTypeMap.put(new Integer(38), XML_ERROR_CHARACTER_DATA_NOT_ALLOWED);
        _errorTypeMap.put(new Integer(40), XML_ERROR_TOO_MANY);
        _errorTypeMap.put(new Integer(41), XML_ERROR_TOO_FEW);
        _errorTypeMap.put(new Integer(42), XML_ERROR_SEQUENCE);
        _errorTypeMap.put(new Integer(45), XML_ERROR_UNBOUND_IDREF);
        _errorTypeMap.put(new Integer(50), XML_USAGE_ERROR_ROOT_WRONG_TYPE);
        _errorTypeMap.put(new Integer(51), XML_USAGE_ERROR_ROOT_ARG_NULL);
        _errorTypeMap.put(new Integer(52), XML_USAGE_ERROR_NO_OWNER);
        _errorTypeMap.put(new Integer(53), XML_USAGE_ERROR_NULL_DOCUMENT_ELEMENT);
    }

    private void $init$() {
        this._type = 0;
        this._invalidNode = null;
        this._relatedObject = null;
        this._parametersMap = new HashMap<String, Object>();
    }
}

