/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.automata.AutomataBuilder;
import oracle.bali.xml.grammar.automata.ElementDefTransition;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.automata.WildcardTransition;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.validator.CachingValidatorCallback;
import oracle.bali.xml.validator.DefaultValidationContext;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.UniqueException;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.ValidatorCallback;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public final class Validator {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String IGNORED_NAMESPACE = "http://xmlns.oracle.com/jdeveloper/xmlef/ignored";
    public static final String INVALID_NAMESPACE_SUBSTITUTE = "error:invalid-namespace";
    private static Logger _sLogger = null;
    private static final HashSet _IGNORED_ATTR_NAMESPACES = new HashSet();
    private static final HashSet _IGNORED_ELEMENTS = new HashSet();
    private static final HashSet _LAX_WILDCARD_NAMESPACES = new HashSet();
    private static final String _VALIDATOR_BUNDLE = "oracle.bali.xml.validator.resource.ValidatorBundle";
    private static final String _KEY_WARNING_GRAMMAR_UNAVAILABLE = "WARNING_GRAMMAR_UNAVAILABLE";
    private static final String _KEY_WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE = "WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE";
    private static final String _KEY_ERROR_ELEMENT_UNKNOWN = "ERROR_ELEMENT_UNKNOWN";
    private static final String _KEY_ERROR_ELEMENT_UNEXPECTED = "ERROR_ELEMENT_UNEXPECTED";
    private static final String _KEY_ERROR_ELEMENT_SIMPLE_TYPE = "ERROR_ELEMENT_SIMPLE_TYPE";
    private static final String _KEY_ERROR_ELEMENT_SIMPLE_TYPE_ANON = "ERROR_ELEMENT_SIMPLE_TYPE_ANON";
    private static final String _KEY_ERROR_ELEMENT_MISSING = "ERROR_ELEMENT_MISSING";
    private static final String _KEY_ERROR_ELEMENT_MISSING_UNSPECIFIED = "ERROR_ELEMENT_MISSING_UNSPECIFIED";
    private static final String _KEY_ERROR_ELEMENT_RESTRICTED = "ERROR_ELEMENT_RESTRICTED";
    private static final String _KEY_ERROR_ELEMENT_FIXED = "ERROR_ELEMENT_FIXED";
    private static final String _KEY_WARNING_ELEMENT_TYPE_NULL = "WARNING_ELEMENT_TYPE_NULL";
    private static final String _KEY_ERROR_ATTRIBUTE_UNKNOWN = "ERROR_ATTRIBUTE_UNKNOWN";
    private static final String _KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE = "ERROR_ATTRIBUTE_SIMPLE_TYPE";
    private static final String _KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON = "ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON";
    private static final String _KEY_ERROR_ATTRIBUTE_MISSING = "ERROR_ATTRIBUTE_MISSING";
    private static final String _KEY_ERROR_ATTRIBUTE_FIXED = "ERROR_ATTRIBUTE_FIXED";
    private static final String _KEY_WARNING_ATTRIBUTE_TYPE_NULL = "WARNING_ATTRIBUTE_TYPE_NULL";
    private static final String _KEY_WARNING_ATTRIBUTE_UNKNOWN = "WARNING_ATTRIBUTE_UNKNOWN";
    private static final String _KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED = "ERROR_CHARACTER_DATA_NOT_ALLOWED";
    private static final String _KEY_ERROR_TOO_MANY = "ERROR_TOO_MANY";
    private static final String _KEY_ERROR_TOO_FEW = "ERROR_TOO_FEW";
    private static final String _KEY_ERROR_SEQUENCE = "ERROR_SEQUENCE";
    private static final String _KEY_ERROR_UNIQUE_IN_FILE = "ERROR_UNIQUE_IN_FILE";
    private static final String _KEY_ERROR_UNBOUND_IDREF = "ERROR_UNBOUND_IDREF";
    private static final String _ERROR_ARG_NULL = "Null DOM node passed as argument to Validator";
    private static final String _ERROR_NO_OWNER = "Attr with no owner Element passed as argument to Validator";
    private static final String _ERROR_NULL_DOCUMENT_ELEMENT = "Document has no root element";

    public static boolean validateSubtree(ValidationContext context, Node root) {
        boolean stillValid;
        block1: {
            block2: {
                block0: {
                    stillValid = true;
                    if (root.getNodeType() != 9) break block0;
                    Document document = (Document)root;
                    stillValid = Validator.validateDocument(context, document);
                    break block1;
                }
                if (root.getNodeType() != 1) break block2;
                Element element = (Element)root;
                stillValid = Validator.validateElement(context, element);
                break block1;
            }
            if (root.getNodeType() != 2) break block1;
            Attr attr = (Attr)root;
            stillValid = Validator.validateAttribute(context, attr);
        }
        return stillValid;
    }

    public static boolean validateDocument(ValidationContext context, Document document) {
        if (document == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        PerValidationState validationState = new PerValidationState();
        CachingValidatorCallback.enableCaching(document);
        try {
            context.performAdditionalValidation(validationState, document);
            Element rootElement = document.getDocumentElement();
            if (rootElement != null) {
                ElementDef elementDef = Validator._getStarterElementDef(context, rootElement);
                Validator._validateElement(context, validationState, rootElement, elementDef, 0, true);
                if (context.getFeature("ID_VALIDATION")) {
                    Validator._validateIdReferences(context, validationState);
                }
            } else {
                context.reportError(validationState, 53, _ERROR_NULL_DOCUMENT_ELEMENT, document, null, null);
            }
        }
        finally {
            CachingValidatorCallback.disableCaching(document);
        }
        return validationState.isStillValid();
    }

    public static boolean validateElement(ValidationContext context, Element root) {
        return Validator.validateElement(context, root, true);
    }

    public static boolean validateElement(ValidationContext context, Element element, boolean deep) {
        if (element == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        PerValidationState validationState = new PerValidationState();
        Document ownerDocument = element.getOwnerDocument();
        CachingValidatorCallback.enableCaching(ownerDocument);
        try {
            ElementDef elementDef = Validator._getStarterElementDef(context, element);
            Validator._validateElement(context, validationState, element, elementDef, 0, deep);
        }
        finally {
            CachingValidatorCallback.disableCaching(ownerDocument);
        }
        return validationState.isStillValid();
    }

    public static boolean validateAttribute(ValidationContext context, Attr attribute) {
        ComplexType complexType;
        Wildcard attributeWildcard;
        Type type;
        String attrLocalName;
        String attrNamespace;
        if (attribute == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        Element ownerElement = attribute.getOwnerElement();
        if (ownerElement == null) {
            throw new IllegalArgumentException(_ERROR_NO_OWNER);
        }
        PerValidationState validationState = new PerValidationState();
        ElementDef ownerDef = Validator._getStarterElementDef(context, ownerElement);
        AttributeDef attributeDef = null;
        int processingRule = 0;
        if (ownerDef != null && (attributeDef = ownerDef.getAttributeDefByName(attrNamespace = attribute.getNamespaceURI(), attrLocalName = Validator._getLocalName(attribute))) == null && (type = ownerDef.getType()) instanceof ComplexType && (attributeWildcard = (complexType = (ComplexType)type).getAttributeWildcard()) != null && TypeUtils.wildcardAllowsNamespace(attributeWildcard, attrNamespace)) {
            processingRule = attributeWildcard.getProcessingRule();
            GrammarResolver resolver = context.getGrammarResolver();
            Grammar g = resolver.getGrammarForNamespace(attrNamespace);
            if (g != null) {
                attributeDef = g.getAttributeDefByName(attrLocalName);
            }
        }
        Validator._validateAttribute(context, validationState, attribute, attributeDef, processingRule);
        return validationState.isStillValid();
    }

    protected static String getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle(_VALIDATOR_BUNDLE, Locale.getDefault());
            String string = b.getString(key);
            return string;
        }
        catch (Exception e) {
            Validator.getLogger().log(Level.SEVERE, "Error fetching resource for key: " + key, e);
            String string = "???" + key + "???";
            return string;
        }
    }

    protected static String getTranslatedString(String key, String arg0, String arg1) {
        try {
            String pattern = Validator.getTranslatedString(key);
            Object[] args = new Object[]{arg0, arg1};
            String string = MessageFormat.format(pattern, args);
            return string;
        }
        catch (Exception e) {
            Validator.getLogger().log(Level.SEVERE, "Error fetching resource for key: " + key, e);
            String string = "???" + key + "???";
            return string;
        }
    }

    protected static Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger("oracle.bali.xml.validator");
        }
        return _sLogger;
    }

    private static void _validateElement(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, int processingRule, boolean deep) {
        Validator._validateElement(context, validationState, element, elementDef, null, null, processingRule, deep);
    }

    private static void _validateElement(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, State automataState, ElementDef automataParentDef, int processingRule, boolean deep) {
        if (processingRule != 2) {
            context.performAdditionalValidation(validationState, element, elementDef, processingRule, deep);
            if (elementDef == null) {
                String elementLocalName;
                String elementNamespace;
                QualifiedName elementQName;
                if (processingRule == 0 && !_IGNORED_ELEMENTS.contains(elementQName = QualifiedName.getQualifiedName(elementNamespace = element.getNamespaceURI(), elementLocalName = Validator._getLocalName(element)))) {
                    GrammarResolver resolver = context.getGrammarResolver();
                    Grammar g = resolver.getGrammarForNamespace(elementNamespace);
                    if (g != null) {
                        if (automataState != null) {
                            String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNEXPECTED, element.getTagName(), "");
                            context.reportError(validationState, 21, message, element, null, null);
                        } else {
                            String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNKNOWN, element.getTagName(), element.getParentNode().getNodeName());
                            context.reportError(validationState, 20, message, element, null, null);
                        }
                    } else {
                        int errorType = 10;
                        Node parentNode = element.getParentNode();
                        if (parentNode.getNodeType() == 9) {
                            errorType = 11;
                        }
                        String message = null;
                        message = elementNamespace != null ? Validator.getTranslatedString(_KEY_WARNING_GRAMMAR_UNAVAILABLE, elementNamespace, elementLocalName) : Validator.getTranslatedString(_KEY_WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE, elementNamespace, elementLocalName);
                        context.reportWarning(validationState, errorType, message, element, null);
                    }
                }
            } else {
                Type type = elementDef.getType();
                if (type == null) {
                    String message = Validator.getTranslatedString(_KEY_WARNING_ELEMENT_TYPE_NULL, element.getTagName(), "");
                    context.reportWarning(validationState, 26, message, element, null);
                    return;
                }
                ComplexType complexType = null;
                SimpleType simpleType = null;
                Wildcard attributeWildcard = null;
                if (type instanceof SimpleType) {
                    simpleType = (SimpleType)type;
                } else {
                    complexType = (ComplexType)type;
                    attributeWildcard = complexType.getAttributeWildcard();
                }
                Validator._validateAttributes(context, validationState, element, elementDef, attributeWildcard);
                if (simpleType != null) {
                    Validator._validateElementSimpleContent(context, validationState, element, elementDef, simpleType);
                } else {
                    int variety = complexType.getVariety();
                    if (variety == 5) {
                        simpleType = TypeUtils.getSimpleTypeAncestor(complexType);
                        Validator._validateElementSimpleContent(context, validationState, element, elementDef, simpleType);
                    } else if (deep) {
                        ContentGroup group = complexType.getContentGroup();
                        boolean isMixed = variety == 4;
                        Validator._validateChildren(context, validationState, element, elementDef, group, isMixed);
                    }
                }
            }
        }
    }

    private static void _validateChildren(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, ContentGroup group, boolean isMixed) {
        if (group != null) {
            if (context.getFeature("RESPECT_GROUP_RULES")) {
                GrammarResolver resolver = context.getGrammarResolver();
                State currentState = AutomataBuilder.buildAutomata(group);
                Node child = element.getFirstChild();
                while (child != null) {
                    short nodeType = child.getNodeType();
                    if (nodeType == 1) {
                        Element childElement = (Element)child;
                        String namespace = childElement.getNamespaceURI();
                        String localName = Validator._getLocalName(childElement);
                        QualifiedName qName = QualifiedName.getQualifiedName(namespace, localName);
                        ElementDef childDef = null;
                        int childProcessingRule = 0;
                        Transition t = currentState.getTransitionFromState(resolver, qName);
                        if (t != null) {
                            if (t instanceof ElementDefTransition) {
                                childDef = ((ElementDefTransition)t).getElementDef(resolver, qName);
                            } else if (t instanceof WildcardTransition) {
                                Wildcard wildcard = ((WildcardTransition)t).getWildcard();
                                childProcessingRule = _LAX_WILDCARD_NAMESPACES.contains(wildcard.getTargetNamespace()) ? 1 : wildcard.getProcessingRule();
                                Grammar g = resolver.getGrammarForNamespace(namespace);
                                if (g != null) {
                                    childDef = g.getElementDefByName(localName);
                                }
                            }
                            currentState = t.getToState();
                        }
                        Validator._validateElement(context, validationState, childElement, childDef, currentState, elementDef, childProcessingRule, true);
                    } else if ((nodeType == 3 || nodeType == 4) && !isMixed && Validator._hasNonWhitespaceChars(child.getNodeValue())) {
                        String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, element.getTagName(), "");
                        context.reportError(validationState, 38, message, child, null, null);
                    }
                    child = child.getNextSibling();
                }
                if (!currentState.isFinalState()) {
                    String message = null;
                    String transSummary = Validator._summarizeTransitionsFromState(currentState);
                    message = transSummary != null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING, transSummary, element.getTagName()) : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_UNSPECIFIED, element.getTagName(), "");
                    context.reportWarning(validationState, 23, message, element, null);
                }
            } else {
                Validator._validateChildrenIgnoringGroup(context, validationState, element, elementDef, isMixed);
            }
        } else {
            Validator._checkForIllegalChildren(context, validationState, element, isMixed);
        }
    }

    private static String _summarizeTransitionsFromState(State automataState) {
        List transitions;
        int numTransitions;
        String summary = null;
        if (automataState != null && (numTransitions = (transitions = automataState.getTransitionsFromState()).size()) > 0 && numTransitions <= 3) {
            StringBuffer buffer = new StringBuffer();
            boolean containsOnlyElementTransitions = true;
            if (numTransitions > 1) {
                buffer.append("(");
            }
            int i = 0;
            while (i < numTransitions) {
                QualifiedName qName;
                Transition t = (Transition)transitions.get(i);
                if (t instanceof ElementDefTransition) {
                    ElementDefTransition et = (ElementDefTransition)t;
                    qName = et.getElementDef().getQualifiedName();
                    if (i > 0) {
                        buffer.append("|");
                    }
                } else {
                    containsOnlyElementTransitions = false;
                    break;
                }
                buffer.append(qName.getName());
                ++i;
            }
            if (containsOnlyElementTransitions) {
                if (numTransitions > 1) {
                    buffer.append(")");
                }
                summary = buffer.toString();
            }
        }
        return summary;
    }

    private static void _validateChildrenIgnoringGroup(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, boolean isMixed) {
        GrammarResolver resolver = context.getGrammarResolver();
        List wildcards = TypeUtils.getElementWildcards(elementDef);
        Node child = element.getFirstChild();
        while (child != null) {
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                Wildcard matchingWildcard;
                Element childElement = (Element)child;
                String namespace = childElement.getNamespaceURI();
                String localName = Validator._getLocalName(childElement);
                ElementDef childDef = elementDef.getElementDefByName(namespace, localName);
                int childProcessingRule = 0;
                if (childDef == null && (matchingWildcard = TypeUtils.getMatchingWildcard(wildcards, namespace)) != null) {
                    childProcessingRule = matchingWildcard.getProcessingRule();
                    Grammar g = resolver.getGrammarForNamespace(namespace);
                    if (g != null) {
                        childDef = g.getElementDefByName(localName);
                    }
                }
                Validator._validateElement(context, validationState, childElement, childDef, childProcessingRule, true);
            } else if ((nodeType == 3 || nodeType == 4) && !isMixed && Validator._hasNonWhitespaceChars(child.getNodeValue())) {
                String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, element.getTagName(), "");
                context.reportError(validationState, 38, message, child, null, null);
            }
            child = child.getNextSibling();
        }
    }

    private static void _checkForIllegalChildren(ValidationContext context, PerValidationState validationState, Element simpleElement, boolean isMixed) {
        Node child = simpleElement.getFirstChild();
        while (child != null) {
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNKNOWN, child.getNodeName(), simpleElement.getNodeName());
                context.reportError(validationState, 20, message, child, null, null);
            } else if ((nodeType == 3 || nodeType == 4) && !isMixed && Validator._hasNonWhitespaceChars(child.getNodeValue())) {
                String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, simpleElement.getTagName(), "");
                context.reportError(validationState, 38, message, child, null, null);
            }
            child = child.getNextSibling();
        }
    }

    private static void _validateAttributes(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, Wildcard attributeWildcard) {
        Collection attrDefs = elementDef.getAttributeDefs();
        Iterator attrIter = attrDefs.iterator();
        boolean hasAttribute = false;
        while (attrIter.hasNext()) {
            AttributeDef attrDef = (AttributeDef)attrIter.next();
            if (!attrDef.isRequired()) continue;
            String ns = attrDef.getTargetNamespace();
            if ("".equals(ns)) {
                ns = null;
            }
            if (hasAttribute = element.hasAttributeNS(ns, attrDef.getName())) continue;
            String message = Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_MISSING, attrDef.getQualifiedName().getQualifiedName(), element.getTagName());
            context.reportError(validationState, 32, message, element, null, attrDef.getQualifiedName());
        }
        Attr currentAttr = null;
        AttributeDef currentDef = null;
        String attrNamespace = null;
        String attrLocalName = null;
        GrammarResolver resolver = context.getGrammarResolver();
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null) {
            int length = attrMap.getLength();
            int i = 0;
            while (i < length) {
                currentAttr = (Attr)attrMap.item(i);
                attrNamespace = currentAttr.getNamespaceURI();
                attrLocalName = Validator._getLocalName(currentAttr);
                currentDef = elementDef.getAttributeDefByName(attrNamespace, attrLocalName);
                int processingRule = 0;
                if (currentDef == null && attributeWildcard != null && TypeUtils.wildcardAllowsNamespace(attributeWildcard, attrNamespace)) {
                    processingRule = attributeWildcard.getProcessingRule();
                    Grammar g = resolver.getGrammarForNamespace(attrNamespace);
                    if (g != null) {
                        currentDef = g.getAttributeDefByName(attrLocalName);
                    }
                }
                Validator._validateAttribute(context, validationState, currentAttr, currentDef, processingRule);
                ++i;
            }
        }
    }

    private static void _validateAttribute(ValidationContext context, PerValidationState validationState, Attr attribute, AttributeDef attributeDef, int processingRule) {
        if (processingRule != 2) {
            if (attributeDef == null) {
                String attrNamespace;
                if (processingRule == 0 && !_IGNORED_ATTR_NAMESPACES.contains(attrNamespace = attribute.getNamespaceURI())) {
                    if (context.getFeature("TOLERATE_UNKNOWN_ATTRS")) {
                        String message = Validator.getTranslatedString(_KEY_WARNING_ATTRIBUTE_UNKNOWN, attribute.getName(), attribute.getOwnerElement().getTagName());
                        context.reportWarning(validationState, 35, message, attribute, null);
                    } else {
                        String message = Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_UNKNOWN, attribute.getName(), attribute.getOwnerElement().getTagName());
                        context.reportError(validationState, 30, message, attribute, null, null);
                    }
                }
            } else {
                boolean valuesMatch;
                String fixedValue;
                String attributeValue;
                SimpleType simpleType;
                block19: {
                    simpleType = attributeDef.getType();
                    attributeValue = attribute.getValue();
                    if (simpleType != null) {
                        try {
                            simpleType.validateValue(attributeValue);
                            if (attributeValue == null) break block19;
                            if (TypeUtils.isIdType(simpleType)) {
                                boolean duplicate = validationState.addId(attributeValue, attribute);
                                if (duplicate && context.getFeature("ID_VALIDATION")) {
                                    Node originalNode = validationState.getNodeForId(attributeValue);
                                    String message = Validator.getTranslatedString(_KEY_ERROR_UNIQUE_IN_FILE, attributeValue, "");
                                    UniqueException ve = new UniqueException(100, message, (Node)attribute, Collections.singletonList(originalNode));
                                    context.reportError(validationState, ve);
                                }
                            } else if (TypeUtils.isIdRefType(simpleType)) {
                                validationState.addIdReference(attributeValue, attribute);
                            } else if (TypeUtils.isIdRefsType(simpleType)) {
                                String[] refs = attributeValue.split(" ");
                                int i = 0;
                                while (i < refs.length) {
                                    String ref = refs[i].trim();
                                    if (ref.length() > 0) {
                                        validationState.addIdReference(ref, attribute);
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (GrammarException sourceException) {
                            String message = null;
                            String attributeName = attribute.getName();
                            String typeName = simpleType.getName();
                            message = typeName == null ? Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON, attributeName, "") : Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE, attributeName, typeName);
                            context.reportError(validationState, 31, message, attribute, sourceException, null);
                        }
                    } else {
                        String message = Validator.getTranslatedString(_KEY_WARNING_ATTRIBUTE_TYPE_NULL, attribute.getName(), attribute.getOwnerElement().getTagName());
                        context.reportWarning(validationState, 34, message, attribute, null);
                    }
                }
                if ((fixedValue = attributeDef.getFixedValue()) != null && !(valuesMatch = Validator._validateFixedValue(fixedValue, attributeValue, simpleType))) {
                    String message = Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_FIXED, attribute.getName(), fixedValue);
                    context.reportError(validationState, 33, message, attribute, null, null);
                }
            }
            context.performAdditionalValidation(validationState, attribute, attributeDef, processingRule);
        }
    }

    private static ElementDef _getStarterElementDef(ValidationContext context, Element element) {
        LinkedList<Element> documentPath = new LinkedList<Element>();
        Element currentElement = element;
        while (currentElement != null) {
            documentPath.addFirst(currentElement);
            Node parentNode = currentElement.getParentNode();
            currentElement = parentNode.getNodeType() == 1 ? (Element)parentNode : null;
        }
        GrammarResolver resolver = context.getGrammarResolver();
        ListIterator listIter = documentPath.listIterator();
        ElementDef currentDef = null;
        while (listIter.hasNext()) {
            Grammar grammar;
            Element anElement = (Element)listIter.next();
            ElementDef tempDef = null;
            String namespace = anElement.getNamespaceURI();
            String localName = Validator._getLocalName(anElement);
            if (currentDef != null) {
                tempDef = currentDef.getElementDefByName(namespace, localName);
            }
            if (tempDef == null && (grammar = resolver.getGrammarForNamespace(namespace)) != null) {
                tempDef = grammar.getElementDefByName(localName);
            }
            currentDef = tempDef;
        }
        return currentDef;
    }

    private static void _validateElementSimpleContent(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, SimpleType simpleType) {
        if (simpleType != null) {
            boolean valuesMatch;
            StringBuffer stringBuffer = new StringBuffer();
            Node child = element.getFirstChild();
            while (child != null) {
                String nodeValue;
                if ((child.getNodeType() == 3 || child.getNodeType() == 4) && (nodeValue = child.getNodeValue()) != null) {
                    stringBuffer.append(nodeValue);
                }
                child = child.getNextSibling();
            }
            String simpleValue = stringBuffer.toString();
            try {
                simpleType.validateValue(simpleValue);
            }
            catch (GrammarException sourceException) {
                String message = null;
                String elementTagName = element.getTagName();
                String typeName = simpleType.getName();
                message = typeName == null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_SIMPLE_TYPE_ANON, elementTagName, "") : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_SIMPLE_TYPE, elementTagName, typeName);
                context.reportError(validationState, 22, message, element, sourceException, null);
            }
            String fixedValue = elementDef.getFixedValue();
            if (fixedValue != null && !(valuesMatch = Validator._validateFixedValue(fixedValue, simpleValue, simpleType))) {
                String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_FIXED, element.getTagName(), fixedValue);
                context.reportError(validationState, 25, message, element, null, null);
            }
        }
        Validator._checkForIllegalChildren(context, validationState, element, true);
    }

    private static void _validateIdReferences(ValidationContext context, PerValidationState validationState) {
        Set referencedIds = validationState.getReferencedIds();
        for (String idReference : referencedIds) {
            if (validationState.getNodeForId(idReference) != null) continue;
            List invalidNodes = validationState.getIdReferenceNodes(idReference);
            for (Node invalidNode : invalidNodes) {
                String message = Validator.getTranslatedString(_KEY_ERROR_UNBOUND_IDREF, idReference, "");
                context.reportError(validationState, 45, message, invalidNode, null, null);
            }
        }
    }

    private static boolean _validateFixedValue(String fixedValue, String actualValue, SimpleType simpleType) {
        boolean equalValues = false;
        if (fixedValue.equals(actualValue)) {
            equalValues = true;
        } else if (simpleType != null) {
            try {
                Object obj1 = simpleType.convertToJavaType(fixedValue);
                Object obj2 = simpleType.convertToJavaType(actualValue);
                if (obj1 != null && obj2 != null) {
                    if (obj1.equals(obj2)) {
                        equalValues = true;
                    } else if (obj1 instanceof Comparable && ((Comparable)obj1).compareTo(obj2) == 0) {
                        equalValues = true;
                    }
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return equalValues;
    }

    private static String _getLocalName(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    if (node.getNamespaceURI() == null) {
                        return node.getNodeName();
                    }
                    return node.getLocalName();
                }
            }
        }
        return null;
    }

    private static boolean _hasNonWhitespaceChars(String characterData) {
        char[] cArr = characterData.toCharArray();
        int i = 0;
        while (i < cArr.length) {
            char c = cArr[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static {
        _IGNORED_ATTR_NAMESPACES.add(XML_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(XMLNS_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(XSI_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(IGNORED_NAMESPACE);
        QualifiedName jspComment10 = QualifiedName.getQualifiedName("http://java.sun.com/products/jsp/dtd/jsp_1_0.dtd", "jspComment");
        QualifiedName jspComment20 = QualifiedName.getQualifiedName("http://java.sun.com/products/jsp/dtd/jsp_2_0.dtd", "jspComment");
        _IGNORED_ELEMENTS.add(jspComment10);
        _IGNORED_ELEMENTS.add(jspComment20);
        _LAX_WILDCARD_NAMESPACES.add("http://java.sun.com/JSF/Configuration");
    }

    public static boolean validateSubtree(GrammarProvider provider, Node root, ErrorHandler errorHandler) {
        return Validator.validateSubtree(provider, root, errorHandler, null);
    }

    public static boolean validateSubtree(GrammarProvider provider, Node root, ErrorHandler errorHandler, ValidatorCallback validatorCallback) {
        DefaultValidationContext context = new DefaultValidationContext(new GrammarResolver(provider), errorHandler, validatorCallback);
        return Validator.validateSubtree(context, root);
    }

    public static boolean validateDocument(Document document, ErrorHandler errorHandler, GrammarProvider provider) {
        return Validator.validateDocument(document, errorHandler, provider, null);
    }

    public static boolean validateDocument(Document document, ErrorHandler errorHandler, GrammarProvider provider, ValidatorCallback validatorCallback) {
        DefaultValidationContext context = new DefaultValidationContext(new GrammarResolver(provider), errorHandler, validatorCallback);
        return Validator.validateDocument(context, document);
    }

    public static boolean validateSubtree(Element root, ErrorHandler errorHandler, GrammarProvider provider) {
        return Validator.validateSubtree(root, errorHandler, provider, null);
    }

    public static boolean validateSubtree(Element root, ErrorHandler errorHandler, GrammarProvider provider, ValidatorCallback validatorCallback) {
        return Validator.validateSubtree(root, errorHandler, provider, validatorCallback, true);
    }

    public static boolean validateSubtree(Element root, ErrorHandler errorHandler, GrammarProvider provider, ValidatorCallback validatorCallback, boolean deep) {
        DefaultValidationContext context = new DefaultValidationContext(new GrammarResolver(provider), errorHandler, validatorCallback);
        return Validator.validateElement(context, root, deep);
    }

    public static boolean validateAttribute(Attr attribute, ErrorHandler errorHandler, GrammarProvider provider) {
        return Validator.validateAttribute(attribute, errorHandler, provider, null);
    }

    public static boolean validateAttribute(Attr attribute, ErrorHandler errorHandler, GrammarProvider provider, ValidatorCallback validatorCallback) {
        DefaultValidationContext context = new DefaultValidationContext(new GrammarResolver(provider), errorHandler, validatorCallback);
        return Validator.validateAttribute(context, attribute);
    }
}

