/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.jdeveloper.xml.dtd.grammar.AttributeComplexType;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdContentGroup;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammarComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DtdElement
extends DtdGrammarComponent
implements ElementDef {
    private DtdGrammar _grammar;
    private String _name;
    private QualifiedName _qualifiedName;
    private boolean _startTagReq;
    private boolean _endTagReq;
    private SubstitutionGroup _substitutionGroup;
    private Map<QualifiedName, AttributeDef> _attributes;
    private Map<QualifiedName, ElementDef> _elements;
    private boolean _anyContent;
    private List<GrammarComponent> _includedElements;
    private ComplexType _type;

    DtdElement(DtdGrammar grammar, String elementName) {
        this.$init$();
        this._grammar = grammar;
        this._name = this._grammar.isCaseSensitive() ? elementName : elementName.toLowerCase();
    }

    @Override
    public String getTargetNamespace() {
        return this._grammar.getTargetNamespace();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (this._qualifiedName == null) {
            this._qualifiedName = QualifiedName.getQualifiedName(this.getTargetNamespace(), this._name);
        }
        return this._qualifiedName;
    }

    @Override
    public Type getType() {
        return this._type;
    }

    @Override
    public Collection getAttributeDefs() {
        if (this._attributes == null) {
            return Collections.EMPTY_LIST;
        }
        return this._attributes.values();
    }

    @Override
    public AttributeDef getAttributeDefByName(String attributeName) {
        return this.getAttributeDefByName(null, attributeName);
    }

    @Override
    public AttributeDef getAttributeDefByName(String nameSpace, String attributeName) {
        return this.getAttributeDefByName(QualifiedName.getQualifiedName(nameSpace, attributeName));
    }

    @Override
    public AttributeDef getAttributeDefByName(QualifiedName qName) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(this.getLocalQualifiedName(qName, false));
    }

    @Override
    public Collection getParentElementDefs() {
        return this._grammar.getParentElementDefs(this);
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ElementDef getReferencedElementDef() {
        return null;
    }

    @Override
    public Collection getElementDefs() {
        if (this._elements == null) {
            this._getContainingElements();
        }
        if (this._anyContent) {
            return this._grammar.getElementDefs();
        }
        Map elementMap = this._getContainingElements();
        if (elementMap == null) {
            return Collections.EMPTY_LIST;
        }
        return elementMap.values();
    }

    @Override
    public ElementDef getElementDefByName(String elementName) {
        return this.getElementDefByName(this.getTargetNamespace(), elementName);
    }

    @Override
    public ElementDef getElementDefByName(String nameSpace, String elementName) {
        return this.getElementDefByName(QualifiedName.getQualifiedName(nameSpace, elementName));
    }

    @Override
    public ElementDef getElementDefByName(QualifiedName qName) {
        if (qName.getIdentifier() != null || qName.getAttributeName() != null) {
            qName = QualifiedName.getQualifiedName(qName.getNamespace(), qName.getName());
        }
        if (this._elements == null) {
            this._getContainingElements();
        }
        if (this._anyContent) {
            boolean sameNS;
            String grammarNS = this._grammar.getTargetNamespace();
            String elementNS = qName.getNamespace();
            boolean bl = sameNS = grammarNS == null && elementNS == null;
            if (!sameNS && elementNS != null && grammarNS != null) {
                sameNS = elementNS.equals(grammarNS);
            }
            if (sameNS) {
                return this._grammar.getElementDefByName(qName.getName());
            }
            return null;
        }
        Map elementMap = this._getContainingElements();
        if (elementMap == null) {
            return null;
        }
        return (ElementDef)elementMap.get(this.getLocalQualifiedName(qName, true));
    }

    @Override
    public SubstitutionGroup getSubstitutionGroup() {
        return this._substitutionGroup;
    }

    @Override
    public void addToSubstitutionGroup(ElementDef elementDef) {
        this._substitutionGroup.addElementDef(elementDef);
    }

    @Override
    public void removeFromSubstitutionGroup(ElementDef elementDef) {
        this._substitutionGroup.removeElementDef(elementDef);
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public int getMinOccurs() {
        return 1;
    }

    @Override
    public int getMaxOccurs() {
        return 1;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public String getFixedValue() {
        return null;
    }

    public boolean isStartTagRequired() {
        return this._startTagReq;
    }

    public boolean isEndTagRequired() {
        return this._endTagReq;
    }

    void setStartTagRequired(boolean startTagReq) {
        this._startTagReq = startTagReq;
    }

    void setEndTagRequired(boolean endTagReq) {
        this._endTagReq = endTagReq;
    }

    void addAttribute(DtdAttribute attribute) {
        if (this._attributes == null) {
            this._attributes = new HashMap<QualifiedName, AttributeDef>();
        }
        this._attributes.put(this.getLocalQualifiedName(attribute.getQualifiedName(), false), attribute);
    }

    void setContentType(ComplexType type) {
        if (this._includedElements != null && type != null) {
            ContentGroup elementContent = type.getContentGroup();
            if (elementContent instanceof DtdContentGroup) {
                ((DtdContentGroup)elementContent).includeElements(this._includedElements);
            }
            this._includedElements = null;
        }
        this._type = new AttributeComplexType(type, this);
    }

    void includeElements(Collection<GrammarComponent> elements) {
        if (this._type == null) {
            this._includedElements = new LinkedList<GrammarComponent>(elements);
        } else {
            ContentGroup elementContent = this._type.getContentGroup();
            if (elementContent instanceof DtdContentGroup) {
                ((DtdContentGroup)elementContent).includeElements(elements);
            }
        }
    }

    private synchronized Map _getContainingElements() {
        if (this._elements == null && !this._anyContent) {
            if (this._grammar.isWildcardType(this._type)) {
                this._anyContent = true;
            } else {
                ComplexType contentType = (ComplexType)this._type.getBaseType();
                this._elements = new HashMap<QualifiedName, ElementDef>();
                if (contentType.getVariety() == 3 || contentType.getVariety() == 4) {
                    ContentGroup group = contentType.getContentGroup();
                    this.collectElements(group, this._elements);
                }
            }
        }
        return this._elements;
    }

    public String toString() {
        return this.getName();
    }

    private QualifiedName getLocalQualifiedName(QualifiedName qName, boolean element) {
        if (this._grammar.isCaseSensitive()) {
            return qName;
        }
        return this.getLocalQualifiedName(qName.getNamespace(), qName.getName(), element);
    }

    private QualifiedName getLocalQualifiedName(String namespace, String name, boolean element) {
        if (this._grammar.isCaseSensitive()) {
            return QualifiedName.getQualifiedName(namespace, name);
        }
        if (element) {
            return QualifiedName.getQualifiedName(namespace, name.toLowerCase());
        }
        return QualifiedName.getQualifiedName(namespace, name.toLowerCase());
    }

    private void collectElements(ContentGroup group, Map<QualifiedName, ElementDef> elements) {
        if (group == null) {
            return;
        }
        for (GrammarComponent component : group.getComponents()) {
            if (component instanceof ElementDef) {
                ElementDef elDef = (ElementDef)component;
                elements.put(this.getLocalQualifiedName(elDef.getQualifiedName(), true), elDef);
                continue;
            }
            if (!(component instanceof ContentGroup)) continue;
            this.collectElements((ContentGroup)component, elements);
        }
    }

    @Override
    String getMetadataElementName() {
        return "elementMetadata";
    }

    private void $init$() {
        this._startTagReq = true;
        this._endTagReq = true;
        this._substitutionGroup = new SubstitutionGroup();
    }
}

