/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.Type;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammarComponent;
import oracle.jdeveloper.xml.dtd.grammar.Entity;
import oracle.jdeveloper.xml.dtd.grammar.GrammarUtils;
import oracle.jdeveloper.xml.dtd.grammar.Notation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtdGrammar
extends DtdGrammarComponent
implements Grammar {
    private final String name;
    private final String root;
    private final String targetNamespace;
    private final String publicID;
    private final URL location;
    private boolean caseSensitive;
    private GrammarIdentifier _identifier;
    private Map notations;
    private Map<String, Entity> entityValues;
    private Map<String, Entity> entities;
    private Map<String, DtdAttribute> attributes;
    private Map<String, DtdElement> elements;

    DtdGrammar(String name, String namespace, String root, String publicID, URL location, boolean caseSensitive) {
        this.$init$();
        this.name = name;
        this.targetNamespace = namespace;
        this.caseSensitive = caseSensitive;
        this.root = root;
        this.publicID = publicID;
        this.location = location;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection getElementDefs() {
        if (this.elements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.elements.values();
    }

    @Override
    public ElementDef getElementDefByName(String elementName) {
        return this.getDtdElement(elementName);
    }

    @Override
    public Collection getAttributeDefs() {
        return this.attributes.values();
    }

    @Override
    public AttributeDef getAttributeDefByName(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public Collection getTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Type getTypeByName(String typeName) {
        return null;
    }

    @Override
    public GrammarIdentifier getGrammarIdentifier() {
        if (this._identifier == null) {
            String locationString = null;
            if (this.location != null) {
                locationString = this.location.toExternalForm();
            }
            this._identifier = GrammarIdentifier.getGrammarIdentifier(this.targetNamespace, this.publicID, locationString);
        }
        return this._identifier;
    }

    @Override
    public int getGrammarVariety() {
        return 1;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getRootElementName() {
        return this.root;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public Map<String, Notation> getNotations() {
        return this.notations;
    }

    public Map<String, Entity> getEntityValues() {
        return this.entityValues;
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    @Override
    String getMetadataElementName() {
        return "grammarMetadata";
    }

    void setAttributes(Map<String, DtdAttribute> attributes) {
        this.attributes = attributes;
    }

    void setNotations(Map notations) {
        this.notations = notations;
    }

    void setEntityValues(Map<String, Entity> entityValues) {
        this.entityValues = entityValues;
    }

    void setEntities(Map<String, Entity> entities) {
        this.entities = entities;
    }

    void addElement(DtdElement element) {
        if (this.elements == null) {
            this.elements = new HashMap<String, DtdElement>();
        }
        this.elements.put(element.getName(), element);
    }

    void postLoading() {
        if (this.elements == null) {
            return;
        }
    }

    private DtdElement getDtdElement(String elementName) {
        if (this.elements == null || elementName == null) {
            return null;
        }
        if (!this.caseSensitive) {
            elementName = elementName.toLowerCase();
        }
        return this.elements.get(elementName);
    }

    Collection getParentElementDefs(DtdElement element) {
        return null;
    }

    boolean isWildcardType(ComplexType type) {
        return GrammarUtils.getMatchingWildcard(type, this.getTargetNamespace()) != null;
    }

    private void $init$() {
        this.notations = Collections.EMPTY_MAP;
        this.entityValues = Collections.EMPTY_MAP;
        this.entities = Collections.EMPTY_MAP;
        this.attributes = Collections.EMPTY_MAP;
    }
}

