/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammarComponent;
import oracle.jdeveloper.xml.dtd.grammar.Entity;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import oracle.jdeveloper.xml.dtd.grammar.Notation;

public class DtdLoader {
    private static final String METADATA_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";
    private static final String GRAMMAR_METADATA_ELEMENT = "grammarMetadata";
    private static final String ELEMENT_METADATA_ELEMENT = "elementMetadata";
    private static final String ATTRIBUTE_METADATA_ELEMENT = "attributeMetadata";
    private String namespace;
    private boolean caseSensitive;
    private DtdGrammar grammar;
    private Map _refElements;
    protected Map<String, Entity> entities;
    protected Map<String, Entity> entityValues;
    protected Map<String, Notation> notations;

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void start(String name, String namespace, String root, String publicID, URL location, boolean caseSensitive) {
        this.reset();
        this.namespace = namespace;
        this.caseSensitive = caseSensitive;
        if (this.grammar == null) {
            this.grammar = new DtdGrammar(name, namespace, root, publicID, location, caseSensitive);
        }
    }

    public void addNotation(String name, Notation notation) {
        if (this.notations == null) {
            this.notations = new HashMap<String, Notation>();
        }
        this.notations.put(name, notation);
    }

    public Notation findNotation(String name) {
        if (this.notations == null) {
            return null;
        }
        return this.notations.get(name);
    }

    public void addEntity(String name, Entity entity) {
        if (this.entities == null) {
            this.entities = new HashMap<String, Entity>();
        }
        this.entities.put(name, entity);
    }

    public void addEntityValue(String value, Entity entity) {
        if (this.entityValues == null) {
            this.entityValues = new HashMap<String, Entity>();
        }
        this.entityValues.put(value, entity);
    }

    public Object findEntity(String name) {
        if (this.entities == null) {
            return null;
        }
        return this.entities.get(name);
    }

    public DtdElement createElement(String name) {
        DtdElement element = this._findRefElement(name);
        if (element == null) {
            if (this.findElement(name) != null) {
                System.out.println("Two elements with the name \"" + name + "\" created in namespace: " + this.getNamespace());
            }
            element = this._getRefElement(name);
        }
        return element;
    }

    public DtdElement getContentElement(String name) {
        DtdElement element = this.findElement(name);
        if (element == null) {
            element = this._getRefElement(name);
        }
        return element;
    }

    public void setElementDefinition(DtdElement element, ComplexType type, boolean startTagRequired, boolean endTagRequired) {
        element.setContentType(type);
        element.setStartTagRequired(startTagRequired);
        element.setEndTagRequired(endTagRequired);
    }

    public void addElement(DtdElement element) {
        this.grammar.addElement(element);
        this._removeRefElement(element);
    }

    public DtdAttribute createAttribute(String name, boolean isRequired, String defValue, String fixedValue, SimpleType type) {
        return new DtdAttribute(this.grammar, name, isRequired, defValue, fixedValue, type);
    }

    public void addAttribute(DtdElement element, DtdAttribute attribute) {
        element.addAttribute(attribute);
    }

    public DtdElement findElement(String name) {
        return (DtdElement)this.grammar.getElementDefByName(name);
    }

    public void finish() {
        if (this.grammar == null) {
            return;
        }
        if (this.entities != null) {
            this.grammar.setEntities(this.entities);
        }
        if (this.entityValues != null) {
            this.grammar.setEntityValues(this.entityValues);
        }
        if (this.notations != null) {
            this.grammar.setNotations(this.notations);
        }
        this.grammar.postLoading();
        this.dumpUndefinedElements();
    }

    public DtdGrammar getGrammar() {
        return this.getDtdGrammar();
    }

    public void setDescription(DtdElement element, String elementDescription) {
        this.setDescription(element, elementDescription, ELEMENT_METADATA_ELEMENT);
    }

    public void setDescription(DtdAttribute attribute, String attributeDescription) {
        this.setDescription(attribute, attributeDescription, ATTRIBUTE_METADATA_ELEMENT);
    }

    private void setDescription(DtdGrammarComponent component, String descriptionValue, String componentMetadata) {
        if (descriptionValue != null) {
            descriptionValue = descriptionValue.trim();
        }
        if (descriptionValue == null || descriptionValue.length() == 0) {
            return;
        }
        component.addComponentMetadata("shortDescription", descriptionValue);
    }

    protected DtdGrammar getDtdGrammar() {
        return this.grammar;
    }

    protected void reset() {
        this.grammar = null;
        this.notations = null;
        this.entities = null;
    }

    private DtdElement _getRefElement(String name) {
        DtdElement element = this._findRefElement(name);
        if (element == null) {
            if (this._refElements == null) {
                this._refElements = new HashMap();
            }
            element = new DtdElement(this.grammar, name);
            if (!this.isCaseSensitive()) {
                name = name.toLowerCase();
            }
            this._refElements.put(name, element);
        }
        return element;
    }

    private DtdElement _findRefElement(String name) {
        if (this._refElements == null) {
            return null;
        }
        if (!this.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        return (DtdElement)this._refElements.get(name);
    }

    private void _removeRefElement(DtdElement element) {
        if (this._refElements == null) {
            return;
        }
        String name = this.isCaseSensitive() ? element.getName() : element.getName().toLowerCase();
        this._refElements.remove(element.getName());
    }

    private void dumpUndefinedElements() {
        if (this._refElements == null || this._refElements.isEmpty()) {
            return;
        }
        ComplexType undefType = GrammarFactory.getEmptyType(this.getNamespace());
        for (DtdElement undefinedRefElement : this._refElements.values()) {
            undefinedRefElement.setContentType(undefType);
            this.grammar.addElement(undefinedRefElement);
        }
    }
}

