/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.jdevimpl.xml.dtd.parser.DocumentHandler;
import oracle.jdevimpl.xml.dtd.parser.ParserConstants;
import oracle.jdevimpl.xml.dtd.parser.ParserError;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractParser
implements ParserConstants {
    protected XMLReader reader;
    protected ParserError err;
    URL baseURL;
    boolean parsing;
    protected int[] bounds;
    boolean preserveWS;
    boolean namespaceFeature;
    boolean namespacePrefixFeature;
    boolean stringInternFeature;
    EntityResolver entResolver;
    LexicalHandler lexHandler;
    ContentHandler cntHandler;
    protected DeclHandler declHandler;
    DTDHandler dtdHandler;
    DocumentHandler documentHandler;
    boolean fixedDTD;
    boolean doctypePresent;
    int previousOffset;

    protected AbstractParser() {
        this.parsing = false;
        this.bounds = new int[2];
        this.preserveWS = false;
        this.namespaceFeature = true;
        this.namespacePrefixFeature = true;
        this.stringInternFeature = true;
        this.doctypePresent = false;
    }

    protected AbstractParser(AbstractParser abstractParser) {
        this.reader = abstractParser.reader;
        this.err = abstractParser.err;
        this.baseURL = abstractParser.baseURL;
        this.parsing = abstractParser.parsing;
        this.bounds = new int[2];
        this.preserveWS = abstractParser.preserveWS;
        this.namespaceFeature = abstractParser.namespaceFeature;
        this.namespacePrefixFeature = abstractParser.namespacePrefixFeature;
        this.stringInternFeature = abstractParser.stringInternFeature;
        this.entResolver = abstractParser.entResolver;
        this.lexHandler = abstractParser.lexHandler;
        this.cntHandler = abstractParser.cntHandler;
        this.declHandler = abstractParser.declHandler;
        this.dtdHandler = abstractParser.dtdHandler;
        this.documentHandler = abstractParser.documentHandler;
        this.fixedDTD = abstractParser.fixedDTD;
        this.doctypePresent = abstractParser.doctypePresent;
    }

    public final XMLReader getReader() {
        return this.reader;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((name = name.intern()) == "http://xml.org/sax/features/namespaces") {
            return this.namespaceFeature;
        }
        if (name == "http://xml.org/sax/features/namespace-prefixes") {
            return this.namespacePrefixFeature;
        }
        if (name == "http://xml.org/sax/features/string-interning") {
            return this.stringInternFeature;
        }
        if (name == "http://xml.org/sax/features/external-general-entities") {
            return true;
        }
        if (name == "http://xml.org/sax/features/external-parameter-entities") {
            return true;
        }
        throw new SAXNotRecognizedException(this.err.getMessage1(500, name));
    }

    public final URL getBaseURL() throws MalformedURLException {
        if (this.reader.isTopLevelReader() && this.baseURL != null) {
            return this.baseURL;
        }
        return new URL(this.reader.getSystemId());
    }

    public final ParserError getError() {
        return this.err;
    }

    public final ErrorHandler getErrorHandler() {
        return this.err.getErrorHandler();
    }

    public final EntityResolver getEntityResolver() {
        return this.entResolver;
    }

    public final DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public final LexicalHandler getLexicalHandler() {
        return this.lexHandler;
    }

    public final DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public final ContentHandler getContentHandler() {
        return this.cntHandler;
    }

    public final DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public final boolean getParsingStatus() {
        return this.parsing;
    }

    public final int getCurrentPosition() {
        return this.reader.getCurrentPosition() - 32;
    }

    public final void setReader(XMLReader reader) {
        this.reader = reader;
    }

    public void setFeature(String name, boolean flag) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((name = name.intern()) == "http://xml.org/sax/features/namespaces" || name == "http://xml.org/sax/features/namespace-prefixes" || name == "http://xml.org/sax/features/string-interning" || name == "http://xml.org/sax/features/validation") {
            if (this.parsing) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, name));
            }
            if (name == "http://xml.org/sax/features/namespaces") {
                if (!flag) {
                    throw new SAXNotSupportedException(this.err.getMessage1(501, name));
                }
                this.namespaceFeature = flag;
            } else if (name == "http://xml.org/sax/features/namespace-prefixes") {
                this.namespacePrefixFeature = flag;
            } else if (name == "http://xml.org/sax/features/string-interning") {
                this.stringInternFeature = flag;
            }
            return;
        }
        if (name == "http://xml.org/sax/features/external-general-entities") {
            if (!flag) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, name));
            }
        } else if (name == "http://xml.org/sax/features/external-parameter-entities") {
            if (!flag) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, name));
            }
        } else {
            throw new SAXNotRecognizedException(this.err.getMessage1(500, name));
        }
    }

    public final void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public final void setError(ParserError err) {
        this.err = err;
    }

    public final void setErrorHandler(ErrorHandler errorhandler) {
        this.err.setErrorHandler(errorhandler);
    }

    public final void setEntityResolver(EntityResolver entityresolver) {
        this.entResolver = entityresolver;
    }

    public final void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public final void setLexicalHandler(LexicalHandler lexHandler) {
        this.lexHandler = lexHandler;
    }

    public final void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    public final void setContentHandler(ContentHandler cntHandler) {
        this.cntHandler = cntHandler;
    }

    public final void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public final void setPreserveWhitespace(boolean flag) {
        this.preserveWS = flag;
    }

    void init() throws SAXException, IOException {
        this.doctypePresent = false;
        if (this.fixedDTD) {
            this.doctypePresent = true;
        }
        this.reset();
        this.err.reset();
    }

    void reset() throws SAXException, IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public abstract void parseDocument() throws SAXException, IOException;

    protected String getNoQuotesAttrValue() throws SAXException, IOException {
        this.err.error0(125, 0);
        return null;
    }

    protected String getSpecialAttrValue() throws SAXException, IOException {
        return null;
    }

    void parseWhiteSpace() throws SAXException, IOException {
        this.reader.skipWhiteSpace();
    }

    protected XMLEntity parseEntity(boolean parameterEntity) throws SAXException, IOException {
        XMLEntity xmlentity;
        String name = this.reader.scanQName();
        if (!this.reader.tryRead(59)) {
            // empty if block
        }
        if ((xmlentity = this.findEntity(name, parameterEntity)) == null) {
            this.err.error1(250, 0, name);
        }
        return xmlentity;
    }

    protected abstract XMLEntity findEntity(String var1, boolean var2);

    protected void parseComment() throws SAXException, IOException {
        char[] ac = this.reader.scanComment(this.bounds);
        if (this.bounds[1] > 0) {
            this.lexHandler.comment(ac, this.bounds[0], this.bounds[1]);
        }
        this.previousOffset = this.getCurrentPosition();
    }

    protected void parsePI() throws SAXException, IOException {
        boolean flag = false;
        String s = this.reader.scanQName();
        if (s.toLowerCase().equals("xml")) {
            this.err.error0(109, 0);
            flag = true;
        }
        boolean flag1 = this.reader.skipWhiteSpace();
        String s1 = this.reader.scanPI();
        if (!flag1 && s1.length() != 0) {
            this.err.error0(190, 0);
        }
        if (!flag) {
            if (s1 == "") {
                this.err.error1(205, 1, "?>");
            }
            this.cntHandler.processingInstruction(s, s1);
        }
        this.previousOffset = this.getCurrentPosition();
    }

    protected void parseCStyleComment() throws SAXException, IOException {
        char[] ac = this.reader.scanCStyleComment(this.bounds);
        if (this.bounds[1] > 0) {
            this.lexHandler.comment(ac, this.bounds[0], this.bounds[1]);
        }
        this.previousOffset = this.getCurrentPosition();
    }

    protected String parseAttrEntityRef() throws SAXException, IOException {
        String s = "";
        XMLEntity xmlentity = this.parseEntity(false);
        if (xmlentity == null) {
            return "";
        }
        if (xmlentity.getSystemId() != null) {
            this.err.error0(127, 0);
            return "";
        }
        if (xmlentity.getLength() == -1) {
            return xmlentity.getValue();
        }
        if (!this.reader.pushEntityRef(xmlentity)) {
            return "";
        }
        int[] ai = new int[2];
        while (true) {
            String s1 = this.reader.scanAttrString(65535);
            s = s.concat(s1);
            if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                return s;
            }
            if (this.reader.tryRead(60)) {
                this.err.error0(126, 0);
                continue;
            }
            if (!this.reader.tryRead(38)) continue;
            s = s.concat(this.parseAttrEntityRef());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String parseAttrValue() throws SAXException, IOException {
        if (!this.isQuote()) {
            return this.getNoQuotesAttrValue();
        }
        i = this.reader.read();
        s = this.getSpecialAttrValue();
        if (s == null) {
            s = "";
        }
        if (this.reader.peek() == 60) {
            s = s + this.getCorrectValue(i);
            return s;
        }
        do lbl-1000:
        // 3 sources

        {
            s = s == null ? this.reader.scanAttrString(i) : s.concat(this.reader.scanAttrString(i));
            if (this.reader.tryRead(62)) {
                this.reader.push('>');
                return s;
            }
            if (!this.reader.tryRead(i)) {
                if (this.reader.tryRead(60)) {
                    this.reader.push('<');
                    if (s == null) {
                        s = "";
                    }
                    if ((value = this.getSpecialAttrValue()) != null) {
                        s = s + value;
                    }
                    if (this.reader.tryRead(i)) {
                        return s;
                    }
                    if (this.reader.peek() == 60) {
                        s = s + this.getCorrectValue(i);
                        return s;
                    }
                } else {
                    if (!this.reader.tryRead(38)) continue;
                    s = s.concat(this.parseAttrEntityRef());
                }
            } else {
                return s;
            }
            if (!this.reader.isEOF()) ** GOTO lbl-1000
        } while (!this.reader.isEOF());
        this.err.error0(193, 0);
        return s;
    }

    /*
     * Unable to fully structure code
     */
    protected String parseAttrValueWithoutQuotes() throws SAXException, IOException {
        s = this.getSpecialAttrValue();
        if (s == null) {
            s = "";
        }
        i = this.reader.peek();
        do lbl-1000:
        // 3 sources

        {
            s = s.concat(this.reader.scanAttrStringWithoutQuotes(i));
            c = this.reader.peek();
            if (XMLReader.isWhiteSpaceChar[c & 127] && c < 127) {
                return s;
            }
            if (c == 62) {
                return s;
            }
            if (!this.reader.tryRead(i)) {
                if (this.reader.tryRead(60)) {
                    this.err.error0(126, 0);
                } else {
                    if (!this.reader.tryRead(38)) continue;
                    s = s.concat(this.parseAttrEntityRef());
                }
            } else {
                return s;
            }
            if (!this.reader.isEOF()) ** GOTO lbl-1000
        } while (!this.reader.isEOF());
        this.err.error0(193, 0);
        return s;
    }

    protected boolean isQuote() throws SAXException, IOException {
        int c = this.reader.peek();
        return c == 39 || c == 34;
    }

    private String getCorrectValue(int i) throws SAXException, IOException {
        String s = "";
        boolean lastEqual = false;
        boolean balanceEquals = false;
        while (!this.reader.isEOF() && !this.reader.tryRead(i)) {
            String value = null;
            value = this.getSpecialAttrValue();
            if (value != null) {
                s = s + value;
                continue;
            }
            int c = this.reader.read();
            if (!XMLReader.isWhiteSpaceChar[c & 0x7F] || c >= 127) {
                if (c == 61 && i == this.reader.peek()) {
                    lastEqual = true;
                    balanceEquals = true;
                } else {
                    lastEqual = false;
                }
            }
            s = s + (char)c;
            if (lastEqual && i == this.reader.peek()) {
                s = s + (char)this.reader.read();
                continue;
            }
            if (!balanceEquals || i != this.reader.peek()) continue;
            s = s + (char)this.reader.read();
            balanceEquals = false;
        }
        return s;
    }
}

