/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.InputStream;
import oracle.jdevimpl.xml.dtd.parser.ParserError;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.xml.util.ArrayPool;

class XMLByteReader {
    static final int DEFAULT_SAVE = 32;
    static final int LITTLE_ENDIAN = 1;
    static final int BIG_ENDIAN = 2;
    static final int OCTET_2143 = 3;
    static final int OCTET_3412 = 4;
    char[] charBuffer;
    int charPos;
    int endPos;
    int eofPos;
    byte[] byteBuffer;
    int byteIndex;
    int endIndex;
    int eofIndex;
    int[] lineNumbers;
    int lineNumSize = 1024;
    int lastLine;
    int cumLine;
    int curLine;
    int first = 0;
    int second = 1;
    int third = 2;
    int fourth = 3;
    InputStream in;
    boolean closeInput;
    String sysId;
    String pubId;
    XMLEntity en;
    ParserError err;
    boolean bufferFreed;
    int BUFSIZE;
    private static final byte[] newLine = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
    static final int DEFAULT_BUFSIZE = 16388;
    static final int INFINITY = Integer.MAX_VALUE;

    XMLByteReader() {
        this(16388);
    }

    XMLByteReader(int i) {
        this.BUFSIZE = i;
        if (this.BUFSIZE == 16388) {
            this.charBuffer = ArrayPool.allocCharArrDefault();
            this.byteBuffer = ArrayPool.allocByteArrDefault();
        } else {
            this.charBuffer = new char[this.BUFSIZE];
            this.byteBuffer = new byte[this.BUFSIZE];
        }
        this.lineNumbers = new int[this.lineNumSize];
        this.reset();
    }

    XMLByteReader(InputStream inputstream, String s, String s1) {
        this();
        this.in = inputstream;
        this.sysId = s;
        this.pubId = s1;
    }

    void close() throws IOException {
        if (this.in != null && this.closeInput) {
            this.in.close();
        }
        if (!this.bufferFreed && this.BUFSIZE == 16388) {
            ArrayPool.freeCharArrDefault((char[])this.charBuffer);
            ArrayPool.freeByteArrDefault((byte[])this.byteBuffer);
            this.bufferFreed = true;
        }
    }

    void fillBuffer() throws IOException {
        while (true) {
            try {
                block8: while (true) {
                    byte byte0 = this.byteBuffer[this.byteIndex];
                    switch (newLine[byte0 & 0xFF]) {
                        case 0: {
                            this.charBuffer[this.endPos] = (char)byte0;
                            ++this.endPos;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 1: {
                            this.charBuffer[this.endPos] = 10;
                            this.setLineNumber(this.endPos);
                            ++this.endPos;
                            ++this.byteIndex;
                            if (byte0 != 13 || this.byteBuffer[this.byteIndex] != 10) continue block8;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 3: {
                            if (this.byteIndex >= this.eofIndex) {
                                this.setEOF(this.endPos);
                                return;
                            }
                            this.charBuffer[this.endPos] = (char)byte0;
                            ++this.endPos;
                            ++this.byteIndex;
                            continue block8;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException _ex) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    void fillByteBuffer() throws IOException {
        int i;
        boolean flag = false;
        int j = this.BUFSIZE;
        if (this.byteIndex != this.endIndex) {
            System.arraycopy(this.byteBuffer, this.byteIndex, this.byteBuffer, 0, this.endIndex - this.byteIndex);
        }
        this.endIndex -= this.byteIndex;
        this.byteIndex = 0;
        for (j = this.BUFSIZE - this.endIndex; j != 0; j -= i) {
            i = this.in.read(this.byteBuffer, this.endIndex, j);
            if (i != -1) {
                this.endIndex += i;
                continue;
            }
            if (this.endIndex < this.BUFSIZE) {
                this.byteBuffer[this.endIndex] = -1;
            }
            this.eofIndex = this.endIndex;
            break;
        }
    }

    char[] getBuffer() {
        return this.charBuffer;
    }

    int getColumnNumber() {
        this.getLineNumber();
        return this.charPos - this.lineNumbers[this.lastLine - 1];
    }

    int getLineNumber() {
        int i = this.lastLine;
        while (i < this.curLine) {
            if (this.charPos <= this.lineNumbers[i]) {
                this.lastLine = i;
                return this.cumLine + i;
            }
            ++i;
        }
        this.lastLine = this.curLine;
        return this.cumLine + this.curLine;
    }

    int getPosition() {
        return this.charPos;
    }

    int getLineGivenOffset(int offset) {
        int line;
        int i = line = 0;
        while (i < this.curLine + 1) {
            if (offset <= this.lineNumbers[i]) {
                return this.cumLine + i;
            }
            ++i;
        }
        return this.cumLine + this.curLine;
    }

    int getColumnGivenOffset(int offset) {
        return offset - this.lineNumbers[this.getLineGivenOffset(offset) - 1];
    }

    void growBuffer() throws IOException {
        char[] ac = new char[this.BUFSIZE * 2];
        System.arraycopy(this.charBuffer, 0, ac, 0, this.endPos);
        byte[] abyte0 = new byte[this.BUFSIZE * 2];
        System.arraycopy(this.byteBuffer, 0, abyte0, 0, this.endIndex);
        if (!this.bufferFreed && this.BUFSIZE == 16388) {
            ArrayPool.freeCharArrDefault((char[])this.charBuffer);
            ArrayPool.freeByteArrDefault((byte[])this.byteBuffer);
            this.bufferFreed = true;
        }
        this.BUFSIZE *= 2;
        this.charBuffer = ac;
        this.byteBuffer = abyte0;
        if (this.eofIndex < this.BUFSIZE) {
            this.byteBuffer[this.eofIndex] = -1;
        } else {
            this.fillByteBuffer();
        }
        this.fillBuffer();
    }

    boolean isEOF() {
        return this.eofPos != Integer.MAX_VALUE;
    }

    void pushBytes(int[] ai, int i, int j) {
        while (j > i) {
            this.byteBuffer[--this.byteIndex] = (byte)ai[--j];
        }
    }

    int pushChar(char c) {
        this.charBuffer[--this.charPos] = c;
        return this.charPos;
    }

    int pushChars(char[] ac, int i, int j) {
        while (j > i) {
            this.charBuffer[--this.charPos] = ac[--j];
        }
        return this.charPos;
    }

    void reset() {
        this.bufferFreed = false;
        this.charPos = this.BUFSIZE;
        this.endPos = this.BUFSIZE;
        this.byteIndex = this.BUFSIZE;
        this.endIndex = this.BUFSIZE;
        this.eofPos = Integer.MAX_VALUE;
        this.eofIndex = Integer.MAX_VALUE;
        this.lineNumbers[0] = this.BUFSIZE - 1;
        this.lastLine = 0;
        this.cumLine = 0;
        this.curLine = 1;
    }

    void resetLineNumber(int i) {
        int j = this.BUFSIZE - i;
        if (j != 0) {
            System.arraycopy(this.charBuffer, i, this.charBuffer, 0, j);
        }
        int k = this.curLine - 1;
        int l = this.curLine - 1;
        while (l >= 0) {
            if (i > this.lineNumbers[l]) {
                k = l;
                break;
            }
            --l;
        }
        int i1 = k;
        int j1 = 0;
        while (i1 < this.curLine) {
            this.lineNumbers[j1] = this.lineNumbers[i1] - i;
            ++i1;
            ++j1;
        }
        this.curLine -= k;
        this.cumLine += k;
        this.lastLine = 0;
    }

    int saveBuffer(int i) throws IOException {
        if (i == 0) {
            this.growBuffer();
            return i;
        }
        int j = i;
        if (i == this.BUFSIZE) {
            j = this.BUFSIZE - 32;
        }
        this.resetLineNumber(j);
        this.charPos = i - j;
        this.endPos -= j;
        this.fillBuffer();
        return this.charPos;
    }

    void setByteOrder(int i) {
    }

    void setCloseInput(boolean flag) {
        this.closeInput = flag;
    }

    void setEOF(int i) {
        this.eofPos = i;
        if (i < this.BUFSIZE) {
            this.charBuffer[i] = 65535;
        }
    }

    void setError(ParserError error) {
        this.err = error;
    }

    void setLineNumber(int i) {
        try {
            this.lineNumbers[this.curLine++] = i;
        }
        catch (ArrayIndexOutOfBoundsException _ex) {
            int[] ai = this.lineNumbers;
            this.lineNumbers = new int[this.lineNumSize * 2];
            System.arraycopy(ai, 0, this.lineNumbers, 0, this.lineNumSize);
            this.lineNumSize *= 2;
            this.lineNumbers[this.curLine++] = i;
        }
    }

    void setPosition(int i) {
        this.charPos = i;
    }
}

