/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.jdevimpl.xml.dtd.parser.XMLByteReader;
import oracle.xml.parser.v2.XMLConstants;

class XMLCharReader
extends XMLByteReader {
    Reader reader;
    boolean fixedCoords;
    XMLByteReader prevReader;
    boolean lastCharNewLine;
    static final int[] CP037ToUTF8 = new int[]{-1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, -1, -1, 34, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, -1, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, -1, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, -1, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1};

    public XMLCharReader(Reader reader, String sysId, String pubId) {
        this.reader = reader;
        this.sysId = sysId;
        this.pubId = pubId;
    }

    public XMLCharReader(String s, String sysId, String pubId) {
        super(s.length());
        this.sysId = sysId;
        this.pubId = pubId;
        this.charPos = 0;
        this.eofPos = this.endPos = s.length();
        s.getChars(0, this.endPos, this.charBuffer, 0);
        this.fixedCoords = true;
    }

    public void setEncoding(String s) throws IOException {
        this.reader = new InputStreamReader(this.in, s);
    }

    void close() throws IOException {
        if (this.reader != null && this.closeInput) {
            this.reader.close();
        }
        super.close();
    }

    void fillBuffer() throws IOException {
        if (this.fixedCoords) {
            return;
        }
        int i = 0;
        int j = this.BUFSIZE - this.endPos;
        boolean flag = false;
        while (j > 0 && i != -1) {
            i = this.reader.read(this.charBuffer, this.endPos, j);
            if (i == -1) continue;
            int i1 = this.endPos + i - 1;
            int k = 0;
            int l = this.endPos;
            if (this.lastCharNewLine) {
                if (this.charBuffer[this.endPos] == '\n') {
                    ++k;
                    ++l;
                }
                this.lastCharNewLine = false;
            }
            if (k == 0) {
                while (l < i1) {
                    char c = this.charBuffer[l];
                    if (c == '\n' || c == '\r') {
                        this.setLineNumber(l);
                        if (c == '\r' && this.charBuffer[l + 1] == '\n') {
                            this.charBuffer[l] = 10;
                            ++k;
                            l += 2;
                            break;
                        }
                        this.charBuffer[l] = 10;
                    }
                    ++l;
                }
            }
            while (l < i1) {
                char c1 = this.charBuffer[l];
                if (c1 == '\n' || c1 == '\r') {
                    this.setLineNumber(l - k);
                    if (c1 == '\r' && this.charBuffer[l + 1] == '\n') {
                        this.charBuffer[l - k] = 10;
                        ++k;
                        ++l;
                    } else {
                        this.charBuffer[l - k] = 10;
                    }
                } else {
                    this.charBuffer[l - k] = this.charBuffer[l];
                }
                ++l;
            }
            if (l == i1) {
                if (this.charBuffer[l] == '\r') {
                    this.lastCharNewLine = true;
                    this.charBuffer[l - k] = 10;
                } else {
                    this.charBuffer[l - k] = this.charBuffer[l];
                }
            }
            this.endPos += (i -= k);
            j -= i;
        }
        if (i == -1) {
            this.setEOF(this.endPos);
        }
    }

    void fillByteBuffer() throws IOException {
    }

    int fillXMLDecl(InputStream inputstream) throws IOException {
        this.in = inputstream;
        char[] ac = XMLConstants.cPIEND;
        int byte0 = 2;
        int i = 0;
        boolean flag = false;
        int k = 0;
        while (i < byte0) {
            int j = inputstream.read();
            if (j == -1) break;
            j = CP037ToUTF8[j];
            this.charBuffer[k++] = (char)j;
            if (j == ac[i]) {
                ++i;
                continue;
            }
            i = 0;
        }
        if (i != byte0) {
            return -1;
        }
        System.arraycopy(this.charBuffer, 0, this.charBuffer, this.BUFSIZE - k, k);
        this.charPos = this.BUFSIZE - k;
        this.endPos = this.BUFSIZE;
        return this.charPos;
    }

    int getColumnNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    int getLineNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getLineNumber();
        }
        return super.getLineNumber();
    }

    void reset() {
        if (this.fixedCoords) {
            this.charPos = 0;
            this.eofPos = this.endPos;
        } else {
            super.reset();
        }
        this.lastCharNewLine = false;
    }

    void setPrevReader(XMLByteReader xmlbytereader) {
        this.prevReader = xmlbytereader;
    }
}

