/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdConstrainingFacet;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdFactory;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdeveloper.xml.dtd.grammar.DtdSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import oracle.jdevimpl.xml.dtd.parser.AbstractDtdParser;
import oracle.jdevimpl.xml.dtd.parser.AbstractParser;
import oracle.jdevimpl.xml.dtd.parser.DtdElementContentParser;
import oracle.xml.parser.v2.XMLConstants;
import org.xml.sax.SAXException;

public class XmlDtdParser
extends AbstractDtdParser {
    private DtdElementContentParser _contentParser;

    public XmlDtdParser() {
    }

    XmlDtdParser(XmlDtdParser xmlDtdParser) {
        super(xmlDtdParser);
    }

    XmlDtdParser(AbstractParser abstractParser, DtdLoader loader) {
        super(abstractParser, loader);
    }

    public void parseElementDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        String elemName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(elemName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(elemName);
        }
        this.reader.requireWhiteSpace();
        DtdElementContentParser.Content contentRV = this.getContentParser().parseContent(this.err, this.reader);
        ComplexType contentType = contentRV.type;
        Object contentValidator = null;
        this.dtdNamespaceLoader.setElementDefinition(element, contentType, true, true);
        this.dtdNamespaceLoader.addElement(element);
        String contentAsString = XmlDtdParser.getContentString(contentType);
        this.declHandler.elementDecl(element.getName(), contentAsString);
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    public void parseWhiteSpace() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
    }

    public void parseAttlistDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        String elemName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(elemName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(elemName);
        }
        boolean hasMoreAttributes = this.reader.skipWhiteSpace();
        while (hasMoreAttributes && !this.reader.tryRead(62)) {
            DtdAttribute attribute = this.parseAttlist(elemName);
            if (attribute != null) {
                this.dtdNamespaceLoader.addAttribute(element, attribute);
            }
            hasMoreAttributes = this.reader.skipWhiteSpace();
        }
        if (!hasMoreAttributes && !this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    protected int processParseEntityValue(int i) throws SAXException, IOException {
        this.err.error0(119, 0);
        return i;
    }

    private DtdAttribute parseAttlist(String elementName) throws SAXException, IOException {
        SimpleType simpleType;
        String attrName = this.reader.scanQName();
        int attrType = 3;
        boolean hasEnumConstraint = false;
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cCDATA, 0, XMLConstants.cCDATA.length)) {
            attrType = 3;
        } else if (this.reader.tryRead(XMLConstants.cIDREFS, 0, XMLConstants.cIDREFS.length)) {
            attrType = 6;
        } else if (this.reader.tryRead(XMLConstants.cIDREF, 0, XMLConstants.cIDREF.length)) {
            attrType = 1;
        } else if (this.reader.tryRead(XMLConstants.cID, 0, XMLConstants.cID.length)) {
            attrType = 14;
        } else if (this.reader.tryRead(XMLConstants.cENTITY, 0, XMLConstants.cENTITY.length)) {
            attrType = 2;
        } else if (this.reader.tryRead(XMLConstants.cENTITIES, 0, XMLConstants.cENTITIES.length)) {
            attrType = 7;
        } else if (this.reader.tryRead(XMLConstants.cNMTOKENS, 0, XMLConstants.cNMTOKENS.length)) {
            attrType = 8;
        } else if (this.reader.tryRead(XMLConstants.cNMTOKEN, 0, XMLConstants.cNMTOKEN.length)) {
            attrType = 5;
        } else if (this.reader.tryRead(XMLConstants.cNOTATION, 0, XMLConstants.cNOTATION.length)) {
            attrType = 9;
            this.reader.requireWhiteSpace();
            hasEnumConstraint = true;
        } else if (this.reader.tryRead(40)) {
            attrType = 3;
            hasEnumConstraint = true;
        } else {
            this.err.error0(133, 0);
            attrType = 3;
        }
        DtdConstrainingFacet enumFacet = null;
        StringBuffer enumStr = null;
        if (hasEnumConstraint) {
            enumFacet = DtdFactory.getConstrainingFacet(this.dtdNamespaceLoader, 10);
            enumStr = new StringBuffer(40);
            if (attrType == 9 && !this.reader.tryRead(40)) {
                this.err.error1(100, 0, "(");
            }
            while (!this.reader.isEOF()) {
                this.reader.skipWhiteSpace();
                String listValue = attrType == 9 ? this.reader.scanQName() : this.reader.scanNmToken();
                try {
                    enumFacet.setValue(listValue);
                }
                catch (Exception e) {
                    this.err.error0(1, 0);
                }
                enumStr.append(listValue);
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(124)) {
                    enumStr.append('|');
                    continue;
                }
                if (this.reader.tryRead(41)) break;
                this.err.error2(101, 0, ")", "|");
            }
            enumStr.append(')');
        }
        boolean isRequired = false;
        boolean isFixed = false;
        boolean isImplied = false;
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(35)) {
            if (this.reader.tryRead(XMLConstants.cFIXED, 0, XMLConstants.cFIXED.length)) {
                isFixed = true;
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(XMLConstants.cREQUIRED, 0, XMLConstants.cREQUIRED.length)) {
                isRequired = true;
            } else if (this.reader.tryRead(XMLConstants.cIMPLIED, 0, XMLConstants.cIMPLIED.length)) {
                isImplied = true;
            } else {
                this.err.error0(288, 0);
            }
        }
        String attrValue = null;
        if (this.isQuote()) {
            attrValue = this.parseAttrValue();
        }
        String attrDefaultValue = null;
        String attrFixedValue = null;
        if (isFixed) {
            if (attrValue == null) {
                this.err.error0(1, 0);
            }
            attrFixedValue = attrValue;
        } else {
            attrDefaultValue = attrValue;
        }
        if (enumFacet != null) {
            SimpleType baseType = GrammarFactory.getBuiltInType(attrType);
            DtdSimpleType dtdSimpleType = DtdFactory.getSimpleType(this.dtdNamespaceLoader, baseType);
            dtdSimpleType.addConstrainingFacet(enumFacet);
            simpleType = dtdSimpleType;
        } else {
            simpleType = GrammarFactory.getBuiltInType(attrType);
        }
        String constraint = "";
        if (isRequired) {
            constraint = "#REQUIRED";
        } else if (isFixed) {
            constraint = "#FIXED";
        } else if (isImplied) {
            constraint = "#IMPLIED";
        } else if (enumFacet != null) {
            constraint = enumStr.toString();
        }
        this.declHandler.attributeDecl(elementName, attrName, DtdFactory.typeToString(attrType), constraint, attrValue);
        DtdAttribute attribute = this.dtdNamespaceLoader.createAttribute(attrName, isRequired, attrDefaultValue, attrFixedValue, simpleType);
        return attribute;
    }

    protected DtdElementContentParser getContentParser() {
        if (this._contentParser == null) {
            this._contentParser = new DtdElementContentParser(this.dtdNamespaceLoader, true);
        }
        return this._contentParser;
    }

    protected static String getContentString(ComplexType type) {
        switch (type.getDerivationMethod()) {
            case 2: {
                return XmlDtdParser.getGroupString(type.getContentGroup());
            }
            case 0: {
                String baseGroup = XmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String inclusion = " +" + XmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + inclusion;
            }
            case 1: {
                String baseGroup = XmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String exclusion = " -" + XmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + exclusion;
            }
        }
        return "#ANY";
    }

    protected static String getGroupString(ContentGroup group) {
        if (group != null) {
            return group.toString();
        }
        return "EMPTY";
    }
}

