/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.daf;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.daf.DafUtils;
import oracle.bali.xml.daf.DeclarationDafNodeType;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.refinfo2.DeclarationInfo;
import oracle.bali.xml.model.metadata.refinfo2.DeclarationInfoFactory;
import oracle.bali.xml.model.metadata.refinfo2.RefInfo2;
import oracle.bali.xml.model.metadata.refinfo2.RefInfoFactory;
import oracle.javatools.daf.DafLanguagePlugin;
import oracle.javatools.daf.DafManager;
import oracle.javatools.daf.model.DafAttributes;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafEdgeType;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.model.DafNodeType;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.util.DafSet;
import oracle.javatools.daf.util.ProgressTracker;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractXmlDafLanguagePlugin
extends DafLanguagePlugin {
    static final String __XMLEF_DAF_PLUGIN_ID = "xmlef";
    private static final Logger _LOGGER = Logger.getLogger(AbstractXmlDafLanguagePlugin.class.getName());
    static final String __XMLEF_DECL_BASE_TYPE = "oracle.bali.xml.daf.DeclarationBaseType";
    final DafNodeType __declarationNodeBaseType;

    protected AbstractXmlDafLanguagePlugin() {
        super((CharSequence)__XMLEF_DAF_PLUGIN_ID);
        this.$init$();
    }

    public void initialize(DafManager manager) {
        super.initialize(manager);
        manager.register(this.__declarationNodeBaseType);
    }

    public final void phaseOne(DafLanguagePlugin.PhaseOneContext dafContext, ProgressTracker progress) {
        DafGraph graph = dafContext.getGraph();
        DafUrlNode urlNode = dafContext.getUrlNode();
        URL url = urlNode.getURL();
        if (url == null) {
            _LOGGER.log(Level.WARNING, "Null URL passed to phaseOne; DafUrlNode={0}", urlNode);
            return;
        }
        XmlContext context = this.getXmlContext(graph, urlNode, url);
        if (context != null) {
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                TreeTraversal traversal = model.getTreeTraversal();
                Node firstChild = traversal.getFirstChild((Node)model.getDocument());
                for (Node node : traversal.allNodes(firstChild)) {
                    try {
                        this._addDeclarationNodes(urlNode, graph, model, node);
                        NamedNodeMap attributes = node.getAttributes();
                        if (attributes == null || attributes.getLength() <= 0) continue;
                        int i = 0;
                        while (i < attributes.getLength()) {
                            this._addDeclarationNodes(urlNode, graph, model, attributes.item(i));
                            ++i;
                        }
                    }
                    catch (ThreadDeath td) {
                        graph.getOwningInstance().getLogger().log(Level.SEVERE, td.getMessage(), td);
                        throw td;
                    }
                    catch (Throwable t) {
                        graph.getOwningInstance().getLogger().log(Level.SEVERE, t.getMessage(), t);
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
    }

    public final void phaseTwo(DafLanguagePlugin.PhaseTwoContext dafContext, ProgressTracker progress) {
        DafGraph graph = dafContext.getGraph();
        DafSet urlNodes = dafContext.getUrlNodes();
        int count = urlNodes.size();
        int i = 0;
        for (DafUrlNode urlNode : urlNodes) {
            if (progress.isCancelled()) {
                return;
            }
            this._phaseTwo(graph, urlNode);
            progress.setProgress((double)(++i) / (double)count);
        }
    }

    protected abstract XmlContext getXmlContext(DafGraph var1, DafUrlNode var2, URL var3);

    private void _addDeclarationNodes(DafUrlNode urlNode, DafGraph graph, XmlModel model, Node node) {
        XmlKey key = model.getNodeXmlKey(node);
        DeclarationInfoFactory factory = model.getXmlMetadataResolver().getDeclarationInfoFactory(key);
        if (factory != null) {
            String text = DafUtils.__getTextContent(node);
            if (!ModelUtil.hasLength((String)text)) {
                return;
            }
            Collection<? extends DeclarationInfo> infos = factory.getDeclarationInfos(model.getContext(), node, text);
            if (infos != null) {
                for (DeclarationInfo declarationInfo : infos) {
                    Map<? extends CharSequence, ? extends CharSequence> attributes = declarationInfo.getAttributes(model, node);
                    if (attributes == null) continue;
                    DafNodeType declType = this.manager.getRegistry().getAutoNodeType(declarationInfo.getDeclarationType(), (CharSequence)__XMLEF_DECL_BASE_TYPE);
                    DafNode dafNode = graph.getOwningInstance().newDafNode(declType.getName());
                    DafUtils.addAttributes((DafAttributes)dafNode, attributes);
                    DafUtils.setNodeInfo(node, (DafAttributes)dafNode);
                    DafUtils.__setIndices((DafAttributes)dafNode, declarationInfo.getStartIndex(), declarationInfo.getEndIndex());
                    this._addNodeToGraph(graph, urlNode, dafNode);
                }
            }
        }
    }

    private void _phaseTwo(DafGraph graph, DafUrlNode urlNode) {
        URL url = urlNode.getURL();
        if (url == null) {
            _LOGGER.log(Level.WARNING, "Null URL passed to phaseTwo; DafUrlNode={0}", urlNode);
            return;
        }
        XmlContext context = this.getXmlContext(graph, urlNode, url);
        if (context != null) {
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                TreeTraversal traversal = model.getTreeTraversal();
                Node firstChild = traversal.getFirstChild((Node)model.getDocument());
                for (Node node : traversal.allNodes(firstChild)) {
                    try {
                        this._addReferenceNodes(urlNode, graph, model, node);
                        NamedNodeMap attributes = node.getAttributes();
                        if (attributes == null || attributes.getLength() <= 0) continue;
                        int i = 0;
                        while (i < attributes.getLength()) {
                            this._addReferenceNodes(urlNode, graph, model, attributes.item(i));
                            ++i;
                        }
                    }
                    catch (ThreadDeath td) {
                        graph.getOwningInstance().getLogger().log(Level.SEVERE, td.getMessage(), td);
                        throw td;
                    }
                    catch (Throwable t) {
                        graph.getOwningInstance().getLogger().log(Level.SEVERE, t.getMessage(), t);
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
    }

    private void _addReferenceNodes(DafUrlNode urlNode, DafGraph graph, XmlModel model, Node node) {
        XmlKey key = model.getNodeXmlKey(node);
        RefInfoFactory factory = model.getXmlMetadataResolver().getRefInfoFactory(key);
        if (factory != null) {
            String text = DafUtils.__getTextContent(node);
            if (!ModelUtil.hasLength((String)text)) {
                return;
            }
            Collection<? extends RefInfo2> refInfos = factory.getRefInfos(model.getContext(), node, text);
            if (refInfos != null) {
                for (RefInfo2 refInfo2 : refInfos) {
                    NodeCriteria targetCriteria = refInfo2.getTargetCriteria(model, node);
                    if (targetCriteria == null) continue;
                    CharSequence edgeType = refInfo2.getReferenceType();
                    this._registerEdgeTypeIfNeeded(edgeType);
                    DafEdge edge = graph.getOwningInstance().newDafEdge(edgeType);
                    DafUtils.setNodeInfo(node, (DafAttributes)edge);
                    DafUtils.__setIndices((DafAttributes)edge, refInfo2.getStartIndex(), refInfo2.getEndIndex());
                    edge.setFromNode((DafNode)urlNode);
                    edge.setToNode(targetCriteria);
                    graph.add(edge);
                }
            }
        }
    }

    private void _addNodeToGraph(DafGraph graph, DafUrlNode urlNode, DafNode dafNode) {
        dafNode.setContainingURL(urlNode.getURL());
        graph.add(dafNode);
    }

    private void _registerEdgeTypeIfNeeded(CharSequence edgeType) {
        if (this.manager.getRegistry().getEdgeType(edgeType) == null) {
            this.manager.register(DafEdgeType.createType((CharSequence)edgeType, null));
        }
    }

    private void $init$() {
        this.__declarationNodeBaseType = new DeclarationDafNodeType(__XMLEF_DECL_BASE_TYPE, Collections.emptyList());
    }
}

