/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.daf;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.daf.AbstractXmlDafLanguagePlugin;
import oracle.bali.xml.daf.Finder;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.refinfo2.BaseRefDeclInfo;
import oracle.bali.xml.model.metadata.refinfo2.DeclarationInfo;
import oracle.bali.xml.model.metadata.refinfo2.DeclarationInfoFactory;
import oracle.bali.xml.model.metadata.refinfo2.RefInfo2;
import oracle.bali.xml.model.metadata.refinfo2.RefInfoFactory;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.daf.DafManager;
import oracle.javatools.daf.model.DafAttributes;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafEdgeVisitor;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafItem;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.model.DafNodeVisitor;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.query.EdgeCriteria;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.query.SimpleEdgeCriteria;
import oracle.javatools.daf.query.SimpleNodeCriteria;
import oracle.javatools.daf.util.FString;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DafUtils {
    static final Logger __LOGGER = Logger.getLogger(DafUtils.class.getName());
    private static final String _KEY_ATTR_NS = "dom-attr-ns";
    private static final String _KEY_ATTR_NAME = "dom-attr-name";
    private static final String _KEY_DOM_PATH = "dom-path";
    private static final String _KEY_INDICES = "valueIndices";
    private static final Pattern _REGEX_INDICES = Pattern.compile("(\\d+)-(\\d+)");

    public static DafEdge getEdgeById(DafGraph graph, long id) {
        SimpleEdgeCriteria sec = new SimpleEdgeCriteria();
        sec.putLong((CharSequence)DafEdge.KEY_UNID, id);
        return graph.getFirstMatch((EdgeCriteria)sec);
    }

    public static DafNode getNodeById(DafGraph graph, long id) {
        SimpleNodeCriteria nc = new SimpleNodeCriteria();
        nc.putLong((CharSequence)DafEdge.KEY_UNID, id);
        return graph.getFirstMatch((NodeCriteria)nc);
    }

    public static DafItem getItemById(DafGraph graph, long id, boolean isNode) {
        if (isNode) {
            return DafUtils.getNodeById(graph, id);
        }
        return DafUtils.getEdgeById(graph, id);
    }

    public static DafNode findDeclarationNodeContainingPosition(DafGraph graph, XmlContext context, DomPosition pos) {
        return Finder.__findDeclarationNodeContainingPosition(graph, context, pos);
    }

    public static DafNode findOnlyDeclarationNodeIncludingAttributes(DafGraph graph, XmlContext context, Node node) {
        SimpleNodeCriteria criteria = new SimpleNodeCriteria();
        criteria.setContainingURL(context.getURL());
        DafUtils.setNodeInfo(node, (DafAttributes)criteria);
        Collection nodes = graph.getNodes((NodeCriteria)criteria);
        if (!nodes.isEmpty()) {
            Iterator itor = nodes.iterator();
            DafNode first = (DafNode)itor.next();
            if (!itor.hasNext()) {
                return first;
            }
        }
        return null;
    }

    public static boolean hasReferenceInfo(XmlContext xmlContext, DomPosition pos) {
        if (pos == null) {
            return false;
        }
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        return !DafUtils.getReferenceInfos(xmlContext, node).isEmpty();
    }

    public static boolean hasOrPointsToDeclarations(XmlContext xmlContext, DomPosition pos) {
        if (pos == null) {
            return false;
        }
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        return DafUtils.hasOrPointsToDeclarations(xmlContext, node);
    }

    public static boolean hasOrPointsToDeclarations(XmlContext xmlContext, Node node) {
        if (node == null) {
            return false;
        }
        if (!DafUtils.getDeclarationInfos(xmlContext, node).isEmpty()) {
            return true;
        }
        if (!DafUtils.getReferenceInfos(xmlContext, node).isEmpty()) {
            return true;
        }
        if (1 == node.getNodeType()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr a = (Attr)attrs.item(i);
                if (!DafUtils.getDeclarationInfos(xmlContext, a).isEmpty()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Collection<? extends DeclarationInfo> getDeclarationInfos(XmlContext xmlContext, Node node) {
        Collection<? extends DeclarationInfo> infos;
        String text;
        XmlModel model = xmlContext.getModel();
        XmlKey key = model.getNodeXmlKey(node);
        DeclarationInfoFactory factory = model.getXmlMetadataResolver().getDeclarationInfoFactory(key);
        if (factory != null && ModelUtil.hasLength((String)(text = DafUtils.__getTextContent(node))) && (infos = factory.getDeclarationInfos(xmlContext, node, text)) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    public static Collection<? extends RefInfo2> getReferenceInfos(XmlContext xmlContext, Node node) {
        Collection<? extends RefInfo2> infos;
        String text;
        XmlModel model = xmlContext.getModel();
        XmlKey key = model.getNodeXmlKey(node);
        RefInfoFactory factory = model.getXmlMetadataResolver().getRefInfoFactory(key);
        if (factory != null && ModelUtil.hasLength((String)(text = DafUtils.__getTextContent(node))) && (infos = factory.getRefInfos(xmlContext, node, text)) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    public static DafEdge findReferenceEdgeContainingPosition(DafGraph graph, XmlContext context, DomPosition pos) {
        return Finder.__findReferenceNodeContainingPosition(graph, context, pos);
    }

    public static DomRange dafToDomRange(Document doc, DafAttributes dafObj) {
        if (doc == null) {
            return null;
        }
        Node node = DafUtils.dafToDomNode(doc, dafObj);
        if (node == null) {
            return null;
        }
        int[] startEnd = DafUtils.__getIndices(dafObj);
        if (startEnd != null) {
            return DomRange.create((DomPosition)DafUtils.__getDomPosition(node, startEnd[0]), (DomPosition)DafUtils.__getDomPosition(node, startEnd[1]), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
        }
        return null;
    }

    public static boolean isXmlDeclarationDafNode(DafGraph graph, DafNode dafNode) {
        DafManager manager = graph.getOwningInstance().getManager();
        AbstractXmlDafLanguagePlugin plugin = (AbstractXmlDafLanguagePlugin)manager.getLanguagePlugin("xmlef");
        return plugin.__declarationNodeBaseType.isAssignableFrom(dafNode.getNodeType());
    }

    public static void addAttributes(DafAttributes dafObj, Map<? extends CharSequence, ? extends CharSequence> map) {
        for (Map.Entry<? extends CharSequence, ? extends CharSequence> attr : map.entrySet()) {
            dafObj.put(attr.getKey(), attr.getValue());
        }
    }

    public static void setNodeInfo(Node node, DafAttributes attrs) {
        if (DomUtils.isAttribute((Node)node)) {
            Attr attr = (Attr)node;
            attrs.put((CharSequence)_KEY_ATTR_NAME, (CharSequence)DomUtils.getLocalName((Node)attr));
            String attrNS = attr.getNamespaceURI();
            if (attrNS != null) {
                attrs.put((CharSequence)_KEY_ATTR_NS, (CharSequence)attrNS);
            }
            node = attr.getOwnerElement();
        }
        attrs.put((CharSequence)_KEY_DOM_PATH, (CharSequence)DafUtils._createNodePathString(node));
    }

    public static Node dafToDomNode(Document document, DafAttributes attrs) {
        Node node = DafUtils._getJustNode(document, attrs);
        if (node == null) {
            return null;
        }
        FString attrName = attrs.get((CharSequence)_KEY_ATTR_NAME);
        if (attrName == null) {
            return node;
        }
        if (!DomUtils.isElement((Node)node)) {
            __LOGGER.log(Level.WARNING, "Attr name {0} found on non-Element {1}; DafNode={2}", new Object[]{attrName, node, attrs});
            return null;
        }
        FString attrNameNS = attrs.get((CharSequence)_KEY_ATTR_NS);
        String nsStr = attrNameNS == null ? null : attrNameNS.toString();
        Attr attr = ((Element)node).getAttributeNodeNS(nsStr, attrName.toString());
        if (attr == null) {
            __LOGGER.log(Level.WARNING, "Attr {0}:{1} not found on node {2}; DafNode={3}", new Object[]{nsStr, attrName, node, attrs});
            return null;
        }
        return attr;
    }

    public static NodeCriteria createUrlNodeCriteria(URL url) {
        return DafUrlNode.newURLCriteria((URL)url);
    }

    public static boolean matchesAnyEdges(DafGraph graph, SimpleEdgeCriteria sec) {
        Holder foundMatch = new Holder((Object)false);
        graph.taskToGetEdges((EdgeCriteria)sec, (DafEdgeVisitor)new 1(foundMatch)).run();
        return (Boolean)foundMatch.get();
    }

    public static boolean matchesAnyNodes(DafGraph graph, NodeCriteria criteria) {
        Holder foundMatch = new Holder((Object)false);
        graph.taskToGetNodes(criteria, (DafNodeVisitor)new 2(foundMatch)).run();
        return (Boolean)foundMatch.get();
    }

    public static SimpleEdgeCriteria findReferencesForNode(XmlContext context, Node node) {
        SimpleEdgeCriteria sec = new SimpleEdgeCriteria();
        sec.setFromNode(DafUtils.createUrlNodeCriteria(context.getURL()));
        DafUtils.setNodeInfo(node, (DafAttributes)sec);
        return sec;
    }

    public static Collection<DafEdge> findEdgesTargettingStubNodes(DafGraph graph, URL url) {
        if (graph == null || url == null) {
            throw new IllegalArgumentException("null param not allowed; graph=" + graph + " url=" + url);
        }
        SimpleEdgeCriteria edgeCriteria = new SimpleEdgeCriteria();
        edgeCriteria.setFromNode(DafUtils.createUrlNodeCriteria(url));
        SimpleNodeCriteria stubCriteria = new SimpleNodeCriteria();
        DafNode.requireStub((DafItem.DafCriteria)stubCriteria);
        edgeCriteria.setToNode((NodeCriteria)stubCriteria);
        return graph.getEdges((EdgeCriteria)edgeCriteria);
    }

    public static Pair<DeclarationInfo, Node> findDeclarationInfoAndNode(XmlModel model, DafNode dafNode) {
        int[] indices = DafUtils.__getIndices((DafAttributes)dafNode);
        if (indices == null) {
            return null;
        }
        return (Pair)new 3(dafNode, indices).run(model);
    }

    public static DeclarationInfo findDeclarationInfo(XmlModel model, DafNode dafNode) {
        return DafUtils._firstOfPair(DafUtils.findDeclarationInfoAndNode(model, dafNode));
    }

    public static RefInfo2 findRefInfo(XmlModel model, DafEdge dafEdge) {
        return DafUtils._firstOfPair(DafUtils.findRefInfoAndNode(model, dafEdge));
    }

    public static Pair<RefInfo2, Node> findRefInfoAndNode(XmlModel model, DafEdge dafEdge) {
        int[] indices = DafUtils.__getIndices((DafAttributes)dafEdge);
        if (indices == null) {
            return null;
        }
        return (Pair)new 4(dafEdge, indices).run(model);
    }

    public static void updateTextContent(Node node, BaseRefDeclInfo info, CharSequence newValue) {
        StringBuilder builder = new StringBuilder(DafUtils.__getTextContent(node));
        builder.replace(info.getStartIndex(), info.getEndIndex(), newValue.toString());
        if (DomUtils.isAttribute((Node)node)) {
            node.setNodeValue(builder.toString());
        } else {
            node.setTextContent(builder.toString());
        }
    }

    static String __getTextContent(Node node) {
        if (DomUtils.isAttribute((Node)node)) {
            return node.getNodeValue();
        }
        if (DomUtils.isElement((Node)node)) {
            String first = null;
            StringBuilder sb = null;
            Node child = node.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        String curValue = child.getNodeValue();
                        if (sb != null) {
                            sb.append(curValue);
                            break;
                        }
                        if (first == null) {
                            first = curValue;
                            break;
                        }
                        sb = new StringBuilder(first.length() + curValue.length());
                        sb.append(first);
                        sb.append(curValue);
                        first = null;
                        break;
                    }
                }
                child = child.getNextSibling();
            }
            if (sb != null) {
                return sb.toString();
            }
            if (first != null) {
                return first;
            }
            return null;
        }
        throw new IllegalArgumentException("invalid node type passed to __getTextContent: " + node);
    }

    static DomPosition __getDomPosition(Node node, int textContentIndex) {
        if (DomUtils.isAttribute((Node)node)) {
            return DomPositionFactory.createAttributePosition((Attr)((Attr)node), (int)textContentIndex);
        }
        if (DomUtils.isElement((Node)node)) {
            Node child = node.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        CharacterData cd = (CharacterData)child;
                        int cdLen = cd.getLength();
                        if (cdLen >= textContentIndex) {
                            return DomPositionFactory.createTextPosition((CharacterData)cd, (int)textContentIndex);
                        }
                        textContentIndex -= cdLen;
                        break;
                    }
                }
                child = child.getNextSibling();
            }
            throw new IllegalArgumentException("index " + textContentIndex + " not found in " + node);
        }
        throw new IllegalArgumentException("invalid node type passed to __getDomPosition: " + node);
    }

    static void __setIndices(DafAttributes dafObj, int startIndex, int endIndex) {
        dafObj.put((CharSequence)_KEY_INDICES, (CharSequence)(startIndex + "-" + endIndex));
    }

    static int[] __getIndices(DafAttributes dafObj) {
        RuntimeException err = null;
        FString indices = dafObj.get((CharSequence)_KEY_INDICES);
        if (ModelUtil.hasLength((CharSequence)indices)) {
            try {
                Matcher matcher = _REGEX_INDICES.matcher((CharSequence)indices);
                if (matcher.matches()) {
                    int[] ret = new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
                    int[] nArray = ret;
                    return nArray;
                }
            }
            catch (RuntimeException re) {
                err = re;
            }
        }
        LogRecord lr = new LogRecord(Level.WARNING, "Failed to decode indices on DAF obj {0}; indices={1}");
        lr.setParameters(new Object[]{dafObj, indices});
        lr.setThrown(err);
        __LOGGER.log(lr);
        return null;
    }

    private static <T> T _firstOfPair(Pair<T, ?> pair) {
        if (pair == null) {
            return null;
        }
        return (T)pair.getFirst();
    }

    private static String _createNodePathString(Node node) {
        int[] pathInts = DomUtils.getPathToNode((Node)node);
        StringBuffer buf = new StringBuffer(pathInts.length * 3);
        int i = 0;
        while (i < pathInts.length) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(String.valueOf(pathInts[i]));
            ++i;
        }
        return buf.toString();
    }

    private static Node _getJustNode(Document document, DafAttributes attrs) {
        FString domPath = attrs.get((CharSequence)_KEY_DOM_PATH);
        if (domPath != null) {
            String[] indicesStr = domPath.toString().split(",");
            int[] indices = new int[indicesStr.length];
            try {
                int i = 0;
                while (i < indicesStr.length) {
                    indices[i] = Integer.parseInt(indicesStr[i]);
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                __LOGGER.log(Level.WARNING, "Bad dom-path {0} in DafNode {1}; returning null node.", new Object[]{domPath, attrs});
                Node node = null;
                return node;
            }
            Node node = DomUtils.getNodeFromPath((Document)document, (int[])indices);
            if (node == null) {
                __LOGGER.log(Level.WARNING, "Null node found for dom-path {0} in DafNode {1}", new Object[]{domPath, attrs});
                return null;
            }
            return node;
        }
        return null;
    }

    private DafUtils() {
    }

    static final class 1
    implements DafEdgeVisitor {
        private final /* synthetic */ Holder v$foundMatch;

        public boolean visit(DafEdge edge) {
            this.v$foundMatch.set((Object)true);
            return false;
        }

        public 1(Holder holder) {
            this.v$foundMatch = holder;
        }
    }

    static final class 2
    implements DafNodeVisitor {
        private final /* synthetic */ Holder v$foundMatch;

        public boolean visit(DafNode edge) {
            this.v$foundMatch.set((Object)true);
            return false;
        }

        public 2(Holder holder) {
            this.v$foundMatch = holder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 3
    extends ReadOnlyTask {
        private final /* synthetic */ DafNode v$dafNode;
        private final /* synthetic */ int[] v$indices;

        protected Pair<DeclarationInfo, Node> runImpl(AbstractModel model) {
            Node node = DafUtils.dafToDomNode(model.getDocument(), (DafAttributes)this.v$dafNode);
            if (node == null) {
                return null;
            }
            String value = DafUtils.__getTextContent(node);
            if (!ModelUtil.hasLength((String)value)) {
                return null;
            }
            DeclarationInfoFactory dif = model.getXmlMetadataResolver().getDeclarationInfoFactory(node);
            if (dif == null) {
                return null;
            }
            for (DeclarationInfo declarationInfo : dif.getDeclarationInfos(model.getContext(), node, value)) {
                if (declarationInfo.getStartIndex() != this.v$indices[0] || declarationInfo.getEndIndex() != this.v$indices[1]) continue;
                return new Pair((Object)declarationInfo, (Object)node);
            }
            return null;
        }

        public 3(DafNode dafNode, int[] nArray) {
            this.v$indices = nArray;
            this.v$dafNode = dafNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 4
    extends ReadOnlyTask {
        private final /* synthetic */ DafEdge v$dafEdge;
        private final /* synthetic */ int[] v$indices;

        protected Pair<RefInfo2, Node> runImpl(AbstractModel model) {
            Node node = DafUtils.dafToDomNode(model.getDocument(), (DafAttributes)this.v$dafEdge);
            if (node == null) {
                return null;
            }
            String value = DafUtils.__getTextContent(node);
            if (!ModelUtil.hasLength((String)value)) {
                return null;
            }
            RefInfoFactory rif = model.getXmlMetadataResolver().getRefInfoFactory(node);
            if (rif == null) {
                return null;
            }
            Collection<? extends RefInfo2> rifs = rif.getRefInfos(model.getContext(), node, value);
            if (rifs == null) {
                return null;
            }
            for (RefInfo2 refInfo2 : rifs) {
                if (refInfo2.getStartIndex() != this.v$indices[0] || refInfo2.getEndIndex() != this.v$indices[1]) continue;
                return new Pair((Object)refInfo2, (Object)node);
            }
            return null;
        }

        public 4(DafEdge dafEdge, int[] nArray) {
            this.v$indices = nArray;
            this.v$dafEdge = dafEdge;
        }
    }
}

