/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.daf;

import java.util.Collection;
import java.util.logging.Level;
import oracle.bali.xml.daf.DafUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.daf.model.DafAttributes;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafItem;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.query.EdgeCriteria;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.query.SimpleEdgeCriteria;
import oracle.javatools.daf.query.SimpleNodeCriteria;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Finder<T extends DafItem> {
    private static Finder<DafNode> _DECL_FINDER = new 1();
    private static Finder<DafEdge> _REF_FINDER = new 2();

    static DafNode __findDeclarationNodeContainingPosition(DafGraph graph, XmlContext context, DomPosition pos) {
        return _DECL_FINDER.find(graph, context, pos);
    }

    static DafEdge __findReferenceNodeContainingPosition(DafGraph graph, XmlContext context, DomPosition pos) {
        return _REF_FINDER.find(graph, context, pos);
    }

    public T find(DafGraph graph, XmlContext context, DomPosition pos) {
        if (graph == null || context == null || pos == null) {
            throw new IllegalArgumentException("null param not allowed; graph=" + graph + " context=" + context + " pos=" + pos);
        }
        if (!(pos = DomPositionFactory.asTextOffsetPositionIfPossible((DomPosition)pos)).hasTextOffset()) {
            DafUtils.__LOGGER.log(Level.FINER, "Can't find from non-text pos {0}", pos);
            return null;
        }
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        if (node == null) {
            throw new IllegalArgumentException("can't get right node for pos " + pos);
        }
        for (DafItem edge : this.findCandidates(graph, context, node)) {
            DomRange range = DafUtils.dafToDomRange(node.getOwnerDocument(), (DafAttributes)edge);
            if (range == null) continue;
            return (T)edge;
        }
        return null;
    }

    protected abstract Collection<T> findCandidates(DafGraph var1, XmlContext var2, Node var3);

    Finder() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    extends Finder {
        protected Collection<DafNode> findCandidates(DafGraph graph, XmlContext context, Node node) {
            SimpleNodeCriteria criteria = new SimpleNodeCriteria();
            criteria.setContainingURL(context.getURL());
            DafUtils.setNodeInfo(node, (DafAttributes)criteria);
            return graph.getNodes((NodeCriteria)criteria);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    extends Finder {
        protected Collection<DafEdge> findCandidates(DafGraph graph, XmlContext context, Node node) {
            SimpleEdgeCriteria ec = new SimpleEdgeCriteria();
            DafUtils.setNodeInfo(node, (DafAttributes)ec);
            ec.setFromNode(DafUtils.createUrlNodeCriteria(context.getURL()));
            return graph.getEdges((EdgeCriteria)ec);
        }
    }
}

